/*
 * Decompiled with CFR 0.152.
 */
package org.reactnative.camera;

import android.support.annotation.Nullable;
import android.view.View;
import com.facebook.react.common.MapBuilder;
import com.facebook.react.uimanager.ThemedReactContext;
import com.facebook.react.uimanager.ViewGroupManager;
import com.facebook.react.uimanager.annotations.ReactProp;
import com.google.android.cameraview.AspectRatio;
import java.util.Map;
import org.reactnative.camera.RNCameraView;

public class CameraViewManager
extends ViewGroupManager<RNCameraView> {
    private static final String REACT_CLASS = "RNCamera";

    public void onDropViewInstance(RNCameraView view) {
        view.stop();
        super.onDropViewInstance((View)view);
    }

    public String getName() {
        return REACT_CLASS;
    }

    protected RNCameraView createViewInstance(ThemedReactContext themedReactContext) {
        return new RNCameraView(themedReactContext);
    }

    @Nullable
    public Map<String, Object> getExportedCustomDirectEventTypeConstants() {
        MapBuilder.Builder builder = MapBuilder.builder();
        for (Events event : Events.values()) {
            builder.put((Object)event.toString(), (Object)MapBuilder.of((Object)"registrationName", (Object)event.toString()));
        }
        return builder.build();
    }

    @ReactProp(name="type")
    public void setType(RNCameraView view, int type) {
        view.setFacing(type);
    }

    @ReactProp(name="ratio")
    public void setRatio(RNCameraView view, String ratio) {
        view.setAspectRatio(AspectRatio.parse(ratio));
    }

    @ReactProp(name="flashMode")
    public void setFlashMode(RNCameraView view, int torchMode) {
        view.setFlash(torchMode);
    }

    @ReactProp(name="autoFocus")
    public void setAutoFocus(RNCameraView view, boolean autoFocus) {
        view.setAutoFocus(autoFocus);
    }

    @ReactProp(name="focusDepth")
    public void setFocusDepth(RNCameraView view, float depth) {
        view.setFocusDepth(depth);
    }

    @ReactProp(name="zoom")
    public void setZoom(RNCameraView view, float zoom) {
        view.setZoom(zoom);
    }

    @ReactProp(name="whiteBalance")
    public void setWhiteBalance(RNCameraView view, int whiteBalance) {
        view.setWhiteBalance(whiteBalance);
    }

    @ReactProp(name="useCamera2Api")
    public void setUseCamera2Api(RNCameraView view, boolean useCamera2Api) {
        view.setUsingCamera2Api(useCamera2Api);
    }

    @ReactProp(name="playSoundOnCapture")
    public void setPlaySoundOnCapture(RNCameraView view, boolean playSoundOnCapture) {
        view.setPlaySoundOnCapture(playSoundOnCapture);
    }

    public static enum Events {
        EVENT_CAMERA_READY("onCameraReady"),
        EVENT_ON_MOUNT_ERROR("onMountError");

        private final String mName;

        private Events(String name) {
            this.mName = name;
        }

        public String toString() {
            return this.mName;
        }
    }
}

