/*
 * Decompiled with CFR 0.152.
 */
package org.reactnative.camera;

import android.annotation.SuppressLint;
import android.content.Context;
import android.media.CamcorderProfile;
import android.media.MediaActionSound;
import android.os.Build;
import android.support.v4.content.ContextCompat;
import android.view.View;
import android.view.ViewGroup;
import com.facebook.react.bridge.Arguments;
import com.facebook.react.bridge.LifecycleEventListener;
import com.facebook.react.bridge.Promise;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.bridge.WritableMap;
import com.facebook.react.uimanager.ThemedReactContext;
import com.google.android.cameraview.CameraView;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.reactnative.camera.RNCameraViewHelper;
import org.reactnative.camera.tasks.ResolveTakenPictureAsyncTask;
import org.reactnative.camera.utils.RNFileUtils;

public class RNCameraView
extends CameraView
implements LifecycleEventListener {
    private ThemedReactContext mThemedReactContext;
    private Queue<Promise> mPictureTakenPromises = new ConcurrentLinkedQueue<Promise>();
    private Map<Promise, ReadableMap> mPictureTakenOptions = new ConcurrentHashMap<Promise, ReadableMap>();
    private Map<Promise, File> mPictureTakenDirectories = new ConcurrentHashMap<Promise, File>();
    private Promise mVideoRecordedPromise;
    private List<String> mBarCodeTypes = null;
    private Boolean mPlaySoundOnCapture = false;
    private boolean mIsPaused = false;
    private boolean mIsNew = true;
    public volatile boolean barCodeScannerTaskLock = false;
    public volatile boolean faceDetectorTaskLock = false;
    public volatile boolean googleBarcodeDetectorTaskLock = false;
    public volatile boolean textRecognizerTaskLock = false;

    public RNCameraView(ThemedReactContext themedReactContext) {
        super((Context)themedReactContext, true);
        this.mThemedReactContext = themedReactContext;
        themedReactContext.addLifecycleEventListener((LifecycleEventListener)this);
        this.addCallback(new CameraView.Callback(){

            @Override
            public void onCameraOpened(CameraView cameraView) {
                RNCameraViewHelper.emitCameraReadyEvent((ViewGroup)cameraView);
            }

            @Override
            public void onMountError(CameraView cameraView) {
                RNCameraViewHelper.emitMountErrorEvent((ViewGroup)cameraView, "Camera view threw an error - component could not be rendered.");
            }

            @Override
            public void onPictureTaken(CameraView cameraView, byte[] data) {
                Promise promise = (Promise)RNCameraView.this.mPictureTakenPromises.poll();
                ReadableMap options = (ReadableMap)RNCameraView.this.mPictureTakenOptions.remove(promise);
                File cacheDirectory = (File)RNCameraView.this.mPictureTakenDirectories.remove(promise);
                new ResolveTakenPictureAsyncTask(data, promise, options, cacheDirectory).execute(new Void[0]);
            }

            @Override
            public void onVideoRecorded(CameraView cameraView, String path) {
                if (RNCameraView.this.mVideoRecordedPromise != null) {
                    if (path != null) {
                        WritableMap result = Arguments.createMap();
                        result.putString("uri", RNFileUtils.uriFromFile(new File(path)).toString());
                        RNCameraView.this.mVideoRecordedPromise.resolve((Object)result);
                    } else {
                        RNCameraView.this.mVideoRecordedPromise.reject("E_RECORDING", "Couldn't stop recording - there is none in progress");
                    }
                    RNCameraView.this.mVideoRecordedPromise = null;
                }
            }

            private byte[] rotateImage(byte[] imageData, int height, int width) {
                byte[] rotated = new byte[imageData.length];
                for (int y = 0; y < width; ++y) {
                    for (int x = 0; x < height; ++x) {
                        rotated[x * width + width - y - 1] = imageData[x + y * height];
                    }
                }
                return rotated;
            }

            @Override
            public void onFramePreview(CameraView cameraView, byte[] data, int width, int height, int rotation) {
                int correctRotation = RNCameraViewHelper.getCorrectCameraRotation(rotation, RNCameraView.this.getFacing());
                int correctWidth = width;
                int correctHeight = height;
                byte[] correctData = data;
                if (correctRotation == 90) {
                    correctWidth = height;
                    correctHeight = width;
                    correctData = this.rotateImage(data, correctHeight, correctWidth);
                }
            }
        });
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        int correctWidth;
        int correctHeight;
        View preview = this.getView();
        if (null == preview) {
            return;
        }
        float width = right - left;
        float height = bottom - top;
        float ratio = this.getAspectRatio().toFloat();
        int orientation = this.getResources().getConfiguration().orientation;
        this.setBackgroundColor(-16777216);
        if (orientation == 2) {
            if (ratio * height < width) {
                correctHeight = (int)(width / ratio);
                correctWidth = (int)width;
            } else {
                correctWidth = (int)(height * ratio);
                correctHeight = (int)height;
            }
        } else if (ratio * width > height) {
            correctHeight = (int)(width * ratio);
            correctWidth = (int)width;
        } else {
            correctWidth = (int)(height / ratio);
            correctHeight = (int)height;
        }
        int paddingX = (int)((width - (float)correctWidth) / 2.0f);
        int paddingY = (int)((height - (float)correctHeight) / 2.0f);
        preview.layout(paddingX, paddingY, correctWidth + paddingX, correctHeight + paddingY);
    }

    @SuppressLint(value={"all"})
    public void requestLayout() {
    }

    public void onViewAdded(View child) {
        if (this.getView() == child || this.getView() == null) {
            return;
        }
        this.removeView(this.getView());
        this.addView(this.getView(), 0);
    }

    public void setPlaySoundOnCapture(Boolean playSoundOnCapture) {
        this.mPlaySoundOnCapture = playSoundOnCapture;
    }

    public void takePicture(ReadableMap options, Promise promise, File cacheDirectory) {
        this.mPictureTakenPromises.add(promise);
        this.mPictureTakenOptions.put(promise, options);
        this.mPictureTakenDirectories.put(promise, cacheDirectory);
        if (this.mPlaySoundOnCapture.booleanValue()) {
            MediaActionSound sound = new MediaActionSound();
            sound.play(0);
        }
        super.takePicture();
    }

    public void record(ReadableMap options, Promise promise, File cacheDirectory) {
        try {
            boolean recordAudio;
            String path = RNFileUtils.getOutputFilePath(cacheDirectory, ".mp4");
            int maxDuration = options.hasKey("maxDuration") ? options.getInt("maxDuration") : -1;
            int maxFileSize = options.hasKey("maxFileSize") ? options.getInt("maxFileSize") : -1;
            CamcorderProfile profile = CamcorderProfile.get((int)1);
            if (options.hasKey("quality")) {
                profile = RNCameraViewHelper.getCamcorderProfile(options.getInt("quality"));
            }
            boolean bl = recordAudio = !options.hasKey("mute");
            if (super.record(path, maxDuration * 1000, maxFileSize, recordAudio, profile)) {
                this.mVideoRecordedPromise = promise;
            } else {
                promise.reject("E_RECORDING_FAILED", "Starting video recording failed. Another recording might be in progress.");
            }
        }
        catch (IOException e) {
            promise.reject("E_RECORDING_FAILED", "Starting video recording failed - could not create video file.");
        }
    }

    public void onHostResume() {
        if (this.hasCameraPermissions()) {
            if (this.mIsPaused && !this.isCameraOpened() || this.mIsNew) {
                this.mIsPaused = false;
                this.mIsNew = false;
                if (!Build.FINGERPRINT.contains("generic")) {
                    this.start();
                }
            }
        } else {
            RNCameraViewHelper.emitMountErrorEvent((ViewGroup)this, "Camera permissions not granted - component could not be rendered.");
        }
    }

    public void onHostPause() {
        if (!this.mIsPaused && this.isCameraOpened()) {
            this.mIsPaused = true;
            this.stop();
        }
    }

    public void onHostDestroy() {
        this.stop();
        this.mThemedReactContext.removeLifecycleEventListener((LifecycleEventListener)this);
    }

    private boolean hasCameraPermissions() {
        if (Build.VERSION.SDK_INT >= 23) {
            int result = ContextCompat.checkSelfPermission((Context)this.getContext(), (String)"android.permission.CAMERA");
            return result == 0;
        }
        return true;
    }
}

