/*
 * Decompiled with CFR 0.152.
 */
package org.reactnative.camera;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.media.CamcorderProfile;
import android.os.Build;
import android.support.media.ExifInterface;
import android.view.ViewGroup;
import com.facebook.react.bridge.Arguments;
import com.facebook.react.bridge.ReactContext;
import com.facebook.react.bridge.WritableMap;
import com.facebook.react.uimanager.UIManagerModule;
import com.facebook.react.uimanager.events.Event;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import org.reactnative.camera.events.CameraMountErrorEvent;
import org.reactnative.camera.events.CameraReadyEvent;

public class RNCameraViewHelper {
    public static final String[][] exifTags = new String[][]{{"string", "Artist"}, {"int", "BitsPerSample"}, {"int", "Compression"}, {"string", "Copyright"}, {"string", "DateTime"}, {"string", "ImageDescription"}, {"int", "ImageLength"}, {"int", "ImageWidth"}, {"int", "JPEGInterchangeFormat"}, {"int", "JPEGInterchangeFormatLength"}, {"string", "Make"}, {"string", "Model"}, {"int", "Orientation"}, {"int", "PhotometricInterpretation"}, {"int", "PlanarConfiguration"}, {"double", "PrimaryChromaticities"}, {"double", "ReferenceBlackWhite"}, {"int", "ResolutionUnit"}, {"int", "RowsPerStrip"}, {"int", "SamplesPerPixel"}, {"string", "Software"}, {"int", "StripByteCounts"}, {"int", "StripOffsets"}, {"int", "TransferFunction"}, {"double", "WhitePoint"}, {"double", "XResolution"}, {"double", "YCbCrCoefficients"}, {"int", "YCbCrPositioning"}, {"int", "YCbCrSubSampling"}, {"double", "YResolution"}, {"double", "ApertureValue"}, {"double", "BrightnessValue"}, {"string", "CFAPattern"}, {"int", "ColorSpace"}, {"string", "ComponentsConfiguration"}, {"double", "CompressedBitsPerPixel"}, {"int", "Contrast"}, {"int", "CustomRendered"}, {"string", "DateTimeDigitized"}, {"string", "DateTimeOriginal"}, {"string", "DeviceSettingDescription"}, {"double", "DigitalZoomRatio"}, {"string", "ExifVersion"}, {"double", "ExposureBiasValue"}, {"double", "ExposureIndex"}, {"int", "ExposureMode"}, {"int", "ExposureProgram"}, {"double", "ExposureTime"}, {"double", "FNumber"}, {"string", "FileSource"}, {"int", "Flash"}, {"double", "FlashEnergy"}, {"string", "FlashpixVersion"}, {"double", "FocalLength"}, {"int", "FocalLengthIn35mmFilm"}, {"int", "FocalPlaneResolutionUnit"}, {"double", "FocalPlaneXResolution"}, {"double", "FocalPlaneYResolution"}, {"int", "GainControl"}, {"int", "ISOSpeedRatings"}, {"string", "ImageUniqueID"}, {"int", "LightSource"}, {"string", "MakerNote"}, {"double", "MaxApertureValue"}, {"int", "MeteringMode"}, {"int", "NewSubfileType"}, {"string", "OECF"}, {"int", "PixelXDimension"}, {"int", "PixelYDimension"}, {"string", "RelatedSoundFile"}, {"int", "Saturation"}, {"int", "SceneCaptureType"}, {"string", "SceneType"}, {"int", "SensingMethod"}, {"int", "Sharpness"}, {"double", "ShutterSpeedValue"}, {"string", "SpatialFrequencyResponse"}, {"string", "SpectralSensitivity"}, {"int", "SubfileType"}, {"string", "SubSecTime"}, {"string", "SubSecTimeDigitized"}, {"string", "SubSecTimeOriginal"}, {"int", "SubjectArea"}, {"double", "SubjectDistance"}, {"int", "SubjectDistanceRange"}, {"int", "SubjectLocation"}, {"string", "UserComment"}, {"int", "WhiteBalance"}, {"int", "GPSAltitudeRef"}, {"string", "GPSAreaInformation"}, {"double", "GPSDOP"}, {"string", "GPSDateStamp"}, {"double", "GPSDestBearing"}, {"string", "GPSDestBearingRef"}, {"double", "GPSDestDistance"}, {"string", "GPSDestDistanceRef"}, {"double", "GPSDestLatitude"}, {"string", "GPSDestLatitudeRef"}, {"double", "GPSDestLongitude"}, {"string", "GPSDestLongitudeRef"}, {"int", "GPSDifferential"}, {"double", "GPSImgDirection"}, {"string", "GPSImgDirectionRef"}, {"string", "GPSLatitudeRef"}, {"string", "GPSLongitudeRef"}, {"string", "GPSMapDatum"}, {"string", "GPSMeasureMode"}, {"string", "GPSProcessingMethod"}, {"string", "GPSSatellites"}, {"double", "GPSSpeed"}, {"string", "GPSSpeedRef"}, {"string", "GPSStatus"}, {"string", "GPSTimeStamp"}, {"double", "GPSTrack"}, {"string", "GPSTrackRef"}, {"string", "GPSVersionID"}, {"string", "InteroperabilityIndex"}, {"int", "ThumbnailImageLength"}, {"int", "ThumbnailImageWidth"}, {"int", "DNGVersion"}, {"int", "DefaultCropSize"}, {"int", "PreviewImageStart"}, {"int", "PreviewImageLength"}, {"int", "AspectFrame"}, {"int", "SensorBottomBorder"}, {"int", "SensorLeftBorder"}, {"int", "SensorRightBorder"}, {"int", "SensorTopBorder"}, {"int", "ISO"}};

    public static void emitMountErrorEvent(ViewGroup view, String error) {
        CameraMountErrorEvent event = CameraMountErrorEvent.obtain(view.getId(), error);
        ReactContext reactContext = (ReactContext)view.getContext();
        ((UIManagerModule)reactContext.getNativeModule(UIManagerModule.class)).getEventDispatcher().dispatchEvent((Event)event);
    }

    public static void emitCameraReadyEvent(ViewGroup view) {
        CameraReadyEvent event = CameraReadyEvent.obtain(view.getId());
        ReactContext reactContext = (ReactContext)view.getContext();
        ((UIManagerModule)reactContext.getNativeModule(UIManagerModule.class)).getEventDispatcher().dispatchEvent((Event)event);
    }

    public static int getCorrectCameraRotation(int rotation, int facing) {
        if (facing == 1) {
            return (rotation - 90 + 360) % 360;
        }
        return (-rotation + 90 + 360) % 360;
    }

    public static CamcorderProfile getCamcorderProfile(int quality) {
        CamcorderProfile profile = CamcorderProfile.get((int)1);
        switch (quality) {
            case 0: {
                if (Build.VERSION.SDK_INT < 21) break;
                profile = CamcorderProfile.get((int)8);
                break;
            }
            case 1: {
                profile = CamcorderProfile.get((int)6);
                break;
            }
            case 2: {
                profile = CamcorderProfile.get((int)5);
                break;
            }
            case 3: {
                profile = CamcorderProfile.get((int)4);
                break;
            }
            case 4: {
                profile = CamcorderProfile.get((int)4);
                profile.videoFrameWidth = 640;
            }
        }
        return profile;
    }

    public static WritableMap getExifData(ExifInterface exifInterface) {
        WritableMap exifMap = Arguments.createMap();
        block10: for (String[] tagInfo : exifTags) {
            String type;
            String name = tagInfo[1];
            if (exifInterface.getAttribute(name) == null) continue;
            switch (type = tagInfo[0]) {
                case "string": {
                    exifMap.putString(name, exifInterface.getAttribute(name));
                    continue block10;
                }
                case "int": {
                    exifMap.putInt(name, exifInterface.getAttributeInt(name, 0));
                    continue block10;
                }
                case "double": {
                    exifMap.putDouble(name, exifInterface.getAttributeDouble(name, 0.0));
                }
            }
        }
        float[] latLong = new float[2];
        boolean ok = exifInterface.getLatLong(latLong);
        if (ok) {
            exifMap.putDouble("GPSLatitude", (double)latLong[0]);
            exifMap.putDouble("GPSLongitude", (double)latLong[1]);
            exifMap.putDouble("GPSAltitude", exifInterface.getAltitude(0.0));
        }
        return exifMap;
    }

    public static Bitmap generateSimulatorPhoto(int width, int height) {
        Bitmap fakePhoto = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(fakePhoto);
        Paint background = new Paint();
        background.setColor(-16777216);
        canvas.drawRect(0.0f, 0.0f, (float)width, (float)height, background);
        Paint textPaint = new Paint();
        textPaint.setColor(-256);
        textPaint.setTextSize(35.0f);
        Calendar calendar = Calendar.getInstance();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy.MM.dd G '->' HH:mm:ss z");
        canvas.drawText(simpleDateFormat.format(calendar.getTime()), (float)width * 0.1f, (float)height * 0.2f, textPaint);
        canvas.drawText(simpleDateFormat.format(calendar.getTime()), (float)width * 0.2f, (float)height * 0.4f, textPaint);
        canvas.drawText(simpleDateFormat.format(calendar.getTime()), (float)width * 0.3f, (float)height * 0.6f, textPaint);
        canvas.drawText(simpleDateFormat.format(calendar.getTime()), (float)width * 0.4f, (float)height * 0.8f, textPaint);
        return fakePhoto;
    }
}

