/*
 * Decompiled with CFR 0.152.
 */
package org.reactnative.camera.events;

import android.support.v4.util.Pools;
import com.facebook.react.bridge.Arguments;
import com.facebook.react.bridge.WritableMap;
import com.facebook.react.uimanager.events.Event;
import com.facebook.react.uimanager.events.RCTEventEmitter;
import org.reactnative.camera.CameraViewManager;

public class CameraReadyEvent
extends Event<CameraReadyEvent> {
    private static final Pools.SynchronizedPool<CameraReadyEvent> EVENTS_POOL = new Pools.SynchronizedPool(3);

    private CameraReadyEvent() {
    }

    public static CameraReadyEvent obtain(int viewTag) {
        CameraReadyEvent event = (CameraReadyEvent)((Object)EVENTS_POOL.acquire());
        if (event == null) {
            event = new CameraReadyEvent();
        }
        event.init(viewTag);
        return event;
    }

    public short getCoalescingKey() {
        return 0;
    }

    public String getEventName() {
        return CameraViewManager.Events.EVENT_CAMERA_READY.toString();
    }

    public void dispatch(RCTEventEmitter rctEventEmitter) {
        rctEventEmitter.receiveEvent(this.getViewTag(), this.getEventName(), this.serializeEventData());
    }

    private WritableMap serializeEventData() {
        return Arguments.createMap();
    }
}

