/*
 * Decompiled with CFR 0.152.
 */
package org.reactnative.camera.tasks;

import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.net.Uri;
import android.os.AsyncTask;
import android.support.media.ExifInterface;
import android.util.Base64;
import com.facebook.react.bridge.Arguments;
import com.facebook.react.bridge.Promise;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.bridge.WritableMap;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.reactnative.camera.RNCameraViewHelper;
import org.reactnative.camera.utils.RNFileUtils;

public class ResolveTakenPictureAsyncTask
extends AsyncTask<Void, Void, WritableMap> {
    private static final String ERROR_TAG = "E_TAKING_PICTURE_FAILED";
    private Promise mPromise;
    private byte[] mImageData;
    private ReadableMap mOptions;
    private File mCacheDirectory;
    private Bitmap mBitmap;

    public ResolveTakenPictureAsyncTask(byte[] imageData, Promise promise, ReadableMap options) {
        this.mPromise = promise;
        this.mOptions = options;
        this.mImageData = imageData;
    }

    public ResolveTakenPictureAsyncTask(byte[] imageData, Promise promise, ReadableMap options, File cacheDirectory) {
        this.mPromise = promise;
        this.mOptions = options;
        this.mImageData = imageData;
        this.mCacheDirectory = cacheDirectory;
    }

    private int getQuality() {
        return (int)(this.mOptions.getDouble("quality") * 100.0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected WritableMap doInBackground(Void ... voids) {
        WritableMap response = Arguments.createMap();
        ByteArrayInputStream inputStream = null;
        if (this.mOptions.hasKey("skipProcessing")) {
            try {
                File imageFile = new File(RNFileUtils.getOutputFilePath(this.mCacheDirectory, ".jpg"));
                imageFile.createNewFile();
                FileOutputStream fOut = new FileOutputStream(imageFile);
                fOut.write(this.mImageData);
                String fileUri = Uri.fromFile((File)imageFile).toString();
                response.putString("uri", fileUri);
            }
            catch (Resources.NotFoundException e) {
                this.mPromise.reject(ERROR_TAG, "Documents directory of the app could not be found.", (Throwable)e);
                e.printStackTrace();
            }
            catch (IOException e) {
                this.mPromise.reject(ERROR_TAG, "An unknown I/O exception has occurred.", (Throwable)e);
                e.printStackTrace();
            }
            return response;
        }
        if (this.mBitmap == null) {
            this.mBitmap = BitmapFactory.decodeByteArray((byte[])this.mImageData, (int)0, (int)this.mImageData.length);
            inputStream = new ByteArrayInputStream(this.mImageData);
        }
        try {
            if (inputStream != null) {
                ExifInterface exifInterface = new ExifInterface(inputStream);
                int orientation = exifInterface.getAttributeInt("Orientation", 0);
                if (this.mOptions.hasKey("width")) {
                    this.mBitmap = this.resizeBitmap(this.mBitmap, this.mOptions.getInt("width"));
                }
                if (this.mOptions.hasKey("fixOrientation") && this.mOptions.getBoolean("fixOrientation") && orientation != 0) {
                    this.mBitmap = this.rotateBitmap(this.mBitmap, this.getImageRotation(orientation));
                }
                if (this.mOptions.hasKey("mirrorImage") && this.mOptions.getBoolean("mirrorImage")) {
                    this.mBitmap = this.flipHorizontally(this.mBitmap);
                }
                if (this.mOptions.hasKey("exif") && this.mOptions.getBoolean("exif")) {
                    WritableMap exifData = RNCameraViewHelper.getExifData(exifInterface);
                    response.putMap("exif", exifData);
                }
            }
            response.putInt("width", this.mBitmap.getWidth());
            response.putInt("height", this.mBitmap.getHeight());
            ByteArrayOutputStream imageStream = new ByteArrayOutputStream();
            this.mBitmap.compress(Bitmap.CompressFormat.JPEG, this.getQuality(), (OutputStream)imageStream);
            String filePath = this.writeStreamToFile(imageStream);
            File imageFile = new File(filePath);
            String fileUri = Uri.fromFile((File)imageFile).toString();
            response.putString("uri", fileUri);
            if (this.mOptions.hasKey("base64") && this.mOptions.getBoolean("base64")) {
                response.putString("base64", Base64.encodeToString((byte[])imageStream.toByteArray(), (int)0));
            }
            imageStream.close();
            if (inputStream != null) {
                inputStream.close();
                inputStream = null;
            }
            WritableMap writableMap = response;
            return writableMap;
        }
        catch (Resources.NotFoundException e) {
            this.mPromise.reject(ERROR_TAG, "Documents directory of the app could not be found.", (Throwable)e);
            e.printStackTrace();
        }
        catch (IOException e) {
            this.mPromise.reject(ERROR_TAG, "An unknown I/O exception has occurred.", (Throwable)e);
            e.printStackTrace();
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    private Bitmap rotateBitmap(Bitmap source, int angle) {
        Matrix matrix = new Matrix();
        matrix.postRotate((float)angle);
        return Bitmap.createBitmap((Bitmap)source, (int)0, (int)0, (int)source.getWidth(), (int)source.getHeight(), (Matrix)matrix, (boolean)true);
    }

    private Bitmap resizeBitmap(Bitmap bm, int newWidth) {
        int width = bm.getWidth();
        int height = bm.getHeight();
        float scaleRatio = (float)newWidth / (float)width;
        return Bitmap.createScaledBitmap((Bitmap)bm, (int)newWidth, (int)((int)((float)height * scaleRatio)), (boolean)true);
    }

    private Bitmap flipHorizontally(Bitmap source) {
        Matrix matrix = new Matrix();
        matrix.preScale(-1.0f, 1.0f);
        return Bitmap.createBitmap((Bitmap)source, (int)0, (int)0, (int)source.getWidth(), (int)source.getHeight(), (Matrix)matrix, (boolean)true);
    }

    private int getImageRotation(int orientation) {
        int rotationDegrees = 0;
        switch (orientation) {
            case 6: {
                rotationDegrees = 90;
                break;
            }
            case 3: {
                rotationDegrees = 180;
                break;
            }
            case 8: {
                rotationDegrees = 270;
            }
        }
        return rotationDegrees;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String writeStreamToFile(ByteArrayOutputStream inputStream) throws IOException {
        String outputPath = null;
        IOException exception = null;
        FileOutputStream outputStream = null;
        try {
            outputPath = RNFileUtils.getOutputFilePath(this.mCacheDirectory, ".jpg");
            outputStream = new FileOutputStream(outputPath);
            inputStream.writeTo(outputStream);
        }
        catch (IOException e) {
            e.printStackTrace();
            exception = e;
        }
        finally {
            try {
                if (outputStream != null) {
                    outputStream.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (exception != null) {
            throw exception;
        }
        return outputPath;
    }

    protected void onPostExecute(WritableMap response) {
        super.onPostExecute((Object)response);
        if (response != null) {
            this.mPromise.resolve((Object)response);
        }
    }
}

