/*
 * Decompiled with CFR 0.152.
 */
package org.reactnative.camera.utils;

public class ImageDimensions {
    private int mWidth;
    private int mHeight;
    private int mFacing;
    private int mRotation;

    public ImageDimensions(int width, int height) {
        this(width, height, 0);
    }

    public ImageDimensions(int width, int height, int rotation) {
        this(width, height, rotation, -1);
    }

    public ImageDimensions(int width, int height, int rotation, int facing) {
        this.mWidth = width;
        this.mHeight = height;
        this.mFacing = facing;
        this.mRotation = rotation;
    }

    public boolean isLandscape() {
        return this.mRotation % 180 == 90;
    }

    public int getWidth() {
        if (this.isLandscape()) {
            return this.mHeight;
        }
        return this.mWidth;
    }

    public int getHeight() {
        if (this.isLandscape()) {
            return this.mWidth;
        }
        return this.mHeight;
    }

    public int getRotation() {
        return this.mRotation;
    }

    public int getFacing() {
        return this.mFacing;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ImageDimensions) {
            ImageDimensions otherDimensions = (ImageDimensions)obj;
            return otherDimensions.getWidth() == this.getWidth() && otherDimensions.getHeight() == this.getHeight() && otherDimensions.getFacing() == this.getFacing() && otherDimensions.getRotation() == this.getRotation();
        }
        return super.equals(obj);
    }
}

