/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.text;

import android.os.Build;
import android.text.BoringLayout;
import android.text.Layout;
import android.text.Spannable;
import android.text.Spanned;
import android.text.StaticLayout;
import android.text.TextPaint;
import com.facebook.infer.annotation.Assertions;
import com.facebook.react.uimanager.LayoutShadowNode;
import com.facebook.react.uimanager.UIViewOperationQueue;
import com.facebook.react.views.text.ReactBaseTextShadowNode;
import com.facebook.react.views.text.ReactTextUpdate;
import com.facebook.yoga.YogaConstants;
import com.facebook.yoga.YogaDirection;
import com.facebook.yoga.YogaMeasureFunction;
import com.facebook.yoga.YogaMeasureMode;
import com.facebook.yoga.YogaMeasureOutput;
import com.facebook.yoga.YogaNode;
import javax.annotation.Nullable;

public class ReactTextShadowNode
extends ReactBaseTextShadowNode {
    private static final TextPaint sTextPaintInstance = new TextPaint(1);
    @Nullable
    private Spannable mPreparedSpannableText;
    private final YogaMeasureFunction mTextMeasureFunction = new YogaMeasureFunction(){

        @Override
        public long measure(YogaNode node, float width, YogaMeasureMode widthMode, float height, YogaMeasureMode heightMode) {
            Object layout2;
            boolean unconstrainedWidth;
            TextPaint textPaint = sTextPaintInstance;
            Spanned text = (Spanned)Assertions.assertNotNull((Object)ReactTextShadowNode.this.mPreparedSpannableText, (String)"Spannable element has not been prepared in onBeforeLayout");
            BoringLayout.Metrics boring = BoringLayout.isBoring((CharSequence)text, (TextPaint)textPaint);
            float desiredWidth = boring == null ? Layout.getDesiredWidth((CharSequence)text, (TextPaint)textPaint) : Float.NaN;
            boolean bl = unconstrainedWidth = widthMode == YogaMeasureMode.UNDEFINED || width < 0.0f;
            if (boring == null && (unconstrainedWidth || !YogaConstants.isUndefined(desiredWidth) && desiredWidth <= width)) {
                int hintWidth = (int)Math.ceil(desiredWidth);
                layout2 = Build.VERSION.SDK_INT < 23 ? new StaticLayout((CharSequence)text, textPaint, hintWidth, Layout.Alignment.ALIGN_NORMAL, 1.0f, 0.0f, ReactTextShadowNode.this.mIncludeFontPadding) : StaticLayout.Builder.obtain((CharSequence)text, (int)0, (int)text.length(), (TextPaint)textPaint, (int)hintWidth).setAlignment(Layout.Alignment.ALIGN_NORMAL).setLineSpacing(0.0f, 1.0f).setIncludePad(ReactTextShadowNode.this.mIncludeFontPadding).setBreakStrategy(ReactTextShadowNode.this.mTextBreakStrategy).setHyphenationFrequency(1).build();
            } else {
                layout2 = boring != null && (unconstrainedWidth || (float)boring.width <= width) ? BoringLayout.make((CharSequence)text, (TextPaint)textPaint, (int)boring.width, (Layout.Alignment)Layout.Alignment.ALIGN_NORMAL, (float)1.0f, (float)0.0f, (BoringLayout.Metrics)boring, (boolean)ReactTextShadowNode.this.mIncludeFontPadding) : (Build.VERSION.SDK_INT < 23 ? new StaticLayout((CharSequence)text, textPaint, (int)width, Layout.Alignment.ALIGN_NORMAL, 1.0f, 0.0f, ReactTextShadowNode.this.mIncludeFontPadding) : StaticLayout.Builder.obtain((CharSequence)text, (int)0, (int)text.length(), (TextPaint)textPaint, (int)((int)width)).setAlignment(Layout.Alignment.ALIGN_NORMAL).setLineSpacing(0.0f, 1.0f).setIncludePad(ReactTextShadowNode.this.mIncludeFontPadding).setBreakStrategy(ReactTextShadowNode.this.mTextBreakStrategy).setHyphenationFrequency(1).build());
            }
            if (ReactTextShadowNode.this.mNumberOfLines != -1 && ReactTextShadowNode.this.mNumberOfLines < layout2.getLineCount()) {
                return YogaMeasureOutput.make(layout2.getWidth(), layout2.getLineBottom(ReactTextShadowNode.this.mNumberOfLines - 1));
            }
            return YogaMeasureOutput.make(layout2.getWidth(), layout2.getHeight());
        }
    };

    public ReactTextShadowNode() {
        this.initMeasureFunction();
    }

    private ReactTextShadowNode(ReactTextShadowNode node) {
        super(node);
        this.mPreparedSpannableText = node.mPreparedSpannableText;
        this.initMeasureFunction();
    }

    private void initMeasureFunction() {
        if (!this.isVirtual()) {
            this.setMeasureFunction(this.mTextMeasureFunction);
        }
    }

    @Override
    public LayoutShadowNode mutableCopy() {
        return new ReactTextShadowNode(this);
    }

    private int getTextAlign() {
        int textAlign = this.mTextAlign;
        if (this.getLayoutDirection() == YogaDirection.RTL) {
            if (textAlign == 5) {
                textAlign = 3;
            } else if (textAlign == 3) {
                textAlign = 5;
            }
        }
        return textAlign;
    }

    @Override
    public void onBeforeLayout() {
        this.mPreparedSpannableText = ReactTextShadowNode.spannedFromShadowNode(this, null);
        this.markUpdated();
    }

    @Override
    public boolean isVirtualAnchor() {
        return true;
    }

    @Override
    public void markUpdated() {
        super.markUpdated();
        super.dirty();
    }

    @Override
    public void onCollectExtraUpdates(UIViewOperationQueue uiViewOperationQueue) {
        super.onCollectExtraUpdates(uiViewOperationQueue);
        if (this.mPreparedSpannableText != null) {
            ReactTextUpdate reactTextUpdate = new ReactTextUpdate(this.mPreparedSpannableText, -1, this.mContainsImages, this.getPadding(4), this.getPadding(1), this.getPadding(5), this.getPadding(3), this.getTextAlign(), this.mTextBreakStrategy);
            uiViewOperationQueue.enqueueUpdateExtraData(this.getReactTag(), reactTextUpdate);
        }
    }
}

