/*
 * Decompiled with CFR 0.152.
 */
package cn.mandata.react_native_mpchart;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.drawable.Drawable;
import android.text.TextPaint;
import android.util.AttributeSet;
import android.view.View;
import cn.mandata.react_native_mpchart.R;

public class ChartView
extends View {
    private String mExampleString;
    private int mExampleColor = -65536;
    private float mExampleDimension = 0.0f;
    private Drawable mExampleDrawable;
    private TextPaint mTextPaint;
    private float mTextWidth;
    private float mTextHeight;

    public ChartView(Context context) {
        super(context);
        this.init(null, 0);
    }

    public ChartView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(attrs, 0);
    }

    public ChartView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init(attrs, defStyle);
    }

    private void init(AttributeSet attrs, int defStyle) {
        TypedArray a = this.getContext().obtainStyledAttributes(attrs, R.styleable.ChartView, defStyle, 0);
        this.mExampleString = a.getString(R.styleable.ChartView_exampleString);
        this.mExampleColor = a.getColor(R.styleable.ChartView_exampleColor, this.mExampleColor);
        this.mExampleDimension = a.getDimension(R.styleable.ChartView_exampleDimension, this.mExampleDimension);
        if (a.hasValue(R.styleable.ChartView_exampleDrawable)) {
            this.mExampleDrawable = a.getDrawable(R.styleable.ChartView_exampleDrawable);
            this.mExampleDrawable.setCallback((Drawable.Callback)this);
        }
        a.recycle();
        this.mTextPaint = new TextPaint();
        this.mTextPaint.setFlags(1);
        this.mTextPaint.setTextAlign(Paint.Align.LEFT);
        this.invalidateTextPaintAndMeasurements();
    }

    private void invalidateTextPaintAndMeasurements() {
        this.mTextPaint.setTextSize(this.mExampleDimension);
        this.mTextPaint.setColor(this.mExampleColor);
        if (this.mExampleString == null) {
            this.mExampleString = "";
        }
        this.mTextWidth = this.mTextPaint.measureText(this.mExampleString);
        Paint.FontMetrics fontMetrics = this.mTextPaint.getFontMetrics();
        this.mTextHeight = fontMetrics.bottom;
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        int paddingLeft = this.getPaddingLeft();
        int paddingTop = this.getPaddingTop();
        int paddingRight = this.getPaddingRight();
        int paddingBottom = this.getPaddingBottom();
        int contentWidth = this.getWidth() - paddingLeft - paddingRight;
        int contentHeight = this.getHeight() - paddingTop - paddingBottom;
        canvas.drawText(this.mExampleString, (float)paddingLeft + ((float)contentWidth - this.mTextWidth) / 2.0f, (float)paddingTop + ((float)contentHeight + this.mTextHeight) / 2.0f, (Paint)this.mTextPaint);
        if (this.mExampleDrawable != null) {
            this.mExampleDrawable.setBounds(paddingLeft, paddingTop, paddingLeft + contentWidth, paddingTop + contentHeight);
            this.mExampleDrawable.draw(canvas);
        }
    }

    public void setData(String data) {
        this.setExampleString(data);
    }

    public String getExampleString() {
        return this.mExampleString;
    }

    public void setExampleString(String exampleString) {
        this.mExampleString = exampleString;
        this.invalidateTextPaintAndMeasurements();
    }

    public int getExampleColor() {
        return this.mExampleColor;
    }

    public void setExampleColor(int exampleColor) {
        this.mExampleColor = exampleColor;
        this.invalidateTextPaintAndMeasurements();
    }

    public float getExampleDimension() {
        return this.mExampleDimension;
    }

    public void setExampleDimension(float exampleDimension) {
        this.mExampleDimension = exampleDimension;
        this.invalidateTextPaintAndMeasurements();
    }

    public Drawable getExampleDrawable() {
        return this.mExampleDrawable;
    }

    public void setExampleDrawable(Drawable exampleDrawable) {
        this.mExampleDrawable = exampleDrawable;
    }
}

