/*
 * Decompiled with CFR 0.152.
 */
package cn.mandata.react_native_mpchart;

import android.content.Context;
import android.graphics.Color;
import android.graphics.Paint;
import cn.mandata.react_native_mpchart.MPBarLineChartManager;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.uimanager.ThemedReactContext;
import com.facebook.react.uimanager.annotations.ReactProp;
import com.github.mikephil.charting.charts.CandleStickChart;
import com.github.mikephil.charting.charts.LineChart;
import com.github.mikephil.charting.data.CandleData;
import com.github.mikephil.charting.data.CandleDataSet;
import com.github.mikephil.charting.data.CandleEntry;
import com.github.mikephil.charting.data.ChartData;
import com.github.mikephil.charting.data.LineData;
import com.github.mikephil.charting.data.LineDataSet;
import com.github.mikephil.charting.interfaces.datasets.IDataSet;
import java.util.ArrayList;
import java.util.Random;

public class MPCandleStickChartManager
extends MPBarLineChartManager {
    private String CLASS_NAME = "MPCandleStickChart";
    private Random random;
    private LineChart chart;
    private LineData data;
    private LineDataSet dataSet;

    @Override
    public String getName() {
        return this.CLASS_NAME;
    }

    protected CandleStickChart createViewInstance(ThemedReactContext reactContext) {
        CandleStickChart chart = new CandleStickChart((Context)reactContext);
        return chart;
    }

    @ReactProp(name="data")
    public void setData(CandleStickChart chart, ReadableMap rm) {
        String label = rm.getString("Label");
        ReadableArray xArray = rm.getArray("Data");
        ArrayList<String> xVals = new ArrayList<String>();
        for (int m = 0; m < xArray.size(); ++m) {
            xVals.add(xArray.getArray(m).getString(0));
        }
        CandleData chartData = new CandleData(xVals);
        ArrayList<CandleEntry> entries = new ArrayList<CandleEntry>();
        for (int i = 0; i < xArray.size(); ++i) {
            ReadableArray data = xArray.getArray(i);
            float open = (float)data.getDouble(1);
            float close = (float)data.getDouble(2);
            float high = (float)data.getDouble(3);
            float low = (float)data.getDouble(4);
            CandleEntry be = new CandleEntry(i, high, low, open, close);
            entries.add(be);
        }
        CandleDataSet dataSet = new CandleDataSet(entries, label);
        dataSet.setShadowColor(-12303292);
        dataSet.setShadowWidth(0.7f);
        dataSet.setDecreasingColor(Color.parseColor((String)"#006030"));
        dataSet.setDecreasingPaintStyle(Paint.Style.FILL);
        dataSet.setIncreasingColor(Color.parseColor((String)"#A50B31"));
        dataSet.setIncreasingPaintStyle(Paint.Style.FILL);
        chartData.addDataSet((IDataSet)dataSet);
        chart.setBackgroundColor(-1);
        chart.setMaxVisibleValueCount(50);
        chart.setData((ChartData)chartData);
        chart.invalidate();
    }
}

