/*
 * Decompiled with CFR 0.152.
 */
package cn.mandata.react_native_mpchart;

import android.content.Context;
import android.graphics.Color;
import cn.mandata.react_native_mpchart.MPBarLineChartManager;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.uimanager.ThemedReactContext;
import com.facebook.react.uimanager.annotations.ReactProp;
import com.github.mikephil.charting.charts.BarChart;
import com.github.mikephil.charting.data.BarData;
import com.github.mikephil.charting.data.BarDataSet;
import com.github.mikephil.charting.data.BarEntry;
import com.github.mikephil.charting.data.ChartData;
import com.github.mikephil.charting.interfaces.datasets.IDataSet;
import java.util.ArrayList;

public class MPBarChartManager
extends MPBarLineChartManager {
    private String CLASS_NAME = "MPBarChart";

    @Override
    public String getName() {
        return this.CLASS_NAME;
    }

    protected BarChart createViewInstance(ThemedReactContext reactContext) {
        BarChart chart = new BarChart((Context)reactContext);
        return chart;
    }

    @ReactProp(name="data")
    public void setData(BarChart chart, ReadableMap rm) {
        ReadableArray xArray = rm.getArray("xValues");
        ArrayList<String> xVals = new ArrayList<String>();
        for (int m = 0; m < xArray.size(); ++m) {
            xVals.add(xArray.getString(m));
        }
        ReadableArray ra = rm.getArray("yValues");
        BarData barData = new BarData(xVals);
        for (int i = 0; i < ra.size(); ++i) {
            ReadableMap map = ra.getMap(i);
            ReadableArray data = map.getArray("data");
            String label = map.getString("label");
            float[] vals = new float[data.size()];
            ArrayList<BarEntry> entries = new ArrayList<BarEntry>();
            for (int j = 0; j < data.size(); ++j) {
                vals[j] = (float)data.getDouble(j);
                BarEntry be = new BarEntry((float)data.getDouble(j), j);
                entries.add(be);
            }
            BarDataSet dataSet = new BarDataSet(entries, label);
            ReadableMap config = map.getMap("config");
            if (config.hasKey("colors")) {
                ReadableArray colorsArray = config.getArray("colors");
                ArrayList<Integer> colors = new ArrayList<Integer>();
                for (int c = 0; c < colorsArray.size(); ++c) {
                    colors.add(Color.parseColor((String)colorsArray.getString(c)));
                }
                dataSet.setColors(colors);
            } else if (config.hasKey("color")) {
                int[] colors = new int[]{Color.parseColor((String)config.getString("color"))};
                dataSet.setColors(colors);
            }
            barData.addDataSet((IDataSet)dataSet);
        }
        chart.setBackgroundColor(-1);
        chart.setData((ChartData)barData);
        chart.invalidate();
    }
}

