/*
 * Decompiled with CFR 0.152.
 */
package cn.mandata.react_native_mpchart;

import android.content.Context;
import android.graphics.Color;
import android.graphics.Paint;
import cn.mandata.react_native_mpchart.MPBarLineChartManager;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.uimanager.ThemedReactContext;
import com.facebook.react.uimanager.annotations.ReactProp;
import com.github.mikephil.charting.charts.CombinedChart;
import com.github.mikephil.charting.components.YAxis;
import com.github.mikephil.charting.data.BarData;
import com.github.mikephil.charting.data.BarDataSet;
import com.github.mikephil.charting.data.BarEntry;
import com.github.mikephil.charting.data.CandleData;
import com.github.mikephil.charting.data.CandleDataSet;
import com.github.mikephil.charting.data.CandleEntry;
import com.github.mikephil.charting.data.CombinedData;
import com.github.mikephil.charting.data.Entry;
import com.github.mikephil.charting.data.LineData;
import com.github.mikephil.charting.data.LineDataSet;
import com.github.mikephil.charting.interfaces.datasets.IDataSet;
import java.util.ArrayList;

public class MPCombinedChartManager
extends MPBarLineChartManager {
    private String CLASS_NAME = "MPCombinedChart";
    protected String[] mMonths = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Okt", "Nov", "Dec"};
    private final int itemcount = 12;

    @Override
    public String getName() {
        return this.CLASS_NAME;
    }

    protected CombinedChart createViewInstance(ThemedReactContext reactContext) {
        CombinedChart mChart = new CombinedChart((Context)reactContext);
        return mChart;
    }

    public LineData getLineData(ReadableMap rm) {
        ReadableArray xArray = rm.getArray("xValues");
        ArrayList<String> xVals = new ArrayList<String>();
        for (int m = 0; m < xArray.size(); ++m) {
            xVals.add(xArray.getString(m));
        }
        ReadableArray ra = rm.getArray("yValues");
        LineData chartData = new LineData(xVals);
        for (int i = 0; i < ra.size(); ++i) {
            ReadableMap map = ra.getMap(i);
            ReadableArray data = map.getArray("data");
            String label = map.getString("label");
            float[] vals = new float[data.size()];
            ArrayList<Entry> entries = new ArrayList<Entry>();
            for (int j = 0; j < data.size(); ++j) {
                vals[j] = (float)data.getDouble(j);
                Entry be = new Entry((float)data.getDouble(j), j);
                entries.add(be);
            }
            ReadableMap config = map.getMap("config");
            LineDataSet dataSet = new LineDataSet(entries, label);
            if (config.hasKey("drawCircles")) {
                dataSet.setDrawCircles(config.getBoolean("drawCircles"));
            }
            if (config.hasKey("circleSize")) {
                dataSet.setCircleSize((float)config.getDouble("circleSize"));
            }
            if (config.hasKey("colors")) {
                ReadableArray colorsArray = config.getArray("colors");
                ArrayList<Integer> colors = new ArrayList<Integer>();
                for (int c = 0; c < colorsArray.size(); ++c) {
                    colors.add(Color.parseColor((String)colorsArray.getString(c)));
                }
                dataSet.setColors(colors);
            } else if (config.hasKey("color")) {
                int[] colors = new int[]{Color.parseColor((String)config.getString("color"))};
                dataSet.setColors(colors);
            }
            chartData.addDataSet((IDataSet)dataSet);
        }
        return chartData;
    }

    public BarData getBarData(ReadableMap rm) {
        ReadableArray xArray = rm.getArray("xValues");
        ArrayList<String> xVals = new ArrayList<String>();
        for (int m = 0; m < xArray.size(); ++m) {
            xVals.add(xArray.getString(m));
        }
        ReadableArray ra = rm.getArray("yValues");
        ArrayList<BarDataSet> dataSetList = new ArrayList<BarDataSet>();
        for (int i = 0; i < ra.size(); ++i) {
            ReadableMap map = ra.getMap(i);
            ReadableArray data = map.getArray("data");
            String label = map.getString("label");
            float[] vals = new float[data.size()];
            ArrayList<BarEntry> entries = new ArrayList<BarEntry>();
            for (int j = 0; j < data.size(); ++j) {
                vals[j] = (float)data.getDouble(j);
                BarEntry be = new BarEntry((float)data.getDouble(j), j);
                entries.add(be);
            }
            BarDataSet dataSet = new BarDataSet(entries, label);
            ReadableMap config = map.getMap("config");
            if (config.hasKey("colors")) {
                ReadableArray colorsArray = config.getArray("colors");
                ArrayList<Integer> colors = new ArrayList<Integer>();
                for (int c = 0; c < colorsArray.size(); ++c) {
                    colors.add(Color.parseColor((String)colorsArray.getString(c)));
                }
                dataSet.setColors(colors);
            } else if (config.hasKey("color")) {
                int[] colors = new int[]{Color.parseColor((String)config.getString("color"))};
                dataSet.setColors(colors);
            }
            dataSetList.add(dataSet);
        }
        BarData barData = new BarData(xVals, dataSetList);
        return barData;
    }

    public CandleData getCandleData(ReadableMap rm) {
        String label = rm.getString("label");
        ReadableArray xArray = rm.getArray("data");
        ArrayList<String> xVals = new ArrayList<String>();
        for (int m = 0; m < xArray.size(); ++m) {
            xVals.add(xArray.getArray(m).getString(0));
        }
        CandleData chartData = new CandleData(xVals);
        ArrayList<CandleEntry> entries = new ArrayList<CandleEntry>();
        for (int i = 0; i < xArray.size(); ++i) {
            ReadableArray data = xArray.getArray(i);
            float open = (float)data.getDouble(1);
            float close = (float)data.getDouble(2);
            float high = (float)data.getDouble(3);
            float low = (float)data.getDouble(4);
            CandleEntry be = new CandleEntry(i, high, low, open, close);
            entries.add(be);
        }
        CandleDataSet dataSet = new CandleDataSet(entries, label);
        ReadableMap config = rm.getMap("config");
        if (config.hasKey("color")) {
            dataSet.setColor(Color.parseColor((String)config.getString("color")));
        }
        if (config.hasKey("shadowColor")) {
            dataSet.setShadowColor(Color.parseColor((String)config.getString("shadowColor")));
        }
        if (config.hasKey("shadowWidth")) {
            dataSet.setShadowWidth((float)config.getDouble("shadowWidth"));
        }
        if (config.hasKey("decreasingColor")) {
            dataSet.setDecreasingColor(Color.parseColor((String)config.getString("decreasingColor")));
        }
        if (config.hasKey("decreasingPaintStyle")) {
            dataSet.setDecreasingPaintStyle(Paint.Style.valueOf((String)config.getString("decreasingPaintStyle")));
        }
        if (config.hasKey("increasingColor")) {
            dataSet.setIncreasingColor(Color.parseColor((String)config.getString("increasingColor")));
        }
        if (config.hasKey("increasingPaintStyle")) {
            dataSet.setIncreasingPaintStyle(Paint.Style.valueOf((String)config.getString("increasingPaintStyle")));
        }
        chartData.addDataSet((IDataSet)dataSet);
        return chartData;
    }

    @ReactProp(name="data")
    public void setData(CombinedChart chart, ReadableMap rm) {
        CombinedData chartData = null;
        if (rm.hasKey("line")) {
            LineData lineData = this.getLineData(rm.getMap("line"));
            if (chartData == null) {
                chartData = new CombinedData(lineData.getXVals());
            }
            chartData.setData(lineData);
        }
        if (rm.hasKey("bar")) {
            BarData barData = this.getBarData(rm.getMap("bar"));
            if (chartData == null) {
                chartData = new CombinedData(barData.getXVals());
            }
            chartData.setData(barData);
        }
        if (rm.hasKey("candle")) {
            CandleData candleData = this.getCandleData(rm.getMap("candle"));
            if (chartData == null) {
                chartData = new CombinedData(candleData.getXVals());
            }
            chartData.setData(candleData);
        }
        chart.clear();
        chart.setData(chartData);
        chart.invalidate();
    }

    private float getRandom(float range, float startsfrom) {
        return (float)(Math.random() * (double)range) + startsfrom;
    }

    private LineData generateLineData() {
        LineData d = new LineData();
        ArrayList<Entry> entries = new ArrayList<Entry>();
        for (int index = 0; index < 12; ++index) {
            entries.add(new Entry(this.getRandom(15.0f, 10.0f), index));
        }
        LineDataSet set = new LineDataSet(entries, "Line DataSet");
        set.setColor(Color.rgb((int)240, (int)238, (int)70));
        set.setLineWidth(2.5f);
        set.setCircleColor(Color.rgb((int)240, (int)238, (int)70));
        set.setCircleSize(5.0f);
        set.setFillColor(Color.rgb((int)240, (int)238, (int)70));
        set.setDrawCubic(true);
        set.setDrawValues(true);
        set.setValueTextSize(10.0f);
        set.setValueTextColor(Color.rgb((int)240, (int)238, (int)70));
        set.setAxisDependency(YAxis.AxisDependency.LEFT);
        d.addDataSet((IDataSet)set);
        return d;
    }

    private BarData generateBarData() {
        BarData d = new BarData();
        ArrayList<BarEntry> entries = new ArrayList<BarEntry>();
        for (int index = 0; index < 12; ++index) {
            entries.add(new BarEntry(this.getRandom(15.0f, 30.0f), index));
        }
        BarDataSet set = new BarDataSet(entries, "Bar DataSet");
        set.setColor(Color.rgb((int)60, (int)220, (int)78));
        set.setValueTextColor(Color.rgb((int)60, (int)220, (int)78));
        set.setValueTextSize(10.0f);
        d.addDataSet((IDataSet)set);
        set.setAxisDependency(YAxis.AxisDependency.LEFT);
        return d;
    }
}

