/*
 * Decompiled with CFR 0.152.
 */
package cn.mandata.react_native_mpchart;

import android.content.Context;
import android.graphics.Color;
import cn.mandata.react_native_mpchart.MPBarLineChartManager;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.uimanager.ThemedReactContext;
import com.facebook.react.uimanager.annotations.ReactProp;
import com.github.mikephil.charting.charts.LineChart;
import com.github.mikephil.charting.data.ChartData;
import com.github.mikephil.charting.data.Entry;
import com.github.mikephil.charting.data.LineData;
import com.github.mikephil.charting.data.LineDataSet;
import com.github.mikephil.charting.interfaces.datasets.IDataSet;
import java.util.ArrayList;
import java.util.Random;

public class MPLineChartManager
extends MPBarLineChartManager {
    private String CLASS_NAME = "MPLineChart";
    private Random random;
    private LineChart chart;
    private LineData data;
    private LineDataSet dataSet;

    @Override
    public String getName() {
        return this.CLASS_NAME;
    }

    protected LineChart createViewInstance(ThemedReactContext reactContext) {
        LineChart chart = new LineChart((Context)reactContext);
        return chart;
    }

    @ReactProp(name="data")
    public void setData(LineChart chart, ReadableMap rm) {
        ReadableArray xArray = rm.getArray("xValues");
        ArrayList<String> xVals = new ArrayList<String>();
        for (int m = 0; m < xArray.size(); ++m) {
            xVals.add(xArray.getString(m));
        }
        ReadableArray ra = rm.getArray("yValues");
        LineData chartData = new LineData(xVals);
        for (int i = 0; i < ra.size(); ++i) {
            ReadableMap map = ra.getMap(i);
            ReadableArray data = map.getArray("data");
            String label = map.getString("label");
            float[] vals = new float[data.size()];
            ArrayList<Entry> entries = new ArrayList<Entry>();
            for (int j = 0; j < data.size(); ++j) {
                vals[j] = (float)data.getDouble(j);
                Entry be = new Entry((float)data.getDouble(j), j);
                entries.add(be);
            }
            ReadableMap config = map.getMap("config");
            LineDataSet dataSet = new LineDataSet(entries, label);
            if (config.hasKey("drawCircles")) {
                dataSet.setDrawCircles(config.getBoolean("drawCircles"));
            }
            if (config.hasKey("circleSize")) {
                dataSet.setCircleSize((float)config.getDouble("circleSize"));
            }
            if (config.hasKey("lineWidth")) {
                dataSet.setLineWidth((float)config.getDouble("lineWidth"));
            }
            if (config.hasKey("colors")) {
                ReadableArray colorsArray = config.getArray("colors");
                ArrayList<Integer> colors = new ArrayList<Integer>();
                for (int c = 0; c < colorsArray.size(); ++c) {
                    colors.add(Color.parseColor((String)colorsArray.getString(c)));
                }
                dataSet.setColors(colors);
            } else if (config.hasKey("color")) {
                int[] colors = new int[]{Color.parseColor((String)config.getString("color"))};
                dataSet.setColors(colors);
            }
            chartData.addDataSet((IDataSet)dataSet);
        }
        chart.setBackgroundColor(-1);
        chart.setData((ChartData)chartData);
        chart.invalidate();
    }
}

