/*
 * Decompiled with CFR 0.152.
 */
package cn.mandata.react_native_mpchart;

import android.content.Context;
import android.graphics.Color;
import cn.mandata.react_native_mpchart.MPPieRadarChartManager;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.uimanager.ThemedReactContext;
import com.facebook.react.uimanager.annotations.ReactProp;
import com.github.mikephil.charting.charts.PieChart;
import com.github.mikephil.charting.data.ChartData;
import com.github.mikephil.charting.data.Entry;
import com.github.mikephil.charting.data.PieData;
import com.github.mikephil.charting.data.PieDataSet;
import com.github.mikephil.charting.interfaces.datasets.IDataSet;
import java.util.ArrayList;

public class MPPieChartManager
extends MPPieRadarChartManager {
    private String CLASS_NAME = "MPPieChart";

    @Override
    public String getName() {
        return this.CLASS_NAME;
    }

    protected PieChart createViewInstance(ThemedReactContext reactContext) {
        PieChart chart = new PieChart((Context)reactContext);
        return chart;
    }

    @ReactProp(name="holeRadius", defaultFloat=50.0f)
    public void setHoleRadius(PieChart chart, float holeRadius) {
        chart.setHoleRadius(holeRadius);
        chart.invalidate();
    }

    @ReactProp(name="drawSliceText", defaultBoolean=false)
    public void setDrawSliceText(PieChart chart, boolean enabled) {
        chart.setDrawSliceText(enabled);
        chart.invalidate();
    }

    @ReactProp(name="usePercentValues", defaultBoolean=false)
    public void setUsePercentValues(PieChart chart, boolean enabled) {
        chart.setUsePercentValues(enabled);
        chart.invalidate();
    }

    @ReactProp(name="centerText")
    public void setCenterText(PieChart chart, String v) {
        chart.setCenterText((CharSequence)v);
        chart.invalidate();
    }

    @ReactProp(name="centerTextRadiusPercent", defaultFloat=1.0f)
    public void setCenterTextRadiusPercent(PieChart chart, float percent) {
        chart.setCenterTextRadiusPercent(percent);
        chart.invalidate();
    }

    @ReactProp(name="data")
    public void setData(PieChart chart, ReadableMap rm) {
        ReadableArray xArray = rm.getArray("xValues");
        ArrayList<String> xVals = new ArrayList<String>();
        for (int m = 0; m < xArray.size(); ++m) {
            xVals.add(xArray.getString(m));
        }
        ReadableArray ra = rm.getArray("yValues");
        PieData pieData = new PieData(xVals);
        for (int i = 0; i < ra.size(); ++i) {
            ReadableMap map = ra.getMap(i);
            ReadableArray data = map.getArray("data");
            String label = map.getString("label");
            float[] vals = new float[data.size()];
            ArrayList<Entry> entries = new ArrayList<Entry>();
            for (int j = 0; j < data.size(); ++j) {
                vals[j] = (float)data.getDouble(j);
                Entry be = new Entry((float)data.getDouble(j), j);
                entries.add(be);
            }
            PieDataSet dataSet = new PieDataSet(entries, label);
            ReadableMap config = map.getMap("config");
            if (config.hasKey("colors")) {
                ReadableArray colorsArray = config.getArray("colors");
                ArrayList<Integer> colors = new ArrayList<Integer>();
                for (int c = 0; c < colorsArray.size(); ++c) {
                    colors.add(Color.parseColor((String)colorsArray.getString(c)));
                }
                dataSet.setColors(colors);
            } else if (config.hasKey("color")) {
                int[] colors = new int[]{Color.parseColor((String)config.getString("color"))};
                dataSet.setColors(colors);
            }
            pieData.addDataSet((IDataSet)dataSet);
        }
        chart.setBackgroundColor(-1);
        chart.setData((ChartData)pieData);
        chart.invalidate();
    }
}

