/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.drawee.view;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import com.facebook.drawee.R;
import com.facebook.drawee.drawable.AutoRotateDrawable;
import com.facebook.drawee.drawable.ScalingUtils;
import com.facebook.drawee.generic.GenericDraweeHierarchy;
import com.facebook.drawee.generic.GenericDraweeHierarchyBuilder;
import com.facebook.drawee.generic.RoundingParams;
import com.facebook.drawee.view.AspectRatioMeasure;
import com.facebook.drawee.view.DraweeView;
import javax.annotation.Nullable;

public class GenericDraweeView
extends DraweeView<GenericDraweeHierarchy> {
    private float mAspectRatio = 0.0f;
    private final AspectRatioMeasure.Spec mMeasureSpec = new AspectRatioMeasure.Spec();

    public GenericDraweeView(Context context, GenericDraweeHierarchy hierarchy) {
        super(context);
        this.setHierarchy(hierarchy);
    }

    public GenericDraweeView(Context context) {
        super(context);
        this.inflateHierarchy(context, null);
    }

    public GenericDraweeView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.inflateHierarchy(context, attrs);
    }

    public GenericDraweeView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.inflateHierarchy(context, attrs);
    }

    @TargetApi(value=21)
    public GenericDraweeView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.inflateHierarchy(context, attrs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void inflateHierarchy(Context context, @Nullable AttributeSet attrs) {
        Resources resources = context.getResources();
        int fadeDuration = 300;
        int placeholderId = 0;
        ScalingUtils.ScaleType placeholderScaleType = GenericDraweeHierarchyBuilder.DEFAULT_SCALE_TYPE;
        int retryImageId = 0;
        ScalingUtils.ScaleType retryImageScaleType = GenericDraweeHierarchyBuilder.DEFAULT_SCALE_TYPE;
        int failureImageId = 0;
        ScalingUtils.ScaleType failureImageScaleType = GenericDraweeHierarchyBuilder.DEFAULT_SCALE_TYPE;
        int progressBarId = 0;
        ScalingUtils.ScaleType progressBarScaleType = GenericDraweeHierarchyBuilder.DEFAULT_SCALE_TYPE;
        ScalingUtils.ScaleType actualImageScaleType = GenericDraweeHierarchyBuilder.DEFAULT_ACTUAL_IMAGE_SCALE_TYPE;
        int backgroundId = 0;
        int overlayId = 0;
        int pressedStateOverlayId = 0;
        boolean roundAsCircle = false;
        int roundedCornerRadius = 0;
        boolean roundTopLeft = true;
        boolean roundTopRight = true;
        boolean roundBottomRight = true;
        boolean roundBottomLeft = true;
        int roundWithOverlayColor = 0;
        int roundingBorderWidth = 0;
        int roundingBorderColor = 0;
        int progressBarAutoRotateInterval = 0;
        if (attrs != null) {
            TypedArray gdhAttrs = context.obtainStyledAttributes(attrs, R.styleable.GenericDraweeView);
            try {
                fadeDuration = gdhAttrs.getInt(R.styleable.GenericDraweeView_fadeDuration, fadeDuration);
                this.mAspectRatio = gdhAttrs.getFloat(R.styleable.GenericDraweeView_viewAspectRatio, this.mAspectRatio);
                placeholderId = gdhAttrs.getResourceId(R.styleable.GenericDraweeView_placeholderImage, placeholderId);
                placeholderScaleType = GenericDraweeView.getScaleTypeFromXml(gdhAttrs, R.styleable.GenericDraweeView_placeholderImageScaleType, placeholderScaleType);
                retryImageId = gdhAttrs.getResourceId(R.styleable.GenericDraweeView_retryImage, retryImageId);
                retryImageScaleType = GenericDraweeView.getScaleTypeFromXml(gdhAttrs, R.styleable.GenericDraweeView_retryImageScaleType, retryImageScaleType);
                failureImageId = gdhAttrs.getResourceId(R.styleable.GenericDraweeView_failureImage, failureImageId);
                failureImageScaleType = GenericDraweeView.getScaleTypeFromXml(gdhAttrs, R.styleable.GenericDraweeView_failureImageScaleType, failureImageScaleType);
                progressBarId = gdhAttrs.getResourceId(R.styleable.GenericDraweeView_progressBarImage, progressBarId);
                progressBarScaleType = GenericDraweeView.getScaleTypeFromXml(gdhAttrs, R.styleable.GenericDraweeView_progressBarImageScaleType, progressBarScaleType);
                progressBarAutoRotateInterval = gdhAttrs.getInteger(R.styleable.GenericDraweeView_progressBarAutoRotateInterval, 0);
                actualImageScaleType = GenericDraweeView.getScaleTypeFromXml(gdhAttrs, R.styleable.GenericDraweeView_actualImageScaleType, actualImageScaleType);
                backgroundId = gdhAttrs.getResourceId(R.styleable.GenericDraweeView_backgroundImage, backgroundId);
                overlayId = gdhAttrs.getResourceId(R.styleable.GenericDraweeView_overlayImage, overlayId);
                pressedStateOverlayId = gdhAttrs.getResourceId(R.styleable.GenericDraweeView_pressedStateOverlayImage, pressedStateOverlayId);
                roundAsCircle = gdhAttrs.getBoolean(R.styleable.GenericDraweeView_roundAsCircle, roundAsCircle);
                roundedCornerRadius = gdhAttrs.getDimensionPixelSize(R.styleable.GenericDraweeView_roundedCornerRadius, roundedCornerRadius);
                roundTopLeft = gdhAttrs.getBoolean(R.styleable.GenericDraweeView_roundTopLeft, roundTopLeft);
                roundTopRight = gdhAttrs.getBoolean(R.styleable.GenericDraweeView_roundTopRight, roundTopRight);
                roundBottomRight = gdhAttrs.getBoolean(R.styleable.GenericDraweeView_roundBottomRight, roundBottomRight);
                roundBottomLeft = gdhAttrs.getBoolean(R.styleable.GenericDraweeView_roundBottomLeft, roundBottomLeft);
                roundWithOverlayColor = gdhAttrs.getColor(R.styleable.GenericDraweeView_roundWithOverlayColor, roundWithOverlayColor);
                roundingBorderWidth = gdhAttrs.getDimensionPixelSize(R.styleable.GenericDraweeView_roundingBorderWidth, roundingBorderWidth);
                roundingBorderColor = gdhAttrs.getColor(R.styleable.GenericDraweeView_roundingBorderColor, roundingBorderColor);
            }
            finally {
                gdhAttrs.recycle();
            }
        }
        GenericDraweeHierarchyBuilder builder = new GenericDraweeHierarchyBuilder(resources);
        builder.setFadeDuration(fadeDuration);
        if (placeholderId > 0) {
            builder.setPlaceholderImage(resources.getDrawable(placeholderId), placeholderScaleType);
        }
        if (retryImageId > 0) {
            builder.setRetryImage(resources.getDrawable(retryImageId), retryImageScaleType);
        }
        if (failureImageId > 0) {
            builder.setFailureImage(resources.getDrawable(failureImageId), failureImageScaleType);
        }
        if (progressBarId > 0) {
            Drawable progressBarDrawable = resources.getDrawable(progressBarId);
            if (progressBarAutoRotateInterval > 0) {
                progressBarDrawable = new AutoRotateDrawable(progressBarDrawable, progressBarAutoRotateInterval);
            }
            builder.setProgressBarImage(progressBarDrawable, progressBarScaleType);
        }
        if (backgroundId > 0) {
            builder.setBackground(resources.getDrawable(backgroundId));
        }
        if (overlayId > 0) {
            builder.setOverlay(resources.getDrawable(overlayId));
        }
        if (pressedStateOverlayId > 0) {
            builder.setPressedStateOverlay(this.getResources().getDrawable(pressedStateOverlayId));
        }
        builder.setActualImageScaleType(actualImageScaleType);
        if (roundAsCircle || roundedCornerRadius > 0) {
            RoundingParams roundingParams = new RoundingParams();
            roundingParams.setRoundAsCircle(roundAsCircle);
            if (roundedCornerRadius > 0) {
                roundingParams.setCornersRadii(roundTopLeft ? (float)roundedCornerRadius : 0.0f, roundTopRight ? (float)roundedCornerRadius : 0.0f, roundBottomRight ? (float)roundedCornerRadius : 0.0f, roundBottomLeft ? (float)roundedCornerRadius : 0.0f);
            }
            if (roundWithOverlayColor != 0) {
                roundingParams.setOverlayColor(roundWithOverlayColor);
            }
            if (roundingBorderColor != 0 && roundingBorderWidth > 0) {
                roundingParams.setBorder(roundingBorderColor, roundingBorderWidth);
            }
            builder.setRoundingParams(roundingParams);
        }
        this.setHierarchy(builder.build());
    }

    private static ScalingUtils.ScaleType getScaleTypeFromXml(TypedArray attrs, int attrId, ScalingUtils.ScaleType defaultScaleType) {
        int index = attrs.getInt(attrId, -1);
        return index < 0 ? defaultScaleType : ScalingUtils.ScaleType.values()[index];
    }

    public void setAspectRatio(float aspectRatio) {
        if (aspectRatio == this.mAspectRatio) {
            return;
        }
        this.mAspectRatio = aspectRatio;
        this.requestLayout();
    }

    public float getAspectRatio() {
        return this.mAspectRatio;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        this.mMeasureSpec.width = widthMeasureSpec;
        this.mMeasureSpec.height = heightMeasureSpec;
        AspectRatioMeasure.updateMeasureSpec(this.mMeasureSpec, this.mAspectRatio, this.getLayoutParams(), this.getPaddingLeft() + this.getPaddingRight(), this.getPaddingTop() + this.getPaddingBottom());
        super.onMeasure(this.mMeasureSpec.width, this.mMeasureSpec.height);
    }
}

