/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.codepush.react;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import com.facebook.react.ReactPackage;
import com.facebook.react.bridge.JavaScriptModule;
import com.facebook.react.bridge.NativeModule;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.bridge.WritableMap;
import com.facebook.react.uimanager.ViewManager;
import com.facebook.soloader.SoLoader;
import com.microsoft.codepush.react.CodePushDialog;
import com.microsoft.codepush.react.CodePushNativeModule;
import com.microsoft.codepush.react.CodePushNotInitializedException;
import com.microsoft.codepush.react.CodePushTelemetryManager;
import com.microsoft.codepush.react.CodePushUnknownException;
import com.microsoft.codepush.react.CodePushUpdateManager;
import com.microsoft.codepush.react.CodePushUtils;
import com.microsoft.codepush.react.SettingsManager;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.json.JSONException;
import org.json.JSONObject;

public class CodePush
implements ReactPackage {
    private static boolean sIsRunningBinaryVersion = false;
    private static boolean sNeedToReportRollback = false;
    private static boolean sTestConfigurationFlag = false;
    private boolean mDidUpdate = false;
    private String mAssetsBundleFileName;
    private CodePushUpdateManager mUpdateManager;
    private CodePushTelemetryManager mTelemetryManager;
    private SettingsManager mSettingsManager;
    private String mAppVersion;
    private String mDeploymentKey;
    private String mServerUrl = "https://codepush.azurewebsites.net/";
    private Context mContext;
    private final boolean mIsDebugMode;
    private static CodePush mCurrentInstance;

    public CodePush(String deploymentKey, Context context) {
        this(deploymentKey, context, false);
    }

    public CodePush(String deploymentKey, Context context, boolean isDebugMode) {
        SoLoader.init((Context)context, (boolean)false);
        this.mContext = context.getApplicationContext();
        this.mUpdateManager = new CodePushUpdateManager(context.getFilesDir().getAbsolutePath());
        this.mTelemetryManager = new CodePushTelemetryManager(this.mContext);
        this.mDeploymentKey = deploymentKey;
        this.mIsDebugMode = isDebugMode;
        this.mSettingsManager = new SettingsManager(this.mContext);
        try {
            PackageInfo pInfo = this.mContext.getPackageManager().getPackageInfo(this.mContext.getPackageName(), 0);
            this.mAppVersion = pInfo.versionName;
        }
        catch (PackageManager.NameNotFoundException e) {
            throw new CodePushUnknownException("Unable to get package info for " + this.mContext.getPackageName(), e);
        }
        mCurrentInstance = this;
        this.clearDebugCacheIfNeeded();
        this.initializeUpdateAfterRestart();
    }

    public CodePush(String deploymentKey, Context context, boolean isDebugMode, String serverUrl) {
        this(deploymentKey, context, isDebugMode);
        this.mServerUrl = serverUrl;
    }

    public void clearDebugCacheIfNeeded() {
        File cachedDevBundle;
        if (this.mIsDebugMode && this.mSettingsManager.isPendingUpdate(null) && (cachedDevBundle = new File(this.mContext.getFilesDir(), "ReactNativeDevBundle.js")).exists()) {
            cachedDevBundle.delete();
        }
    }

    public boolean didUpdate() {
        return this.mDidUpdate;
    }

    public String getAppVersion() {
        return this.mAppVersion;
    }

    public String getAssetsBundleFileName() {
        return this.mAssetsBundleFileName;
    }

    long getBinaryResourcesModifiedTime() {
        ZipFile applicationFile = null;
        try {
            ApplicationInfo ai = this.mContext.getPackageManager().getApplicationInfo(this.mContext.getPackageName(), 0);
            applicationFile = new ZipFile(ai.sourceDir);
            ZipEntry classesDexEntry = applicationFile.getEntry("resources.arsc");
            long l = classesDexEntry.getTime();
            return l;
        }
        catch (PackageManager.NameNotFoundException | IOException e) {
            throw new CodePushUnknownException("Error in getting file information about compiled resources", e);
        }
        finally {
            if (applicationFile != null) {
                try {
                    applicationFile.close();
                }
                catch (IOException e) {
                    throw new CodePushUnknownException("Error in closing application file.", e);
                }
            }
        }
    }

    @Deprecated
    public static String getBundleUrl() {
        return CodePush.getJSBundleFile();
    }

    @Deprecated
    public static String getBundleUrl(String assetsBundleFileName) {
        return CodePush.getJSBundleFile(assetsBundleFileName);
    }

    public Context getContext() {
        return this.mContext;
    }

    public String getDeploymentKey() {
        return this.mDeploymentKey;
    }

    public static String getJSBundleFile() {
        return CodePush.getJSBundleFile("index.android.bundle");
    }

    public static String getJSBundleFile(String assetsBundleFileName) {
        if (mCurrentInstance == null) {
            throw new CodePushNotInitializedException("A CodePush instance has not been created yet. Have you added it to your app's list of ReactPackages?");
        }
        return mCurrentInstance.getJSBundleFileInternal(assetsBundleFileName);
    }

    public String getJSBundleFileInternal(String assetsBundleFileName) {
        this.mAssetsBundleFileName = assetsBundleFileName;
        String binaryJsBundleUrl = "assets://" + assetsBundleFileName;
        long binaryResourcesModifiedTime = this.getBinaryResourcesModifiedTime();
        try {
            String packageFilePath = this.mUpdateManager.getCurrentPackageBundlePath(this.mAssetsBundleFileName);
            if (packageFilePath == null) {
                CodePushUtils.logBundleUrl(binaryJsBundleUrl);
                sIsRunningBinaryVersion = true;
                return binaryJsBundleUrl;
            }
            WritableMap packageMetadata = this.mUpdateManager.getCurrentPackage();
            Long binaryModifiedDateDuringPackageInstall = null;
            String binaryModifiedDateDuringPackageInstallString = CodePushUtils.tryGetString((ReadableMap)packageMetadata, "binaryModifiedTime");
            if (binaryModifiedDateDuringPackageInstallString != null) {
                binaryModifiedDateDuringPackageInstall = Long.parseLong(binaryModifiedDateDuringPackageInstallString);
            }
            String packageAppVersion = CodePushUtils.tryGetString((ReadableMap)packageMetadata, "appVersion");
            if (binaryModifiedDateDuringPackageInstall != null && binaryModifiedDateDuringPackageInstall == binaryResourcesModifiedTime && (CodePush.isUsingTestConfiguration() || this.mAppVersion.equals(packageAppVersion))) {
                CodePushUtils.logBundleUrl(packageFilePath);
                sIsRunningBinaryVersion = false;
                return packageFilePath;
            }
            this.mDidUpdate = false;
            if (!this.mIsDebugMode || !this.mAppVersion.equals(packageAppVersion)) {
                this.clearUpdates();
            }
            CodePushUtils.logBundleUrl(binaryJsBundleUrl);
            sIsRunningBinaryVersion = true;
            return binaryJsBundleUrl;
        }
        catch (NumberFormatException e) {
            throw new CodePushUnknownException("Error in reading binary modified date from package metadata", e);
        }
    }

    public String getServerUrl() {
        return this.mServerUrl;
    }

    void initializeUpdateAfterRestart() {
        this.mDidUpdate = false;
        JSONObject pendingUpdate = this.mSettingsManager.getPendingUpdate();
        if (pendingUpdate != null) {
            try {
                boolean updateIsLoading = pendingUpdate.getBoolean("isLoading");
                if (updateIsLoading) {
                    CodePushUtils.log("Update did not finish loading the last time, rolling back to a previous version.");
                    sNeedToReportRollback = true;
                    this.rollbackPackage();
                } else {
                    this.mDidUpdate = true;
                    this.mSettingsManager.savePendingUpdate(pendingUpdate.getString("hash"), true);
                }
            }
            catch (JSONException e) {
                throw new CodePushUnknownException("Unable to read pending update metadata stored in SharedPreferences", e);
            }
        }
    }

    void invalidateCurrentInstance() {
        mCurrentInstance = null;
    }

    boolean isDebugMode() {
        return this.mIsDebugMode;
    }

    boolean isRunningBinaryVersion() {
        return sIsRunningBinaryVersion;
    }

    boolean needToReportRollback() {
        return sNeedToReportRollback;
    }

    private void rollbackPackage() {
        WritableMap failedPackage = this.mUpdateManager.getCurrentPackage();
        this.mSettingsManager.saveFailedUpdate((ReadableMap)failedPackage);
        this.mUpdateManager.rollbackPackage();
        this.mSettingsManager.removePendingUpdate();
    }

    public void setNeedToReportRollback(boolean needToReportRollback) {
        sNeedToReportRollback = needToReportRollback;
    }

    public static boolean isUsingTestConfiguration() {
        return sTestConfigurationFlag;
    }

    public static void setUsingTestConfiguration(boolean shouldUseTestConfiguration) {
        sTestConfigurationFlag = shouldUseTestConfiguration;
    }

    public void clearUpdates() {
        this.mUpdateManager.clearUpdates();
        this.mSettingsManager.removePendingUpdate();
        this.mSettingsManager.removeFailedUpdates();
    }

    public List<NativeModule> createNativeModules(ReactApplicationContext reactApplicationContext) {
        CodePushNativeModule codePushModule = new CodePushNativeModule(reactApplicationContext, this, this.mUpdateManager, this.mTelemetryManager, this.mSettingsManager);
        CodePushDialog dialogModule = new CodePushDialog(reactApplicationContext);
        ArrayList<NativeModule> nativeModules = new ArrayList<NativeModule>();
        nativeModules.add((NativeModule)codePushModule);
        nativeModules.add((NativeModule)dialogModule);
        return nativeModules;
    }

    public List<Class<? extends JavaScriptModule>> createJSModules() {
        return new ArrayList<Class<? extends JavaScriptModule>>();
    }

    public List<ViewManager> createViewManagers(ReactApplicationContext reactApplicationContext) {
        return new ArrayList<ViewManager>();
    }
}

