/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.codepush.react;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import com.facebook.react.bridge.Callback;
import com.facebook.react.bridge.LifecycleEventListener;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReactContextBaseJavaModule;
import com.facebook.react.bridge.ReactMethod;
import com.microsoft.codepush.react.CodePushUnknownException;

public class CodePushDialog
extends ReactContextBaseJavaModule {
    public CodePushDialog(ReactApplicationContext reactContext) {
        super(reactContext);
    }

    @ReactMethod
    public void showDialog(final String title, final String message, final String button1Text, final String button2Text, final Callback successCallback, Callback errorCallback) {
        Activity currentActivity = this.getCurrentActivity();
        if (currentActivity == null) {
            this.getReactApplicationContext().addLifecycleEventListener(new LifecycleEventListener(){

                public void onHostResume() {
                    Activity currentActivity = CodePushDialog.this.getCurrentActivity();
                    if (currentActivity != null) {
                        CodePushDialog.this.getReactApplicationContext().removeLifecycleEventListener((LifecycleEventListener)this);
                        CodePushDialog.this.showDialogInternal(title, message, button1Text, button2Text, successCallback, currentActivity);
                    }
                }

                public void onHostPause() {
                }

                public void onHostDestroy() {
                }
            });
        } else {
            this.showDialogInternal(title, message, button1Text, button2Text, successCallback, currentActivity);
        }
    }

    private void showDialogInternal(String title, String message, String button1Text, String button2Text, final Callback successCallback, Activity currentActivity) {
        AlertDialog.Builder builder = new AlertDialog.Builder((Context)currentActivity);
        builder.setCancelable(false);
        DialogInterface.OnClickListener clickListener = new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                dialog.cancel();
                switch (which) {
                    case -1: {
                        successCallback.invoke(new Object[]{0});
                        break;
                    }
                    case -2: {
                        successCallback.invoke(new Object[]{1});
                        break;
                    }
                    default: {
                        throw new CodePushUnknownException("Unknown button ID pressed.");
                    }
                }
            }
        };
        if (title != null) {
            builder.setTitle((CharSequence)title);
        }
        if (message != null) {
            builder.setMessage((CharSequence)message);
        }
        if (button1Text != null) {
            builder.setPositiveButton((CharSequence)button1Text, clickListener);
        }
        if (button2Text != null) {
            builder.setNegativeButton((CharSequence)button2Text, clickListener);
        }
        AlertDialog dialog = builder.create();
        dialog.show();
    }

    public String getName() {
        return "CodePushDialog";
    }
}

