/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.codepush.react;

import android.app.Activity;
import android.content.ContentResolver;
import android.content.Context;
import android.os.AsyncTask;
import android.provider.Settings;
import android.view.Choreographer;
import com.facebook.react.ReactActivity;
import com.facebook.react.ReactInstanceManager;
import com.facebook.react.bridge.LifecycleEventListener;
import com.facebook.react.bridge.Promise;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReactContextBaseJavaModule;
import com.facebook.react.bridge.ReactMethod;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.bridge.WritableMap;
import com.facebook.react.bridge.WritableNativeMap;
import com.facebook.react.modules.core.DeviceEventManagerModule;
import com.facebook.react.uimanager.ReactChoreographer;
import com.microsoft.codepush.react.CodePush;
import com.microsoft.codepush.react.CodePushInstallMode;
import com.microsoft.codepush.react.CodePushInvalidUpdateException;
import com.microsoft.codepush.react.CodePushTelemetryManager;
import com.microsoft.codepush.react.CodePushUnknownException;
import com.microsoft.codepush.react.CodePushUpdateManager;
import com.microsoft.codepush.react.CodePushUpdateState;
import com.microsoft.codepush.react.CodePushUpdateUtils;
import com.microsoft.codepush.react.CodePushUtils;
import com.microsoft.codepush.react.DownloadProgress;
import com.microsoft.codepush.react.DownloadProgressCallback;
import com.microsoft.codepush.react.SettingsManager;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class CodePushNativeModule
extends ReactContextBaseJavaModule {
    private String mBinaryContentsHash = null;
    private String mClientUniqueId = null;
    private LifecycleEventListener mLifecycleEventListener = null;
    private int mMinimumBackgroundDuration = 0;
    private CodePush mCodePush;
    private SettingsManager mSettingsManager;
    private CodePushTelemetryManager mTelemetryManager;
    private CodePushUpdateManager mUpdateManager;
    private static final String REACT_APPLICATION_CLASS_NAME = "com.facebook.react.ReactApplication";
    private static final String REACT_NATIVE_HOST_CLASS_NAME = "com.facebook.react.ReactNativeHost";

    public CodePushNativeModule(ReactApplicationContext reactContext, CodePush codePush, CodePushUpdateManager codePushUpdateManager, CodePushTelemetryManager codePushTelemetryManager, SettingsManager settingsManager) {
        super(reactContext);
        this.mCodePush = codePush;
        this.mSettingsManager = settingsManager;
        this.mTelemetryManager = codePushTelemetryManager;
        this.mUpdateManager = codePushUpdateManager;
        this.mBinaryContentsHash = CodePushUpdateUtils.getHashForBinaryContents((Context)reactContext, this.mCodePush.isDebugMode());
        this.mClientUniqueId = Settings.Secure.getString((ContentResolver)reactContext.getContentResolver(), (String)"android_id");
    }

    public Map<String, Object> getConstants() {
        HashMap<String, Object> constants = new HashMap<String, Object>();
        constants.put("codePushInstallModeImmediate", CodePushInstallMode.IMMEDIATE.getValue());
        constants.put("codePushInstallModeOnNextRestart", CodePushInstallMode.ON_NEXT_RESTART.getValue());
        constants.put("codePushInstallModeOnNextResume", CodePushInstallMode.ON_NEXT_RESUME.getValue());
        constants.put("codePushUpdateStateRunning", CodePushUpdateState.RUNNING.getValue());
        constants.put("codePushUpdateStatePending", CodePushUpdateState.PENDING.getValue());
        constants.put("codePushUpdateStateLatest", CodePushUpdateState.LATEST.getValue());
        return constants;
    }

    public String getName() {
        return "CodePush";
    }

    private boolean isReactApplication(Context context) {
        Class reactApplicationClass = this.tryGetClass(REACT_APPLICATION_CLASS_NAME);
        return reactApplicationClass != null && reactApplicationClass.isInstance(context);
    }

    private void loadBundleLegacy(final Activity currentActivity) {
        this.mCodePush.invalidateCurrentInstance();
        currentActivity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                currentActivity.recreate();
            }
        });
    }

    private void loadBundle() {
        this.mCodePush.clearDebugCacheIfNeeded();
        final Activity currentActivity = this.getCurrentActivity();
        if (currentActivity == null) {
            return;
        }
        if (!ReactActivity.class.isInstance(currentActivity)) {
            this.loadBundleLegacy(currentActivity);
        } else {
            try {
                ReactInstanceManager instanceManager;
                ReactActivity reactActivity = (ReactActivity)currentActivity;
                try {
                    Method getApplicationMethod = ReactActivity.class.getMethod("getApplication", new Class[0]);
                    Object reactApplication = getApplicationMethod.invoke((Object)reactActivity, new Object[0]);
                    Class reactApplicationClass = this.tryGetClass(REACT_APPLICATION_CLASS_NAME);
                    Method getReactNativeHostMethod = reactApplicationClass.getMethod("getReactNativeHost", new Class[0]);
                    Object reactNativeHost = getReactNativeHostMethod.invoke(reactApplication, new Object[0]);
                    Class reactNativeHostClass = this.tryGetClass(REACT_NATIVE_HOST_CLASS_NAME);
                    Method getReactInstanceManagerMethod = reactNativeHostClass.getMethod("getReactInstanceManager", new Class[0]);
                    instanceManager = (ReactInstanceManager)getReactInstanceManagerMethod.invoke(reactNativeHost, new Object[0]);
                }
                catch (Exception e) {
                    Field instanceManagerField = ReactActivity.class.getDeclaredField("mReactInstanceManager");
                    instanceManagerField.setAccessible(true);
                    instanceManager = (ReactInstanceManager)instanceManagerField.get(reactActivity);
                }
                String latestJSBundleFile = this.mCodePush.getJSBundleFileInternal(this.mCodePush.getAssetsBundleFileName());
                Field jsBundleField = instanceManager.getClass().getDeclaredField("mJSBundleFile");
                jsBundleField.setAccessible(true);
                jsBundleField.set(instanceManager, latestJSBundleFile);
                final Method recreateMethod = instanceManager.getClass().getMethod("recreateReactContextInBackground", new Class[0]);
                final ReactInstanceManager finalizedInstanceManager = instanceManager;
                reactActivity.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            recreateMethod.invoke((Object)finalizedInstanceManager, new Object[0]);
                            CodePushNativeModule.this.mCodePush.initializeUpdateAfterRestart();
                        }
                        catch (Exception e) {
                            CodePushNativeModule.this.loadBundleLegacy(currentActivity);
                        }
                    }
                });
            }
            catch (Exception e) {
                this.loadBundleLegacy(currentActivity);
            }
        }
    }

    private Class tryGetClass(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    @ReactMethod
    public void downloadUpdate(final ReadableMap updatePackage, final boolean notifyProgress, final Promise promise) {
        AsyncTask<Void, Void, Void> asyncTask = new AsyncTask<Void, Void, Void>(){

            protected Void doInBackground(Void ... params) {
                try {
                    WritableMap mutableUpdatePackage = CodePushUtils.convertReadableMapToWritableMap(updatePackage);
                    mutableUpdatePackage.putString("binaryModifiedTime", "" + CodePushNativeModule.this.mCodePush.getBinaryResourcesModifiedTime());
                    CodePushNativeModule.this.mUpdateManager.downloadPackage((ReadableMap)mutableUpdatePackage, CodePushNativeModule.this.mCodePush.getAssetsBundleFileName(), new DownloadProgressCallback(){
                        private boolean hasScheduledNextFrame = false;
                        private DownloadProgress latestDownloadProgress = null;

                        @Override
                        public void call(DownloadProgress downloadProgress) {
                            if (!notifyProgress) {
                                return;
                            }
                            this.latestDownloadProgress = downloadProgress;
                            if (this.latestDownloadProgress.isCompleted()) {
                                this.dispatchDownloadProgressEvent();
                                return;
                            }
                            if (this.hasScheduledNextFrame) {
                                return;
                            }
                            this.hasScheduledNextFrame = true;
                            CodePushNativeModule.this.getReactApplicationContext().runOnUiQueueThread(new Runnable(){

                                @Override
                                public void run() {
                                    ReactChoreographer.getInstance().postFrameCallback(ReactChoreographer.CallbackType.TIMERS_EVENTS, new Choreographer.FrameCallback(){

                                        public void doFrame(long frameTimeNanos) {
                                            if (!latestDownloadProgress.isCompleted()) {
                                                this.dispatchDownloadProgressEvent();
                                            }
                                            hasScheduledNextFrame = false;
                                        }
                                    });
                                }
                            });
                        }

                        public void dispatchDownloadProgressEvent() {
                            ((DeviceEventManagerModule.RCTDeviceEventEmitter)CodePushNativeModule.this.getReactApplicationContext().getJSModule(DeviceEventManagerModule.RCTDeviceEventEmitter.class)).emit("CodePushDownloadProgress", (Object)this.latestDownloadProgress.createWritableMap());
                        }
                    });
                    WritableMap newPackage = CodePushNativeModule.this.mUpdateManager.getPackage(CodePushUtils.tryGetString(updatePackage, "packageHash"));
                    promise.resolve((Object)newPackage);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    promise.reject((Throwable)e);
                }
                catch (CodePushInvalidUpdateException e) {
                    e.printStackTrace();
                    CodePushNativeModule.this.mSettingsManager.saveFailedUpdate(updatePackage);
                    promise.reject((Throwable)e);
                }
                return null;
            }
        };
        asyncTask.execute((Object[])new Void[0]);
    }

    @ReactMethod
    public void getConfiguration(Promise promise) {
        WritableNativeMap configMap = new WritableNativeMap();
        configMap.putString("appVersion", this.mCodePush.getAppVersion());
        configMap.putString("clientUniqueId", this.mClientUniqueId);
        configMap.putString("deploymentKey", this.mCodePush.getDeploymentKey());
        configMap.putString("serverUrl", this.mCodePush.getServerUrl());
        if (this.mBinaryContentsHash != null) {
            configMap.putString("packageHash", this.mBinaryContentsHash);
        }
        promise.resolve((Object)configMap);
    }

    @ReactMethod
    public void getUpdateMetadata(final int updateState, final Promise promise) {
        AsyncTask<Void, Void, Void> asyncTask = new AsyncTask<Void, Void, Void>(){

            protected Void doInBackground(Void ... params) {
                WritableMap currentPackage = CodePushNativeModule.this.mUpdateManager.getCurrentPackage();
                if (currentPackage == null) {
                    promise.resolve((Object)"");
                    return null;
                }
                Boolean currentUpdateIsPending = false;
                if (currentPackage.hasKey("packageHash")) {
                    String currentHash = currentPackage.getString("packageHash");
                    currentUpdateIsPending = CodePushNativeModule.this.mSettingsManager.isPendingUpdate(currentHash);
                }
                if (updateState == CodePushUpdateState.PENDING.getValue() && !currentUpdateIsPending.booleanValue()) {
                    promise.resolve((Object)"");
                } else if (updateState == CodePushUpdateState.RUNNING.getValue() && currentUpdateIsPending.booleanValue()) {
                    promise.resolve((Object)CodePushNativeModule.this.mUpdateManager.getPreviousPackage());
                } else {
                    if (CodePushNativeModule.this.mCodePush.isRunningBinaryVersion()) {
                        currentPackage.putBoolean("_isDebugOnly", true);
                    }
                    currentPackage.putBoolean("isPending", currentUpdateIsPending.booleanValue());
                    promise.resolve((Object)currentPackage);
                }
                return null;
            }
        };
        asyncTask.execute((Object[])new Void[0]);
    }

    @ReactMethod
    public void getNewStatusReport(final Promise promise) {
        AsyncTask<Void, Void, Void> asyncTask = new AsyncTask<Void, Void, Void>(){

            protected Void doInBackground(Void ... params) {
                if (CodePushNativeModule.this.mCodePush.needToReportRollback()) {
                    CodePushNativeModule.this.mCodePush.setNeedToReportRollback(false);
                    JSONArray failedUpdates = CodePushNativeModule.this.mSettingsManager.getFailedUpdates();
                    if (failedUpdates != null && failedUpdates.length() > 0) {
                        try {
                            JSONObject lastFailedPackageJSON = failedUpdates.getJSONObject(failedUpdates.length() - 1);
                            WritableMap lastFailedPackage = CodePushUtils.convertJsonObjectToWritable(lastFailedPackageJSON);
                            WritableMap failedStatusReport = CodePushNativeModule.this.mTelemetryManager.getRollbackReport(lastFailedPackage);
                            if (failedStatusReport != null) {
                                promise.resolve((Object)failedStatusReport);
                                return null;
                            }
                        }
                        catch (JSONException e) {
                            throw new CodePushUnknownException("Unable to read failed updates information stored in SharedPreferences.", e);
                        }
                    }
                } else if (CodePushNativeModule.this.mCodePush.didUpdate()) {
                    WritableMap newPackageStatusReport;
                    WritableMap currentPackage = CodePushNativeModule.this.mUpdateManager.getCurrentPackage();
                    if (currentPackage != null && (newPackageStatusReport = CodePushNativeModule.this.mTelemetryManager.getUpdateReport(currentPackage)) != null) {
                        promise.resolve((Object)newPackageStatusReport);
                        return null;
                    }
                } else if (CodePushNativeModule.this.mCodePush.isRunningBinaryVersion()) {
                    WritableMap newAppVersionStatusReport = CodePushNativeModule.this.mTelemetryManager.getBinaryUpdateReport(CodePushNativeModule.this.mCodePush.getAppVersion());
                    if (newAppVersionStatusReport != null) {
                        promise.resolve((Object)newAppVersionStatusReport);
                        return null;
                    }
                } else {
                    WritableMap retryStatusReport = CodePushNativeModule.this.mTelemetryManager.getRetryStatusReport();
                    if (retryStatusReport != null) {
                        promise.resolve((Object)retryStatusReport);
                        return null;
                    }
                }
                promise.resolve((Object)"");
                return null;
            }
        };
        asyncTask.execute((Object[])new Void[0]);
    }

    @ReactMethod
    public void installUpdate(final ReadableMap updatePackage, final int installMode, final int minimumBackgroundDuration, final Promise promise) {
        AsyncTask<Void, Void, Void> asyncTask = new AsyncTask<Void, Void, Void>(){

            protected Void doInBackground(Void ... params) {
                CodePushNativeModule.this.mUpdateManager.installPackage(updatePackage, CodePushNativeModule.this.mSettingsManager.isPendingUpdate(null));
                String pendingHash = CodePushUtils.tryGetString(updatePackage, "packageHash");
                if (pendingHash == null) {
                    throw new CodePushUnknownException("Update package to be installed has no hash.");
                }
                CodePushNativeModule.this.mSettingsManager.savePendingUpdate(pendingHash, false);
                if (installMode == CodePushInstallMode.ON_NEXT_RESUME.getValue() || installMode == CodePushInstallMode.IMMEDIATE.getValue()) {
                    CodePushNativeModule.this.mMinimumBackgroundDuration = minimumBackgroundDuration;
                    if (CodePushNativeModule.this.mLifecycleEventListener == null) {
                        CodePushNativeModule.this.mLifecycleEventListener = new LifecycleEventListener(){
                            private Date lastPausedDate = null;

                            public void onHostResume() {
                                if (installMode == CodePushInstallMode.IMMEDIATE.getValue()) {
                                    CodePushNativeModule.this.loadBundle();
                                } else {
                                    long durationInBackground = 0L;
                                    if (this.lastPausedDate != null) {
                                        durationInBackground = (new Date().getTime() - this.lastPausedDate.getTime()) / 1000L;
                                    }
                                    if (durationInBackground >= (long)CodePushNativeModule.this.mMinimumBackgroundDuration) {
                                        CodePushNativeModule.this.loadBundle();
                                    }
                                }
                            }

                            public void onHostPause() {
                                this.lastPausedDate = new Date();
                            }

                            public void onHostDestroy() {
                            }
                        };
                        CodePushNativeModule.this.getReactApplicationContext().addLifecycleEventListener(CodePushNativeModule.this.mLifecycleEventListener);
                    }
                }
                promise.resolve((Object)"");
                return null;
            }
        };
        asyncTask.execute((Object[])new Void[0]);
    }

    @ReactMethod
    public void isFailedUpdate(String packageHash, Promise promise) {
        promise.resolve((Object)this.mSettingsManager.isFailedHash(packageHash));
    }

    @ReactMethod
    public void isFirstRun(String packageHash, Promise promise) {
        boolean isFirstRun = this.mCodePush.didUpdate() && packageHash != null && packageHash.length() > 0 && packageHash.equals(this.mUpdateManager.getCurrentPackageHash());
        promise.resolve((Object)isFirstRun);
    }

    @ReactMethod
    public void notifyApplicationReady(Promise promise) {
        this.mSettingsManager.removePendingUpdate();
        promise.resolve((Object)"");
    }

    @ReactMethod
    public void recordStatusReported(ReadableMap statusReport) {
        this.mTelemetryManager.recordStatusReported(statusReport);
    }

    @ReactMethod
    public void restartApp(boolean onlyIfUpdateIsPending, Promise promise) {
        if (!onlyIfUpdateIsPending || this.mSettingsManager.isPendingUpdate(null)) {
            this.loadBundle();
            promise.resolve((Object)true);
            return;
        }
        promise.resolve((Object)false);
    }

    @ReactMethod
    public void saveStatusReportForRetry(ReadableMap statusReport) {
        this.mTelemetryManager.saveStatusReportForRetry(statusReport);
    }

    @ReactMethod
    public void downloadAndReplaceCurrentBundle(String remoteBundleUrl) {
        CodePushNativeModule codePushNativeModule = this;
        if (codePushNativeModule.mCodePush.isUsingTestConfiguration()) {
            try {
                this.mUpdateManager.downloadAndReplaceCurrentBundle(remoteBundleUrl, this.mCodePush.getAssetsBundleFileName());
            }
            catch (IOException e) {
                throw new CodePushUnknownException("Unable to replace current bundle", e);
            }
        }
    }
}

