/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.codepush.react;

import android.content.Context;
import android.content.SharedPreferences;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.bridge.WritableMap;
import com.facebook.react.bridge.WritableNativeMap;
import com.microsoft.codepush.react.CodePushUtils;
import org.json.JSONException;
import org.json.JSONObject;

public class CodePushTelemetryManager {
    private SharedPreferences mSettings;
    private final String APP_VERSION_KEY = "appVersion";
    private final String DEPLOYMENT_FAILED_STATUS = "DeploymentFailed";
    private final String DEPLOYMENT_KEY_KEY = "deploymentKey";
    private final String DEPLOYMENT_SUCCEEDED_STATUS = "DeploymentSucceeded";
    private final String LABEL_KEY = "label";
    private final String LAST_DEPLOYMENT_REPORT_KEY = "CODE_PUSH_LAST_DEPLOYMENT_REPORT";
    private final String PACKAGE_KEY = "package";
    private final String PREVIOUS_DEPLOYMENT_KEY_KEY = "previousDeploymentKey";
    private final String PREVIOUS_LABEL_OR_APP_VERSION_KEY = "previousLabelOrAppVersion";
    private final String RETRY_DEPLOYMENT_REPORT_KEY = "CODE_PUSH_RETRY_DEPLOYMENT_REPORT";
    private final String STATUS_KEY = "status";

    public CodePushTelemetryManager(Context applicationContext) {
        this.mSettings = applicationContext.getSharedPreferences("CodePush", 0);
    }

    public WritableMap getBinaryUpdateReport(String appVersion) {
        String previousStatusReportIdentifier = this.getPreviousStatusReportIdentifier();
        WritableNativeMap reportMap = null;
        if (previousStatusReportIdentifier == null) {
            this.clearRetryStatusReport();
            reportMap = new WritableNativeMap();
            reportMap.putString("appVersion", appVersion);
        } else if (!previousStatusReportIdentifier.equals(appVersion)) {
            this.clearRetryStatusReport();
            reportMap = new WritableNativeMap();
            if (this.isStatusReportIdentifierCodePushLabel(previousStatusReportIdentifier)) {
                String previousDeploymentKey = this.getDeploymentKeyFromStatusReportIdentifier(previousStatusReportIdentifier);
                String previousLabel = this.getVersionLabelFromStatusReportIdentifier(previousStatusReportIdentifier);
                reportMap.putString("appVersion", appVersion);
                reportMap.putString("previousDeploymentKey", previousDeploymentKey);
                reportMap.putString("previousLabelOrAppVersion", previousLabel);
            } else {
                reportMap.putString("appVersion", appVersion);
                reportMap.putString("previousLabelOrAppVersion", previousStatusReportIdentifier);
            }
        }
        return reportMap;
    }

    public WritableMap getRetryStatusReport() {
        String retryStatusReportString = this.mSettings.getString("CODE_PUSH_RETRY_DEPLOYMENT_REPORT", null);
        if (retryStatusReportString != null) {
            this.clearRetryStatusReport();
            try {
                JSONObject retryStatusReport = new JSONObject(retryStatusReportString);
                return CodePushUtils.convertJsonObjectToWritable(retryStatusReport);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public WritableMap getRollbackReport(WritableMap lastFailedPackage) {
        WritableNativeMap reportMap = new WritableNativeMap();
        reportMap.putMap("package", lastFailedPackage);
        reportMap.putString("status", "DeploymentFailed");
        return reportMap;
    }

    public WritableMap getUpdateReport(WritableMap currentPackage) {
        String currentPackageIdentifier = this.getPackageStatusReportIdentifier((ReadableMap)currentPackage);
        String previousStatusReportIdentifier = this.getPreviousStatusReportIdentifier();
        WritableNativeMap reportMap = null;
        if (currentPackageIdentifier != null) {
            if (previousStatusReportIdentifier == null) {
                this.clearRetryStatusReport();
                reportMap = new WritableNativeMap();
                reportMap.putMap("package", currentPackage);
                reportMap.putString("status", "DeploymentSucceeded");
            } else if (!previousStatusReportIdentifier.equals(currentPackageIdentifier)) {
                this.clearRetryStatusReport();
                reportMap = new WritableNativeMap();
                if (this.isStatusReportIdentifierCodePushLabel(previousStatusReportIdentifier)) {
                    String previousDeploymentKey = this.getDeploymentKeyFromStatusReportIdentifier(previousStatusReportIdentifier);
                    String previousLabel = this.getVersionLabelFromStatusReportIdentifier(previousStatusReportIdentifier);
                    reportMap.putMap("package", currentPackage);
                    reportMap.putString("status", "DeploymentSucceeded");
                    reportMap.putString("previousDeploymentKey", previousDeploymentKey);
                    reportMap.putString("previousLabelOrAppVersion", previousLabel);
                } else {
                    reportMap.putMap("package", currentPackage);
                    reportMap.putString("status", "DeploymentSucceeded");
                    reportMap.putString("previousLabelOrAppVersion", previousStatusReportIdentifier);
                }
            }
        }
        return reportMap;
    }

    public void recordStatusReported(ReadableMap statusReport) {
        if (statusReport.hasKey("status") && "DeploymentFailed".equals(statusReport.getString("status"))) {
            return;
        }
        if (statusReport.hasKey("appVersion")) {
            this.saveStatusReportedForIdentifier(statusReport.getString("appVersion"));
        } else if (statusReport.hasKey("package")) {
            String packageIdentifier = this.getPackageStatusReportIdentifier(statusReport.getMap("package"));
            this.saveStatusReportedForIdentifier(packageIdentifier);
        }
    }

    public void saveStatusReportForRetry(ReadableMap statusReport) {
        JSONObject statusReportJSON = CodePushUtils.convertReadableToJsonObject(statusReport);
        this.mSettings.edit().putString("CODE_PUSH_RETRY_DEPLOYMENT_REPORT", statusReportJSON.toString()).commit();
    }

    private void clearRetryStatusReport() {
        this.mSettings.edit().remove("CODE_PUSH_RETRY_DEPLOYMENT_REPORT").commit();
    }

    private String getDeploymentKeyFromStatusReportIdentifier(String statusReportIdentifier) {
        String[] parsedIdentifier = statusReportIdentifier.split(":");
        if (parsedIdentifier.length > 0) {
            return parsedIdentifier[0];
        }
        return null;
    }

    private String getPackageStatusReportIdentifier(ReadableMap updatePackage) {
        String deploymentKey = CodePushUtils.tryGetString(updatePackage, "deploymentKey");
        String label = CodePushUtils.tryGetString(updatePackage, "label");
        if (deploymentKey != null && label != null) {
            return deploymentKey + ":" + label;
        }
        return null;
    }

    private String getPreviousStatusReportIdentifier() {
        return this.mSettings.getString("CODE_PUSH_LAST_DEPLOYMENT_REPORT", null);
    }

    private String getVersionLabelFromStatusReportIdentifier(String statusReportIdentifier) {
        String[] parsedIdentifier = statusReportIdentifier.split(":");
        if (parsedIdentifier.length > 1) {
            return parsedIdentifier[1];
        }
        return null;
    }

    private boolean isStatusReportIdentifierCodePushLabel(String statusReportIdentifier) {
        return statusReportIdentifier != null && statusReportIdentifier.contains(":");
    }

    private void saveStatusReportedForIdentifier(String appVersionOrPackageIdentifier) {
        this.mSettings.edit().putString("CODE_PUSH_LAST_DEPLOYMENT_REPORT", appVersionOrPackageIdentifier).commit();
    }
}

