/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.codepush.react;

import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.bridge.WritableMap;
import com.facebook.react.bridge.WritableNativeMap;
import com.microsoft.codepush.react.CodePush;
import com.microsoft.codepush.react.CodePushInvalidUpdateException;
import com.microsoft.codepush.react.CodePushMalformedDataException;
import com.microsoft.codepush.react.CodePushUnknownException;
import com.microsoft.codepush.react.CodePushUpdateUtils;
import com.microsoft.codepush.react.CodePushUtils;
import com.microsoft.codepush.react.DownloadProgress;
import com.microsoft.codepush.react.DownloadProgressCallback;
import com.microsoft.codepush.react.FileUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.ByteBuffer;
import org.json.JSONException;
import org.json.JSONObject;

public class CodePushUpdateManager {
    private String mDocumentsDirectory;

    public CodePushUpdateManager(String documentsDirectory) {
        this.mDocumentsDirectory = documentsDirectory;
    }

    private String getDownloadFilePath() {
        return CodePushUtils.appendPathComponent(this.getCodePushPath(), "download.zip");
    }

    private String getUnzippedFolderPath() {
        return CodePushUtils.appendPathComponent(this.getCodePushPath(), "unzipped");
    }

    private String getDocumentsDirectory() {
        return this.mDocumentsDirectory;
    }

    private String getCodePushPath() {
        String codePushPath = CodePushUtils.appendPathComponent(this.getDocumentsDirectory(), "CodePush");
        if (CodePush.isUsingTestConfiguration()) {
            codePushPath = CodePushUtils.appendPathComponent(codePushPath, "TestPackages");
        }
        return codePushPath;
    }

    private String getStatusFilePath() {
        return CodePushUtils.appendPathComponent(this.getCodePushPath(), "codepush.json");
    }

    public WritableMap getCurrentPackageInfo() {
        String statusFilePath = this.getStatusFilePath();
        if (!FileUtils.fileAtPathExists(statusFilePath)) {
            return new WritableNativeMap();
        }
        try {
            return CodePushUtils.getWritableMapFromFile(statusFilePath);
        }
        catch (IOException e) {
            throw new CodePushUnknownException("Error getting current package info", e);
        }
    }

    public void updateCurrentPackageInfo(ReadableMap packageInfo) {
        try {
            CodePushUtils.writeReadableMapToFile(packageInfo, this.getStatusFilePath());
        }
        catch (IOException e) {
            throw new CodePushUnknownException("Error updating current package info", e);
        }
    }

    public String getCurrentPackageFolderPath() {
        WritableMap info = this.getCurrentPackageInfo();
        String packageHash = CodePushUtils.tryGetString((ReadableMap)info, "currentPackage");
        if (packageHash == null) {
            return null;
        }
        return this.getPackageFolderPath(packageHash);
    }

    public String getCurrentPackageBundlePath(String bundleFileName) {
        String packageFolder = this.getCurrentPackageFolderPath();
        if (packageFolder == null) {
            return null;
        }
        WritableMap currentPackage = this.getCurrentPackage();
        if (currentPackage == null) {
            return null;
        }
        String relativeBundlePath = CodePushUtils.tryGetString((ReadableMap)currentPackage, "bundlePath");
        if (relativeBundlePath == null) {
            return CodePushUtils.appendPathComponent(packageFolder, bundleFileName);
        }
        return CodePushUtils.appendPathComponent(packageFolder, relativeBundlePath);
    }

    public String getPackageFolderPath(String packageHash) {
        return CodePushUtils.appendPathComponent(this.getCodePushPath(), packageHash);
    }

    public String getCurrentPackageHash() {
        WritableMap info = this.getCurrentPackageInfo();
        return CodePushUtils.tryGetString((ReadableMap)info, "currentPackage");
    }

    public String getPreviousPackageHash() {
        WritableMap info = this.getCurrentPackageInfo();
        return CodePushUtils.tryGetString((ReadableMap)info, "previousPackage");
    }

    public WritableMap getCurrentPackage() {
        String packageHash = this.getCurrentPackageHash();
        if (packageHash == null) {
            return null;
        }
        return this.getPackage(packageHash);
    }

    public WritableMap getPreviousPackage() {
        String packageHash = this.getPreviousPackageHash();
        if (packageHash == null) {
            return null;
        }
        return this.getPackage(packageHash);
    }

    public WritableMap getPackage(String packageHash) {
        String folderPath = this.getPackageFolderPath(packageHash);
        String packageFilePath = CodePushUtils.appendPathComponent(folderPath, "app.json");
        try {
            return CodePushUtils.getWritableMapFromFile(packageFilePath);
        }
        catch (IOException e) {
            return null;
        }
    }

    public void downloadPackage(ReadableMap updatePackage, String expectedBundleFileName, DownloadProgressCallback progressCallback) throws IOException {
        String newUpdateHash = CodePushUtils.tryGetString(updatePackage, "packageHash");
        String newUpdateFolderPath = this.getPackageFolderPath(newUpdateHash);
        String newUpdateMetadataPath = CodePushUtils.appendPathComponent(newUpdateFolderPath, "app.json");
        if (FileUtils.fileAtPathExists(newUpdateFolderPath)) {
            FileUtils.deleteDirectoryAtPath(newUpdateFolderPath);
        }
        String downloadUrlString = CodePushUtils.tryGetString(updatePackage, "downloadUrl");
        HttpURLConnection connection = null;
        BufferedInputStream bin = null;
        FileOutputStream fos = null;
        FilterOutputStream bout = null;
        File downloadFile = null;
        boolean isZip = false;
        try {
            URL downloadUrl = new URL(downloadUrlString);
            connection = (HttpURLConnection)downloadUrl.openConnection();
            long totalBytes = connection.getContentLength();
            long receivedBytes = 0L;
            bin = new BufferedInputStream(connection.getInputStream());
            File downloadFolder = new File(this.getCodePushPath());
            downloadFolder.mkdirs();
            downloadFile = new File(downloadFolder, "download.zip");
            fos = new FileOutputStream(downloadFile);
            bout = new BufferedOutputStream(fos, 262144);
            byte[] data = new byte[262144];
            byte[] header = new byte[4];
            int numBytesRead = 0;
            while ((numBytesRead = bin.read(data, 0, 262144)) >= 0) {
                if (receivedBytes < 4L) {
                    int headerOffset;
                    for (int i = 0; i < numBytesRead && (headerOffset = (int)receivedBytes + i) < 4; ++i) {
                        header[headerOffset] = data[i];
                    }
                }
                ((BufferedOutputStream)bout).write(data, 0, numBytesRead);
                progressCallback.call(new DownloadProgress(totalBytes, receivedBytes += (long)numBytesRead));
            }
            if (totalBytes != receivedBytes) {
                throw new CodePushUnknownException("Received " + receivedBytes + " bytes, expected " + totalBytes);
            }
            isZip = ByteBuffer.wrap(header).getInt() == 1347093252;
        }
        catch (MalformedURLException e) {
            throw new CodePushMalformedDataException(downloadUrlString, e);
        }
        finally {
            try {
                if (bout != null) {
                    bout.close();
                }
                if (fos != null) {
                    fos.close();
                }
                if (bin != null) {
                    bin.close();
                }
                if (connection != null) {
                    connection.disconnect();
                }
            }
            catch (IOException e) {
                throw new CodePushUnknownException("Error closing IO resources.", e);
            }
        }
        if (isZip) {
            String unzippedFolderPath = this.getUnzippedFolderPath();
            FileUtils.unzipFile(downloadFile, unzippedFolderPath);
            FileUtils.deleteFileOrFolderSilently(downloadFile);
            String diffManifestFilePath = CodePushUtils.appendPathComponent(unzippedFolderPath, "hotcodepush.json");
            boolean isDiffUpdate = FileUtils.fileAtPathExists(diffManifestFilePath);
            if (isDiffUpdate) {
                String currentPackageFolderPath = this.getCurrentPackageFolderPath();
                CodePushUpdateUtils.copyNecessaryFilesFromCurrentPackage(diffManifestFilePath, currentPackageFolderPath, newUpdateFolderPath);
                File diffManifestFile = new File(diffManifestFilePath);
                diffManifestFile.delete();
            }
            FileUtils.copyDirectoryContents(unzippedFolderPath, newUpdateFolderPath);
            FileUtils.deleteFileAtPathSilently(unzippedFolderPath);
            String relativeBundlePath = CodePushUpdateUtils.findJSBundleInUpdateContents(newUpdateFolderPath, expectedBundleFileName);
            if (relativeBundlePath == null) {
                throw new CodePushInvalidUpdateException("Update is invalid - A JS bundle file named \"" + expectedBundleFileName + "\" could not be found within the downloaded contents. Please check that you are releasing your CodePush updates using the exact same JS bundle file name that was shipped with your app's binary.");
            }
            if (FileUtils.fileAtPathExists(newUpdateMetadataPath)) {
                File metadataFileFromOldUpdate = new File(newUpdateMetadataPath);
                metadataFileFromOldUpdate.delete();
            }
            if (isDiffUpdate) {
                CodePushUpdateUtils.verifyHashForDiffUpdate(newUpdateFolderPath, newUpdateHash);
            }
            JSONObject updatePackageJSON = CodePushUtils.convertReadableToJsonObject(updatePackage);
            try {
                updatePackageJSON.put("bundlePath", (Object)relativeBundlePath);
            }
            catch (JSONException e) {
                throw new CodePushUnknownException("Unable to set key bundlePath to value " + relativeBundlePath + " in update package.", e);
            }
            updatePackage = CodePushUtils.convertJsonObjectToWritable(updatePackageJSON);
        } else {
            FileUtils.moveFile(downloadFile, newUpdateFolderPath, expectedBundleFileName);
        }
        CodePushUtils.writeReadableMapToFile(updatePackage, newUpdateMetadataPath);
    }

    public void installPackage(ReadableMap updatePackage, boolean removePendingUpdate) {
        String packageHash = CodePushUtils.tryGetString(updatePackage, "packageHash");
        WritableMap info = this.getCurrentPackageInfo();
        String currentPackageHash = CodePushUtils.tryGetString((ReadableMap)info, "currentPackage");
        if (packageHash != null && packageHash.equals(currentPackageHash)) {
            return;
        }
        if (removePendingUpdate) {
            String currentPackageFolderPath = this.getCurrentPackageFolderPath();
            if (currentPackageFolderPath != null) {
                FileUtils.deleteDirectoryAtPath(currentPackageFolderPath);
            }
        } else {
            String previousPackageHash = this.getPreviousPackageHash();
            if (previousPackageHash != null && !previousPackageHash.equals(packageHash)) {
                FileUtils.deleteDirectoryAtPath(this.getPackageFolderPath(previousPackageHash));
            }
            info.putString("previousPackage", CodePushUtils.tryGetString((ReadableMap)info, "currentPackage"));
        }
        info.putString("currentPackage", packageHash);
        this.updateCurrentPackageInfo((ReadableMap)info);
    }

    public void rollbackPackage() {
        WritableMap info = this.getCurrentPackageInfo();
        String currentPackageFolderPath = this.getCurrentPackageFolderPath();
        FileUtils.deleteDirectoryAtPath(currentPackageFolderPath);
        info.putString("currentPackage", CodePushUtils.tryGetString((ReadableMap)info, "previousPackage"));
        info.putNull("previousPackage");
        this.updateCurrentPackageInfo((ReadableMap)info);
    }

    public void downloadAndReplaceCurrentBundle(String remoteBundleUrl, String bundleFileName) throws IOException {
        HttpURLConnection connection = null;
        BufferedInputStream bin = null;
        FileOutputStream fos = null;
        FilterOutputStream bout = null;
        try {
            URL downloadUrl = new URL(remoteBundleUrl);
            connection = (HttpURLConnection)downloadUrl.openConnection();
            bin = new BufferedInputStream(connection.getInputStream());
            File downloadFile = new File(this.getCurrentPackageBundlePath(bundleFileName));
            downloadFile.delete();
            fos = new FileOutputStream(downloadFile);
            bout = new BufferedOutputStream(fos, 262144);
            byte[] data = new byte[262144];
            int numBytesRead = 0;
            while ((numBytesRead = bin.read(data, 0, 262144)) >= 0) {
                ((BufferedOutputStream)bout).write(data, 0, numBytesRead);
            }
        }
        catch (MalformedURLException e) {
            throw new CodePushMalformedDataException(remoteBundleUrl, e);
        }
        finally {
            try {
                if (bout != null) {
                    bout.close();
                }
                if (fos != null) {
                    fos.close();
                }
                if (bin != null) {
                    bin.close();
                }
                if (connection != null) {
                    connection.disconnect();
                }
            }
            catch (IOException e) {
                throw new CodePushUnknownException("Error closing IO resources.", e);
            }
        }
    }

    public void clearUpdates() {
        FileUtils.deleteDirectoryAtPath(this.getCodePushPath());
    }
}

