/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.codepush.react;

import android.content.Context;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.WritableMap;
import com.microsoft.codepush.react.CodePushInvalidUpdateException;
import com.microsoft.codepush.react.CodePushUnknownException;
import com.microsoft.codepush.react.CodePushUtils;
import com.microsoft.codepush.react.FileUtils;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import org.json.JSONArray;

public class CodePushUpdateUtils {
    private static void addContentsOfFolderToManifest(String folderPath, String pathPrefix, ArrayList<String> manifest) {
        File[] folderFiles;
        File folder = new File(folderPath);
        for (File file : folderFiles = folder.listFiles()) {
            String fullFilePath = file.getAbsolutePath();
            String relativePath = (pathPrefix.isEmpty() ? "" : pathPrefix + "/") + file.getName();
            if (file.isDirectory()) {
                CodePushUpdateUtils.addContentsOfFolderToManifest(fullFilePath, relativePath, manifest);
                continue;
            }
            try {
                manifest.add(relativePath + ":" + CodePushUpdateUtils.computeHash(new FileInputStream(file)));
            }
            catch (FileNotFoundException e) {
                throw new CodePushUnknownException("Unable to compute hash of update contents.", e);
            }
        }
    }

    private static String computeHash(InputStream dataStream) {
        MessageDigest messageDigest = null;
        FilterInputStream digestInputStream = null;
        try {
            messageDigest = MessageDigest.getInstance("SHA-256");
            digestInputStream = new DigestInputStream(dataStream, messageDigest);
            byte[] byteBuffer = new byte[8192];
            while (digestInputStream.read(byteBuffer) != -1) {
            }
        }
        catch (IOException | NoSuchAlgorithmException e) {
            throw new CodePushUnknownException("Unable to compute hash of update contents.", e);
        }
        finally {
            try {
                if (digestInputStream != null) {
                    digestInputStream.close();
                }
                if (dataStream != null) {
                    dataStream.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        byte[] hash = messageDigest.digest();
        return String.format("%064x", new BigInteger(1, hash));
    }

    public static void copyNecessaryFilesFromCurrentPackage(String diffManifestFilePath, String currentPackageFolderPath, String newPackageFolderPath) throws IOException {
        FileUtils.copyDirectoryContents(currentPackageFolderPath, newPackageFolderPath);
        WritableMap diffManifest = CodePushUtils.getWritableMapFromFile(diffManifestFilePath);
        ReadableArray deletedFiles = diffManifest.getArray("deletedFiles");
        for (int i = 0; i < deletedFiles.size(); ++i) {
            String fileNameToDelete = deletedFiles.getString(i);
            File fileToDelete = new File(newPackageFolderPath, fileNameToDelete);
            if (!fileToDelete.exists()) continue;
            fileToDelete.delete();
        }
    }

    public static String findJSBundleInUpdateContents(String folderPath, String expectedFileName) {
        File[] folderFiles;
        File folder = new File(folderPath);
        for (File file : folderFiles = folder.listFiles()) {
            String fullFilePath = CodePushUtils.appendPathComponent(folderPath, file.getName());
            if (file.isDirectory()) {
                String mainBundlePathInSubFolder = CodePushUpdateUtils.findJSBundleInUpdateContents(fullFilePath, expectedFileName);
                if (mainBundlePathInSubFolder == null) continue;
                return CodePushUtils.appendPathComponent(file.getName(), mainBundlePathInSubFolder);
            }
            String fileName = file.getName();
            if (!fileName.equals(expectedFileName)) continue;
            return fileName;
        }
        return null;
    }

    public static String getHashForBinaryContents(Context context, boolean isDebugMode) {
        try {
            return CodePushUtils.getStringFromInputStream(context.getAssets().open("CodePushHash.json"));
        }
        catch (IOException e) {
            if (!isDebugMode) {
                CodePushUtils.log("Unable to get the hash of the binary's bundled resources - \"codepush.gradle\" may have not been added to the build definition.");
            }
            return null;
        }
    }

    public static void verifyHashForDiffUpdate(String folderPath, String expectedHash) {
        ArrayList<String> updateContentsManifest = new ArrayList<String>();
        CodePushUpdateUtils.addContentsOfFolderToManifest(folderPath, "", updateContentsManifest);
        Collections.sort(updateContentsManifest);
        JSONArray updateContentsJSONArray = new JSONArray();
        for (String manifestEntry : updateContentsManifest) {
            updateContentsJSONArray.put((Object)manifestEntry);
        }
        String updateContentsManifestString = updateContentsJSONArray.toString().replace("\\/", "/");
        String updateContentsManifestHash = CodePushUpdateUtils.computeHash(new ByteArrayInputStream(updateContentsManifestString.getBytes()));
        if (!expectedHash.equals(updateContentsManifestHash)) {
            throw new CodePushInvalidUpdateException("The update contents failed the data integrity check.");
        }
    }
}

