/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.codepush.react;

import android.content.Context;
import android.content.SharedPreferences;
import com.facebook.react.bridge.ReadableMap;
import com.microsoft.codepush.react.CodePushMalformedDataException;
import com.microsoft.codepush.react.CodePushUnknownException;
import com.microsoft.codepush.react.CodePushUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class SettingsManager {
    private SharedPreferences mSettings;

    public SettingsManager(Context applicationContext) {
        this.mSettings = applicationContext.getSharedPreferences("CodePush", 0);
    }

    public JSONArray getFailedUpdates() {
        String failedUpdatesString = this.mSettings.getString("CODE_PUSH_FAILED_UPDATES", null);
        if (failedUpdatesString == null) {
            return new JSONArray();
        }
        try {
            return new JSONArray(failedUpdatesString);
        }
        catch (JSONException e) {
            JSONArray emptyArray = new JSONArray();
            this.mSettings.edit().putString("CODE_PUSH_FAILED_UPDATES", emptyArray.toString()).commit();
            return emptyArray;
        }
    }

    public JSONObject getPendingUpdate() {
        String pendingUpdateString = this.mSettings.getString("CODE_PUSH_PENDING_UPDATE", null);
        if (pendingUpdateString == null) {
            return null;
        }
        try {
            return new JSONObject(pendingUpdateString);
        }
        catch (JSONException e) {
            CodePushUtils.log("Unable to parse pending update metadata " + pendingUpdateString + " stored in SharedPreferences");
            return null;
        }
    }

    public boolean isFailedHash(String packageHash) {
        JSONArray failedUpdates = this.getFailedUpdates();
        if (packageHash != null) {
            for (int i = 0; i < failedUpdates.length(); ++i) {
                try {
                    JSONObject failedPackage = failedUpdates.getJSONObject(i);
                    String failedPackageHash = failedPackage.getString("packageHash");
                    if (!packageHash.equals(failedPackageHash)) continue;
                    return true;
                }
                catch (JSONException e) {
                    throw new CodePushUnknownException("Unable to read failedUpdates data stored in SharedPreferences.", e);
                }
            }
        }
        return false;
    }

    public boolean isPendingUpdate(String packageHash) {
        JSONObject pendingUpdate = this.getPendingUpdate();
        try {
            return pendingUpdate != null && !pendingUpdate.getBoolean("isLoading") && (packageHash == null || pendingUpdate.getString("hash").equals(packageHash));
        }
        catch (JSONException e) {
            throw new CodePushUnknownException("Unable to read pending update metadata in isPendingUpdate.", e);
        }
    }

    public void removeFailedUpdates() {
        this.mSettings.edit().remove("CODE_PUSH_FAILED_UPDATES").commit();
    }

    public void removePendingUpdate() {
        this.mSettings.edit().remove("CODE_PUSH_PENDING_UPDATE").commit();
    }

    public void saveFailedUpdate(ReadableMap failedPackage) {
        JSONArray failedUpdates;
        String failedUpdatesString = this.mSettings.getString("CODE_PUSH_FAILED_UPDATES", null);
        if (failedUpdatesString == null) {
            failedUpdates = new JSONArray();
        } else {
            try {
                failedUpdates = new JSONArray(failedUpdatesString);
            }
            catch (JSONException e) {
                throw new CodePushMalformedDataException("Unable to parse failed updates information " + failedUpdatesString + " stored in SharedPreferences", e);
            }
        }
        JSONObject failedPackageJSON = CodePushUtils.convertReadableToJsonObject(failedPackage);
        failedUpdates.put((Object)failedPackageJSON);
        this.mSettings.edit().putString("CODE_PUSH_FAILED_UPDATES", failedUpdates.toString()).commit();
    }

    public void savePendingUpdate(String packageHash, boolean isLoading) {
        JSONObject pendingUpdate = new JSONObject();
        try {
            pendingUpdate.put("hash", (Object)packageHash);
            pendingUpdate.put("isLoading", isLoading);
            this.mSettings.edit().putString("CODE_PUSH_PENDING_UPDATE", pendingUpdate.toString()).commit();
        }
        catch (JSONException e) {
            throw new CodePushUnknownException("Unable to save pending update.", e);
        }
    }
}

