/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.uimanager;

import android.view.View;
import com.facebook.common.logging.FLog;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.bridge.ReadableMapKeySetIterator;
import com.facebook.react.uimanager.CatalystStylesDiffMap;
import com.facebook.react.uimanager.ReactShadowNode;
import com.facebook.react.uimanager.ViewManager;
import com.facebook.react.uimanager.ViewManagersPropertyCache;
import java.util.HashMap;
import java.util.Map;

public class ViewManagerPropertyUpdater {
    private static final String TAG = "ViewManagerPropertyUpdater";
    private static final Map<Class<?>, ViewManagerSetter<?, ?>> VIEW_MANAGER_SETTER_MAP = new HashMap();
    private static final Map<Class<?>, ShadowNodeSetter<?>> SHADOW_NODE_SETTER_MAP = new HashMap();

    public static <T extends ViewManager, V extends View> void updateProps(T manager, V v, CatalystStylesDiffMap props) {
        ViewManagerSetter<T, V> setter = ViewManagerPropertyUpdater.findManagerSetter(manager.getClass());
        ReadableMap propMap = props.mBackingMap;
        ReadableMapKeySetIterator iterator = propMap.keySetIterator();
        while (iterator.hasNextKey()) {
            String key = iterator.nextKey();
            setter.setProperty(manager, v, key, props);
        }
    }

    public static <T extends ReactShadowNode> void updateProps(T node, CatalystStylesDiffMap props) {
        ShadowNodeSetter<T> setter = ViewManagerPropertyUpdater.findNodeSetter(node.getClass());
        ReadableMap propMap = props.mBackingMap;
        ReadableMapKeySetIterator iterator = propMap.keySetIterator();
        while (iterator.hasNextKey()) {
            String key = iterator.nextKey();
            setter.setProperty(node, key, props);
        }
    }

    public static Map<String, String> getNativeProps(Class<? extends ViewManager> viewManagerTopClass, Class<? extends ReactShadowNode> shadowNodeTopClass) {
        HashMap<String, String> props = new HashMap<String, String>();
        props.putAll(ViewManagerPropertyUpdater.findManagerSetter(viewManagerTopClass).getProperties());
        props.putAll(ViewManagerPropertyUpdater.findNodeSetter(shadowNodeTopClass).getProperties());
        return props;
    }

    private static <T extends ViewManager, V extends View> ViewManagerSetter<T, V> findManagerSetter(Class<? extends ViewManager> managerClass) {
        FallbackViewManagerSetter setter = VIEW_MANAGER_SETTER_MAP.get(managerClass);
        if (setter == null) {
            setter = (FallbackViewManagerSetter)ViewManagerPropertyUpdater.findGeneratedSetter(managerClass);
            if (setter == null) {
                setter = new FallbackViewManagerSetter(managerClass);
            }
            VIEW_MANAGER_SETTER_MAP.put(managerClass, setter);
        }
        return setter;
    }

    private static <T extends ReactShadowNode> ShadowNodeSetter<T> findNodeSetter(Class<? extends ReactShadowNode> nodeClass) {
        FallbackShadowNodeSetter setter = SHADOW_NODE_SETTER_MAP.get(nodeClass);
        if (setter == null) {
            setter = (FallbackShadowNodeSetter)ViewManagerPropertyUpdater.findGeneratedSetter(nodeClass);
            if (setter == null) {
                setter = new FallbackShadowNodeSetter(nodeClass);
            }
            SHADOW_NODE_SETTER_MAP.put(nodeClass, setter);
        }
        return setter;
    }

    private static <T> T findGeneratedSetter(Class<?> cls) {
        String clsName = cls.getName();
        try {
            Class<?> setterClass = Class.forName(clsName + "$$PropsSetter");
            return (T)setterClass.newInstance();
        }
        catch (ClassNotFoundException e) {
            FLog.w((String)TAG, (String)("Could not find generated setter for " + cls));
            return null;
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException("Unable to instantiate methods getter for " + clsName, e);
        }
    }

    private static class FallbackShadowNodeSetter<T extends ReactShadowNode>
    implements ShadowNodeSetter<T> {
        private final Map<String, ViewManagersPropertyCache.PropSetter> mPropSetters;

        private FallbackShadowNodeSetter(Class<? extends ReactShadowNode> shadowNodeClass) {
            this.mPropSetters = ViewManagersPropertyCache.getNativePropSettersForShadowNodeClass(shadowNodeClass);
        }

        @Override
        public void setProperty(ReactShadowNode node, String name, CatalystStylesDiffMap props) {
            ViewManagersPropertyCache.PropSetter setter = this.mPropSetters.get(name);
            if (setter != null) {
                setter.updateShadowNodeProp(node, props);
            }
        }

        @Override
        public Map<String, String> getProperties() {
            HashMap<String, String> nativeProps = new HashMap<String, String>();
            for (ViewManagersPropertyCache.PropSetter setter : this.mPropSetters.values()) {
                nativeProps.put(setter.getPropName(), setter.getPropType());
            }
            return nativeProps;
        }
    }

    private static class FallbackViewManagerSetter<T extends ViewManager, V extends View>
    implements ViewManagerSetter<T, V> {
        private final Map<String, ViewManagersPropertyCache.PropSetter> mPropSetters;

        private FallbackViewManagerSetter(Class<? extends ViewManager> viewManagerClass) {
            this.mPropSetters = ViewManagersPropertyCache.getNativePropSettersForViewManagerClass(viewManagerClass);
        }

        @Override
        public void setProperty(T manager, V v, String name, CatalystStylesDiffMap props) {
            ViewManagersPropertyCache.PropSetter setter = this.mPropSetters.get(name);
            if (setter != null) {
                setter.updateViewProp((ViewManager)manager, (View)v, props);
            }
        }

        @Override
        public Map<String, String> getProperties() {
            HashMap<String, String> nativeProps = new HashMap<String, String>();
            for (ViewManagersPropertyCache.PropSetter setter : this.mPropSetters.values()) {
                nativeProps.put(setter.getPropName(), setter.getPropType());
            }
            return nativeProps;
        }
    }

    public static interface ShadowNodeSetter<T extends ReactShadowNode>
    extends Settable {
        public void setProperty(T var1, String var2, CatalystStylesDiffMap var3);
    }

    public static interface ViewManagerSetter<T extends ViewManager, V extends View>
    extends Settable {
        public void setProperty(T var1, V var2, String var3, CatalystStylesDiffMap var4);
    }

    public static interface Settable {
        public Map<String, String> getProperties();
    }
}

