/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.text;

import android.content.res.AssetManager;
import android.graphics.Typeface;
import android.util.SparseArray;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;

public class ReactFontManager {
    private static final String[] EXTENSIONS = new String[]{"", "_bold", "_italic", "_bold_italic"};
    private static final String[] FILE_EXTENSIONS = new String[]{".ttf", ".otf"};
    private static final String FONTS_ASSET_PATH = "fonts/";
    private static ReactFontManager sReactFontManagerInstance;
    private Map<String, FontFamily> mFontCache = new HashMap<String, FontFamily>();

    private ReactFontManager() {
    }

    public static ReactFontManager getInstance() {
        if (sReactFontManagerInstance == null) {
            sReactFontManagerInstance = new ReactFontManager();
        }
        return sReactFontManagerInstance;
    }

    @Nullable
    public Typeface getTypeface(String fontFamilyName, int style2, AssetManager assetManager) {
        Typeface typeface;
        FontFamily fontFamily = this.mFontCache.get(fontFamilyName);
        if (fontFamily == null) {
            fontFamily = new FontFamily();
            this.mFontCache.put(fontFamilyName, fontFamily);
        }
        if ((typeface = fontFamily.getTypeface(style2)) == null && (typeface = ReactFontManager.createTypeface(fontFamilyName, style2, assetManager)) != null) {
            fontFamily.setTypeface(style2, typeface);
        }
        return typeface;
    }

    @Nullable
    private static Typeface createTypeface(String fontFamilyName, int style2, AssetManager assetManager) {
        String extension = EXTENSIONS[style2];
        for (String fileExtension : FILE_EXTENSIONS) {
            String fileName = FONTS_ASSET_PATH + fontFamilyName + extension + fileExtension;
            try {
                return Typeface.createFromAsset((AssetManager)assetManager, (String)fileName);
            }
            catch (RuntimeException e) {
            }
        }
        return Typeface.create((String)fontFamilyName, (int)style2);
    }

    private static class FontFamily {
        private SparseArray<Typeface> mTypefaceSparseArray = new SparseArray(4);

        private FontFamily() {
        }

        public Typeface getTypeface(int style2) {
            return (Typeface)this.mTypefaceSparseArray.get(style2);
        }

        public void setTypeface(int style2, Typeface typeface) {
            this.mTypefaceSparseArray.put(style2, (Object)typeface);
        }
    }
}

