/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.platform;

import android.annotation.TargetApi;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.support.v4.util.Pools;
import com.facebook.common.internal.Preconditions;
import com.facebook.common.internal.VisibleForTesting;
import com.facebook.common.references.CloseableReference;
import com.facebook.common.references.ResourceReleaser;
import com.facebook.common.streams.LimitedInputStream;
import com.facebook.common.streams.TailAppendingInputStream;
import com.facebook.imagepipeline.image.EncodedImage;
import com.facebook.imagepipeline.memory.BitmapPool;
import com.facebook.imagepipeline.platform.PlatformDecoder;
import com.facebook.imageutils.BitmapUtil;
import java.io.InputStream;
import java.nio.ByteBuffer;
import javax.annotation.concurrent.ThreadSafe;

@TargetApi(value=21)
@ThreadSafe
public class ArtDecoder
implements PlatformDecoder {
    private static final int DECODE_BUFFER_SIZE = 16384;
    private final BitmapPool mBitmapPool;
    @VisibleForTesting
    final Pools.SynchronizedPool<ByteBuffer> mDecodeBuffers;
    private static final byte[] EOI_TAIL = new byte[]{-1, -39};

    public ArtDecoder(BitmapPool bitmapPool, int maxNumThreads) {
        this.mBitmapPool = bitmapPool;
        this.mDecodeBuffers = new Pools.SynchronizedPool(maxNumThreads);
        for (int i = 0; i < maxNumThreads; ++i) {
            this.mDecodeBuffers.release((Object)ByteBuffer.allocate(16384));
        }
    }

    @Override
    public CloseableReference<Bitmap> decodeFromEncodedImage(EncodedImage encodedImage, Bitmap.Config bitmapConfig) {
        BitmapFactory.Options options = ArtDecoder.getDecodeOptionsForStream(encodedImage, bitmapConfig);
        boolean retryOnFail = options.inPreferredConfig != Bitmap.Config.ARGB_8888;
        try {
            return this.decodeStaticImageFromStream(encodedImage.getInputStream(), options);
        }
        catch (RuntimeException re) {
            if (retryOnFail) {
                return this.decodeFromEncodedImage(encodedImage, Bitmap.Config.ARGB_8888);
            }
            throw re;
        }
    }

    @Override
    public CloseableReference<Bitmap> decodeJPEGFromEncodedImage(EncodedImage encodedImage, Bitmap.Config bitmapConfig, int length) {
        boolean isJpegComplete = encodedImage.isCompleteAt(length);
        BitmapFactory.Options options = ArtDecoder.getDecodeOptionsForStream(encodedImage, bitmapConfig);
        InputStream jpegDataStream = encodedImage.getInputStream();
        Preconditions.checkNotNull((Object)jpegDataStream);
        if (encodedImage.getSize() > length) {
            jpegDataStream = new LimitedInputStream(jpegDataStream, length);
        }
        if (!isJpegComplete) {
            jpegDataStream = new TailAppendingInputStream(jpegDataStream, EOI_TAIL);
        }
        boolean retryOnFail = options.inPreferredConfig != Bitmap.Config.ARGB_8888;
        try {
            return this.decodeStaticImageFromStream(jpegDataStream, options);
        }
        catch (RuntimeException re) {
            if (retryOnFail) {
                return this.decodeFromEncodedImage(encodedImage, Bitmap.Config.ARGB_8888);
            }
            throw re;
        }
    }

    private CloseableReference<Bitmap> decodeStaticImageFromStream(InputStream inputStream, BitmapFactory.Options options) {
        Bitmap decodedBitmap;
        Preconditions.checkNotNull((Object)inputStream);
        int sizeInBytes = BitmapUtil.getSizeInByteForBitmap(options.outWidth, options.outHeight, options.inPreferredConfig);
        Bitmap bitmapToReuse = (Bitmap)this.mBitmapPool.get(sizeInBytes);
        if (bitmapToReuse == null) {
            throw new NullPointerException("BitmapPool.get returned null");
        }
        options.inBitmap = bitmapToReuse;
        ByteBuffer byteBuffer = (ByteBuffer)this.mDecodeBuffers.acquire();
        if (byteBuffer == null) {
            byteBuffer = ByteBuffer.allocate(16384);
        }
        try {
            options.inTempStorage = byteBuffer.array();
            decodedBitmap = BitmapFactory.decodeStream((InputStream)inputStream, null, (BitmapFactory.Options)options);
        }
        catch (RuntimeException re) {
            this.mBitmapPool.release(bitmapToReuse);
            throw re;
        }
        finally {
            this.mDecodeBuffers.release((Object)byteBuffer);
        }
        if (bitmapToReuse != decodedBitmap) {
            this.mBitmapPool.release(bitmapToReuse);
            decodedBitmap.recycle();
            throw new IllegalStateException();
        }
        return CloseableReference.of((Object)decodedBitmap, (ResourceReleaser)this.mBitmapPool);
    }

    private static BitmapFactory.Options getDecodeOptionsForStream(EncodedImage encodedImage, Bitmap.Config bitmapConfig) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inSampleSize = encodedImage.getSampleSize();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeStream((InputStream)encodedImage.getInputStream(), null, (BitmapFactory.Options)options);
        if (options.outWidth == -1 || options.outHeight == -1) {
            throw new IllegalArgumentException();
        }
        options.inJustDecodeBounds = false;
        options.inDither = true;
        options.inPreferredConfig = bitmapConfig;
        options.inMutable = true;
        return options;
    }
}

