/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.codepush.react;

import android.app.Activity;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.AsyncTask;
import android.provider.Settings;
import android.view.Choreographer;
import com.facebook.react.ReactActivity;
import com.facebook.react.ReactPackage;
import com.facebook.react.bridge.JavaScriptModule;
import com.facebook.react.bridge.LifecycleEventListener;
import com.facebook.react.bridge.NativeModule;
import com.facebook.react.bridge.Promise;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReactContextBaseJavaModule;
import com.facebook.react.bridge.ReactMethod;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.bridge.WritableMap;
import com.facebook.react.bridge.WritableNativeMap;
import com.facebook.react.modules.core.DeviceEventManagerModule;
import com.facebook.react.uimanager.ReactChoreographer;
import com.facebook.react.uimanager.ViewManager;
import com.facebook.soloader.SoLoader;
import com.microsoft.codepush.react.CodePushDialog;
import com.microsoft.codepush.react.CodePushInstallMode;
import com.microsoft.codepush.react.CodePushInvalidUpdateException;
import com.microsoft.codepush.react.CodePushMalformedDataException;
import com.microsoft.codepush.react.CodePushNotInitializedException;
import com.microsoft.codepush.react.CodePushPackage;
import com.microsoft.codepush.react.CodePushTelemetryManager;
import com.microsoft.codepush.react.CodePushUnknownException;
import com.microsoft.codepush.react.CodePushUpdateState;
import com.microsoft.codepush.react.CodePushUpdateUtils;
import com.microsoft.codepush.react.CodePushUtils;
import com.microsoft.codepush.react.DownloadProgress;
import com.microsoft.codepush.react.DownloadProgressCallback;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class CodePush
implements ReactPackage {
    private static boolean needToReportRollback = false;
    private static boolean isRunningBinaryVersion = false;
    private static boolean testConfigurationFlag = false;
    private boolean didUpdate = false;
    private String assetsBundleFileName;
    private static final String ASSETS_BUNDLE_PREFIX = "assets://";
    private static final String BINARY_MODIFIED_TIME_KEY = "binaryModifiedTime";
    private final String CODE_PUSH_PREFERENCES = "CodePush";
    private static final String DEFAULT_JS_BUNDLE_NAME = "index.android.bundle";
    private final String DOWNLOAD_PROGRESS_EVENT_NAME = "CodePushDownloadProgress";
    private final String FAILED_UPDATES_KEY = "CODE_PUSH_FAILED_UPDATES";
    private final String PACKAGE_HASH_KEY = "packageHash";
    private final String PENDING_UPDATE_HASH_KEY = "hash";
    private final String PENDING_UPDATE_IS_LOADING_KEY = "isLoading";
    private final String PENDING_UPDATE_KEY = "CODE_PUSH_PENDING_UPDATE";
    private final String RESOURCES_BUNDLE = "resources.arsc";
    private CodePushNativeModule codePushNativeModule;
    private CodePushPackage codePushPackage;
    private CodePushTelemetryManager codePushTelemetryManager;
    private String appVersion;
    private int buildVersion;
    private String deploymentKey;
    private String serverUrl = "https://codepush.azurewebsites.net/";
    private Activity mainActivity;
    private Context applicationContext;
    private final boolean isDebugMode;
    private static CodePush currentInstance;

    public CodePush(String deploymentKey, Activity mainActivity) {
        this(deploymentKey, mainActivity, false);
    }

    public CodePush(String deploymentKey, Activity mainActivity, boolean isDebugMode) {
        SoLoader.init((Context)mainActivity, (boolean)false);
        this.applicationContext = mainActivity.getApplicationContext();
        this.codePushPackage = new CodePushPackage(mainActivity.getFilesDir().getAbsolutePath());
        this.codePushTelemetryManager = new CodePushTelemetryManager(this.applicationContext, "CodePush");
        this.deploymentKey = deploymentKey;
        this.isDebugMode = isDebugMode;
        this.mainActivity = mainActivity;
        try {
            PackageInfo pInfo = this.applicationContext.getPackageManager().getPackageInfo(this.applicationContext.getPackageName(), 0);
            this.appVersion = pInfo.versionName;
            this.buildVersion = pInfo.versionCode;
        }
        catch (PackageManager.NameNotFoundException e) {
            throw new CodePushUnknownException("Unable to get package info for " + this.applicationContext.getPackageName(), e);
        }
        currentInstance = this;
        this.clearDebugCacheIfNeeded();
        this.initializeUpdateAfterRestart();
    }

    public CodePush(String deploymentKey, Activity mainActivity, boolean isDebugMode, String serverUrl) {
        this(deploymentKey, mainActivity, isDebugMode);
        this.serverUrl = serverUrl;
    }

    private void clearDebugCacheIfNeeded() {
        File cachedDevBundle;
        if (this.isDebugMode && this.isPendingUpdate(null) && (cachedDevBundle = new File(this.applicationContext.getFilesDir(), "ReactNativeDevBundle.js")).exists()) {
            cachedDevBundle.delete();
        }
    }

    private long getBinaryResourcesModifiedTime() {
        ZipFile applicationFile = null;
        try {
            ApplicationInfo ai = this.applicationContext.getPackageManager().getApplicationInfo(this.applicationContext.getPackageName(), 0);
            applicationFile = new ZipFile(ai.sourceDir);
            ZipEntry classesDexEntry = applicationFile.getEntry("resources.arsc");
            long l = classesDexEntry.getTime();
            return l;
        }
        catch (PackageManager.NameNotFoundException | IOException e) {
            throw new CodePushUnknownException("Error in getting file information about compiled resources", e);
        }
        finally {
            if (applicationFile != null) {
                try {
                    applicationFile.close();
                }
                catch (IOException e) {
                    throw new CodePushUnknownException("Error in closing application file.", e);
                }
            }
        }
    }

    public static String getBundleUrl() {
        return CodePush.getBundleUrl(DEFAULT_JS_BUNDLE_NAME);
    }

    public static String getBundleUrl(String assetsBundleFileName) {
        if (currentInstance == null) {
            throw new CodePushNotInitializedException("A CodePush instance has not been created yet. Have you added it to your app's list of ReactPackages?");
        }
        return currentInstance.getBundleUrlInternal(assetsBundleFileName);
    }

    public String getBundleUrlInternal(String assetsBundleFileName) {
        this.assetsBundleFileName = assetsBundleFileName;
        String binaryJsBundleUrl = ASSETS_BUNDLE_PREFIX + assetsBundleFileName;
        long binaryResourcesModifiedTime = this.getBinaryResourcesModifiedTime();
        try {
            String packageFilePath = this.codePushPackage.getCurrentPackageBundlePath(this.assetsBundleFileName);
            if (packageFilePath == null) {
                CodePushUtils.logBundleUrl(binaryJsBundleUrl);
                isRunningBinaryVersion = true;
                return binaryJsBundleUrl;
            }
            WritableMap packageMetadata = this.codePushPackage.getCurrentPackage();
            Long binaryModifiedDateDuringPackageInstall = null;
            String binaryModifiedDateDuringPackageInstallString = CodePushUtils.tryGetString((ReadableMap)packageMetadata, BINARY_MODIFIED_TIME_KEY);
            if (binaryModifiedDateDuringPackageInstallString != null) {
                binaryModifiedDateDuringPackageInstall = Long.parseLong(binaryModifiedDateDuringPackageInstallString);
            }
            String packageAppVersion = CodePushUtils.tryGetString((ReadableMap)packageMetadata, "appVersion");
            if (binaryModifiedDateDuringPackageInstall != null && binaryModifiedDateDuringPackageInstall == binaryResourcesModifiedTime && (CodePush.isUsingTestConfiguration() || this.appVersion.equals(packageAppVersion))) {
                CodePushUtils.logBundleUrl(packageFilePath);
                isRunningBinaryVersion = false;
                return packageFilePath;
            }
            this.didUpdate = false;
            if (!this.isDebugMode || !this.appVersion.equals(packageAppVersion)) {
                this.clearUpdates();
            }
            CodePushUtils.logBundleUrl(binaryJsBundleUrl);
            isRunningBinaryVersion = true;
            return binaryJsBundleUrl;
        }
        catch (NumberFormatException e) {
            throw new CodePushUnknownException("Error in reading binary modified date from package metadata", e);
        }
    }

    private JSONArray getFailedUpdates() {
        SharedPreferences settings = this.applicationContext.getSharedPreferences("CodePush", 0);
        String failedUpdatesString = settings.getString("CODE_PUSH_FAILED_UPDATES", null);
        if (failedUpdatesString == null) {
            return new JSONArray();
        }
        try {
            return new JSONArray(failedUpdatesString);
        }
        catch (JSONException e) {
            JSONArray emptyArray = new JSONArray();
            settings.edit().putString("CODE_PUSH_FAILED_UPDATES", emptyArray.toString()).commit();
            return emptyArray;
        }
    }

    private JSONObject getPendingUpdate() {
        SharedPreferences settings = this.applicationContext.getSharedPreferences("CodePush", 0);
        String pendingUpdateString = settings.getString("CODE_PUSH_PENDING_UPDATE", null);
        if (pendingUpdateString == null) {
            return null;
        }
        try {
            return new JSONObject(pendingUpdateString);
        }
        catch (JSONException e) {
            CodePushUtils.log("Unable to parse pending update metadata " + pendingUpdateString + " stored in SharedPreferences");
            return null;
        }
    }

    private void initializeUpdateAfterRestart() {
        this.didUpdate = false;
        JSONObject pendingUpdate = this.getPendingUpdate();
        if (pendingUpdate != null) {
            try {
                boolean updateIsLoading = pendingUpdate.getBoolean("isLoading");
                if (updateIsLoading) {
                    CodePushUtils.log("Update did not finish loading the last time, rolling back to a previous version.");
                    needToReportRollback = true;
                    this.rollbackPackage();
                } else {
                    this.didUpdate = true;
                    this.savePendingUpdate(pendingUpdate.getString("hash"), true);
                }
            }
            catch (JSONException e) {
                throw new CodePushUnknownException("Unable to read pending update metadata stored in SharedPreferences", e);
            }
        }
    }

    private boolean isFailedHash(String packageHash) {
        JSONArray failedUpdates = this.getFailedUpdates();
        if (packageHash != null) {
            for (int i = 0; i < failedUpdates.length(); ++i) {
                try {
                    JSONObject failedPackage = failedUpdates.getJSONObject(i);
                    String failedPackageHash = failedPackage.getString("packageHash");
                    if (!packageHash.equals(failedPackageHash)) continue;
                    return true;
                }
                catch (JSONException e) {
                    throw new CodePushUnknownException("Unable to read failedUpdates data stored in SharedPreferences.", e);
                }
            }
        }
        return false;
    }

    private boolean isPendingUpdate(String packageHash) {
        JSONObject pendingUpdate = this.getPendingUpdate();
        try {
            return pendingUpdate != null && !pendingUpdate.getBoolean("isLoading") && (packageHash == null || pendingUpdate.getString("hash").equals(packageHash));
        }
        catch (JSONException e) {
            throw new CodePushUnknownException("Unable to read pending update metadata in isPendingUpdate.", e);
        }
    }

    private void removeFailedUpdates() {
        SharedPreferences settings = this.applicationContext.getSharedPreferences("CodePush", 0);
        settings.edit().remove("CODE_PUSH_FAILED_UPDATES").commit();
    }

    private void removePendingUpdate() {
        SharedPreferences settings = this.applicationContext.getSharedPreferences("CodePush", 0);
        settings.edit().remove("CODE_PUSH_PENDING_UPDATE").commit();
    }

    private void rollbackPackage() {
        WritableMap failedPackage = this.codePushPackage.getCurrentPackage();
        this.saveFailedUpdate((ReadableMap)failedPackage);
        this.codePushPackage.rollbackPackage();
        this.removePendingUpdate();
    }

    private void saveFailedUpdate(ReadableMap failedPackage) {
        JSONArray failedUpdates;
        SharedPreferences settings = this.applicationContext.getSharedPreferences("CodePush", 0);
        String failedUpdatesString = settings.getString("CODE_PUSH_FAILED_UPDATES", null);
        if (failedUpdatesString == null) {
            failedUpdates = new JSONArray();
        } else {
            try {
                failedUpdates = new JSONArray(failedUpdatesString);
            }
            catch (JSONException e) {
                throw new CodePushMalformedDataException("Unable to parse failed updates information " + failedUpdatesString + " stored in SharedPreferences", e);
            }
        }
        JSONObject failedPackageJSON = CodePushUtils.convertReadableToJsonObject(failedPackage);
        failedUpdates.put((Object)failedPackageJSON);
        settings.edit().putString("CODE_PUSH_FAILED_UPDATES", failedUpdates.toString()).commit();
    }

    private void savePendingUpdate(String packageHash, boolean isLoading) {
        SharedPreferences settings = this.applicationContext.getSharedPreferences("CodePush", 0);
        JSONObject pendingUpdate = new JSONObject();
        try {
            pendingUpdate.put("hash", (Object)packageHash);
            pendingUpdate.put("isLoading", isLoading);
            settings.edit().putString("CODE_PUSH_PENDING_UPDATE", pendingUpdate.toString()).commit();
        }
        catch (JSONException e) {
            throw new CodePushUnknownException("Unable to save pending update.", e);
        }
    }

    public static boolean isUsingTestConfiguration() {
        return testConfigurationFlag;
    }

    public static void setUsingTestConfiguration(boolean shouldUseTestConfiguration) {
        testConfigurationFlag = shouldUseTestConfiguration;
    }

    public void clearUpdates() {
        this.codePushPackage.clearUpdates();
        this.removePendingUpdate();
        this.removeFailedUpdates();
    }

    public List<NativeModule> createNativeModules(ReactApplicationContext reactApplicationContext) {
        ArrayList<NativeModule> nativeModules = new ArrayList<NativeModule>();
        this.codePushNativeModule = new CodePushNativeModule(reactApplicationContext);
        CodePushDialog dialogModule = new CodePushDialog(reactApplicationContext, this.mainActivity);
        nativeModules.add((NativeModule)this.codePushNativeModule);
        nativeModules.add((NativeModule)dialogModule);
        return nativeModules;
    }

    public List<Class<? extends JavaScriptModule>> createJSModules() {
        return new ArrayList<Class<? extends JavaScriptModule>>();
    }

    public List<ViewManager> createViewManagers(ReactApplicationContext reactApplicationContext) {
        return new ArrayList<ViewManager>();
    }

    private class CodePushNativeModule
    extends ReactContextBaseJavaModule {
        private LifecycleEventListener lifecycleEventListener;
        private int minimumBackgroundDuration;

        public CodePushNativeModule(ReactApplicationContext reactContext) {
            super(reactContext);
            this.lifecycleEventListener = null;
            this.minimumBackgroundDuration = 0;
        }

        public Map<String, Object> getConstants() {
            HashMap<String, Object> constants = new HashMap<String, Object>();
            constants.put("codePushInstallModeImmediate", CodePushInstallMode.IMMEDIATE.getValue());
            constants.put("codePushInstallModeOnNextRestart", CodePushInstallMode.ON_NEXT_RESTART.getValue());
            constants.put("codePushInstallModeOnNextResume", CodePushInstallMode.ON_NEXT_RESUME.getValue());
            constants.put("codePushUpdateStateRunning", CodePushUpdateState.RUNNING.getValue());
            constants.put("codePushUpdateStatePending", CodePushUpdateState.PENDING.getValue());
            constants.put("codePushUpdateStateLatest", CodePushUpdateState.LATEST.getValue());
            return constants;
        }

        public String getName() {
            return "CodePush";
        }

        private void loadBundleLegacy() {
            Intent intent = CodePush.this.mainActivity.getIntent();
            CodePush.this.mainActivity.finish();
            CodePush.this.mainActivity.startActivity(intent);
            currentInstance = null;
        }

        private void loadBundle() {
            CodePush.this.clearDebugCacheIfNeeded();
            if (!ReactActivity.class.isInstance(CodePush.this.mainActivity)) {
                this.loadBundleLegacy();
                return;
            }
            try {
                Field instanceManagerField = ReactActivity.class.getDeclaredField("mReactInstanceManager");
                instanceManagerField.setAccessible(true);
                final Object instanceManager = instanceManagerField.get(CodePush.this.mainActivity);
                String latestJSBundleFile = CodePush.this.getBundleUrlInternal(CodePush.this.assetsBundleFileName);
                Field jsBundleField = instanceManager.getClass().getDeclaredField("mJSBundleFile");
                jsBundleField.setAccessible(true);
                jsBundleField.set(instanceManager, latestJSBundleFile);
                final Method recreateMethod = instanceManager.getClass().getMethod("recreateReactContextInBackground", new Class[0]);
                CodePush.this.mainActivity.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            recreateMethod.invoke(instanceManager, new Object[0]);
                            CodePush.this.initializeUpdateAfterRestart();
                        }
                        catch (Exception e) {
                            CodePushNativeModule.this.loadBundleLegacy();
                        }
                    }
                });
            }
            catch (Exception e) {
                this.loadBundleLegacy();
            }
        }

        @ReactMethod
        public void downloadUpdate(final ReadableMap updatePackage, final boolean notifyProgress, final Promise promise) {
            AsyncTask<Void, Void, Void> asyncTask = new AsyncTask<Void, Void, Void>(){

                protected Void doInBackground(Void ... params) {
                    try {
                        WritableMap mutableUpdatePackage = CodePushUtils.convertReadableMapToWritableMap(updatePackage);
                        mutableUpdatePackage.putString(CodePush.BINARY_MODIFIED_TIME_KEY, "" + CodePush.this.getBinaryResourcesModifiedTime());
                        CodePush.this.codePushPackage.downloadPackage((ReadableMap)mutableUpdatePackage, CodePush.this.assetsBundleFileName, new DownloadProgressCallback(){
                            private boolean hasScheduledNextFrame = false;
                            private DownloadProgress latestDownloadProgress = null;

                            @Override
                            public void call(DownloadProgress downloadProgress) {
                                if (!notifyProgress) {
                                    return;
                                }
                                this.latestDownloadProgress = downloadProgress;
                                if (this.latestDownloadProgress.isCompleted()) {
                                    this.dispatchDownloadProgressEvent();
                                    return;
                                }
                                if (this.hasScheduledNextFrame) {
                                    return;
                                }
                                this.hasScheduledNextFrame = true;
                                CodePushNativeModule.this.getReactApplicationContext().runOnUiQueueThread(new Runnable(){

                                    @Override
                                    public void run() {
                                        ReactChoreographer.getInstance().postFrameCallback(ReactChoreographer.CallbackType.TIMERS_EVENTS, new Choreographer.FrameCallback(){

                                            public void doFrame(long frameTimeNanos) {
                                                if (!latestDownloadProgress.isCompleted()) {
                                                    this.dispatchDownloadProgressEvent();
                                                }
                                                hasScheduledNextFrame = false;
                                            }
                                        });
                                    }
                                });
                            }

                            public void dispatchDownloadProgressEvent() {
                                ((DeviceEventManagerModule.RCTDeviceEventEmitter)CodePushNativeModule.this.getReactApplicationContext().getJSModule(DeviceEventManagerModule.RCTDeviceEventEmitter.class)).emit("CodePushDownloadProgress", (Object)this.latestDownloadProgress.createWritableMap());
                            }
                        });
                        WritableMap newPackage = CodePush.this.codePushPackage.getPackage(CodePushUtils.tryGetString(updatePackage, "packageHash"));
                        promise.resolve((Object)newPackage);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        promise.reject((Throwable)e);
                    }
                    catch (CodePushInvalidUpdateException e) {
                        e.printStackTrace();
                        CodePush.this.saveFailedUpdate(updatePackage);
                        promise.reject((Throwable)e);
                    }
                    catch (CodePushMalformedDataException e) {
                        e.printStackTrace();
                        CodePush.this.saveFailedUpdate(updatePackage);
                        promise.reject((Throwable)e);
                    }
                    return null;
                }
            };
            asyncTask.execute((Object[])new Void[0]);
        }

        @ReactMethod
        public void getConfiguration(Promise promise) {
            WritableNativeMap configMap = new WritableNativeMap();
            configMap.putString("appVersion", CodePush.this.appVersion);
            configMap.putInt("buildVersion", CodePush.this.buildVersion);
            configMap.putString("deploymentKey", CodePush.this.deploymentKey);
            configMap.putString("serverUrl", CodePush.this.serverUrl);
            configMap.putString("clientUniqueId", Settings.Secure.getString((ContentResolver)CodePush.this.mainActivity.getContentResolver(), (String)"android_id"));
            String binaryHash = CodePushUpdateUtils.getHashForBinaryContents(CodePush.this.mainActivity, CodePush.this.isDebugMode);
            if (binaryHash != null) {
                configMap.putString("packageHash", binaryHash);
            }
            promise.resolve((Object)configMap);
        }

        @ReactMethod
        public void getUpdateMetadata(final int updateState, final Promise promise) {
            AsyncTask<Void, Void, Void> asyncTask = new AsyncTask<Void, Void, Void>(){

                protected Void doInBackground(Void ... params) {
                    WritableMap currentPackage = CodePush.this.codePushPackage.getCurrentPackage();
                    if (currentPackage == null) {
                        promise.resolve((Object)"");
                        return null;
                    }
                    Boolean currentUpdateIsPending = false;
                    if (currentPackage.hasKey("packageHash")) {
                        String currentHash = currentPackage.getString("packageHash");
                        currentUpdateIsPending = CodePush.this.isPendingUpdate(currentHash);
                    }
                    if (updateState == CodePushUpdateState.PENDING.getValue() && !currentUpdateIsPending.booleanValue()) {
                        promise.resolve((Object)"");
                    } else if (updateState == CodePushUpdateState.RUNNING.getValue() && currentUpdateIsPending.booleanValue()) {
                        promise.resolve((Object)CodePush.this.codePushPackage.getPreviousPackage());
                    } else {
                        if (isRunningBinaryVersion) {
                            currentPackage.putBoolean("_isDebugOnly", true);
                        }
                        currentPackage.putBoolean("isPending", currentUpdateIsPending.booleanValue());
                        promise.resolve((Object)currentPackage);
                    }
                    return null;
                }
            };
            asyncTask.execute((Object[])new Void[0]);
        }

        @ReactMethod
        public void getNewStatusReport(final Promise promise) {
            AsyncTask<Void, Void, Void> asyncTask = new AsyncTask<Void, Void, Void>(){

                protected Void doInBackground(Void ... params) {
                    if (needToReportRollback) {
                        needToReportRollback = false;
                        JSONArray failedUpdates = CodePush.this.getFailedUpdates();
                        if (failedUpdates != null && failedUpdates.length() > 0) {
                            try {
                                JSONObject lastFailedPackageJSON = failedUpdates.getJSONObject(failedUpdates.length() - 1);
                                WritableMap lastFailedPackage = CodePushUtils.convertJsonObjectToWritable(lastFailedPackageJSON);
                                WritableMap failedStatusReport = CodePush.this.codePushTelemetryManager.getRollbackReport(lastFailedPackage);
                                if (failedStatusReport != null) {
                                    promise.resolve((Object)failedStatusReport);
                                    return null;
                                }
                            }
                            catch (JSONException e) {
                                throw new CodePushUnknownException("Unable to read failed updates information stored in SharedPreferences.", e);
                            }
                        }
                    } else if (CodePush.this.didUpdate) {
                        WritableMap newPackageStatusReport;
                        WritableMap currentPackage = CodePush.this.codePushPackage.getCurrentPackage();
                        if (currentPackage != null && (newPackageStatusReport = CodePush.this.codePushTelemetryManager.getUpdateReport(currentPackage)) != null) {
                            promise.resolve((Object)newPackageStatusReport);
                            return null;
                        }
                    } else if (isRunningBinaryVersion) {
                        WritableMap newAppVersionStatusReport = CodePush.this.codePushTelemetryManager.getBinaryUpdateReport(CodePush.this.appVersion);
                        if (newAppVersionStatusReport != null) {
                            promise.resolve((Object)newAppVersionStatusReport);
                            return null;
                        }
                    } else {
                        WritableMap retryStatusReport = CodePush.this.codePushTelemetryManager.getRetryStatusReport();
                        if (retryStatusReport != null) {
                            promise.resolve((Object)retryStatusReport);
                            return null;
                        }
                    }
                    promise.resolve((Object)"");
                    return null;
                }
            };
            asyncTask.execute((Object[])new Void[0]);
        }

        @ReactMethod
        public void installUpdate(final ReadableMap updatePackage, final int installMode, final int minimumBackgroundDuration, final Promise promise) {
            AsyncTask<Void, Void, Void> asyncTask = new AsyncTask<Void, Void, Void>(){

                protected Void doInBackground(Void ... params) {
                    CodePush.this.codePushPackage.installPackage(updatePackage, CodePush.this.isPendingUpdate(null));
                    String pendingHash = CodePushUtils.tryGetString(updatePackage, "packageHash");
                    if (pendingHash == null) {
                        throw new CodePushUnknownException("Update package to be installed has no hash.");
                    }
                    CodePush.this.savePendingUpdate(pendingHash, false);
                    if (installMode == CodePushInstallMode.ON_NEXT_RESUME.getValue()) {
                        CodePushNativeModule.this.minimumBackgroundDuration = minimumBackgroundDuration;
                        if (CodePushNativeModule.this.lifecycleEventListener == null) {
                            CodePushNativeModule.this.lifecycleEventListener = new LifecycleEventListener(){
                                private Date lastPausedDate = null;

                                public void onHostResume() {
                                    long durationInBackground = 0L;
                                    if (this.lastPausedDate != null) {
                                        durationInBackground = (new Date().getTime() - this.lastPausedDate.getTime()) / 1000L;
                                    }
                                    if (durationInBackground >= (long)CodePushNativeModule.this.minimumBackgroundDuration) {
                                        CodePushNativeModule.this.loadBundle();
                                    }
                                }

                                public void onHostPause() {
                                    this.lastPausedDate = new Date();
                                }

                                public void onHostDestroy() {
                                }
                            };
                            CodePushNativeModule.this.getReactApplicationContext().addLifecycleEventListener(CodePushNativeModule.this.lifecycleEventListener);
                        }
                    }
                    promise.resolve((Object)"");
                    return null;
                }
            };
            asyncTask.execute((Object[])new Void[0]);
        }

        @ReactMethod
        public void isFailedUpdate(String packageHash, Promise promise) {
            promise.resolve((Object)CodePush.this.isFailedHash(packageHash));
        }

        @ReactMethod
        public void isFirstRun(String packageHash, Promise promise) {
            boolean isFirstRun = CodePush.this.didUpdate && packageHash != null && packageHash.length() > 0 && packageHash.equals(CodePush.this.codePushPackage.getCurrentPackageHash());
            promise.resolve((Object)isFirstRun);
        }

        @ReactMethod
        public void notifyApplicationReady(Promise promise) {
            CodePush.this.removePendingUpdate();
            promise.resolve((Object)"");
        }

        @ReactMethod
        public void recordStatusReported(ReadableMap statusReport) {
            CodePush.this.codePushTelemetryManager.recordStatusReported(statusReport);
        }

        @ReactMethod
        public void restartApp(boolean onlyIfUpdateIsPending) {
            if (!onlyIfUpdateIsPending || CodePush.this.isPendingUpdate(null)) {
                this.loadBundle();
            }
        }

        @ReactMethod
        public void saveStatusReportForRetry(ReadableMap statusReport) {
            CodePush.this.codePushTelemetryManager.saveStatusReportForRetry(statusReport);
        }

        @ReactMethod
        public void downloadAndReplaceCurrentBundle(String remoteBundleUrl) {
            if (CodePush.isUsingTestConfiguration()) {
                try {
                    CodePush.this.codePushPackage.downloadAndReplaceCurrentBundle(remoteBundleUrl, CodePush.this.assetsBundleFileName);
                }
                catch (IOException e) {
                    throw new CodePushUnknownException("Unable to replace current bundle", e);
                }
            }
        }
    }
}

