/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.codepush.react;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import com.facebook.react.bridge.Callback;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReactContextBaseJavaModule;
import com.facebook.react.bridge.ReactMethod;
import com.microsoft.codepush.react.CodePushUnknownException;

public class CodePushDialog
extends ReactContextBaseJavaModule {
    private Activity mainActivity;

    public CodePushDialog(ReactApplicationContext reactContext, Activity mainActivity) {
        super(reactContext);
        this.mainActivity = mainActivity;
    }

    @ReactMethod
    public void showDialog(String title, String message, String button1Text, String button2Text, final Callback successCallback, Callback errorCallback) {
        AlertDialog.Builder builder = new AlertDialog.Builder((Context)this.mainActivity);
        builder.setCancelable(false);
        DialogInterface.OnClickListener clickListener = new DialogInterface.OnClickListener(){
            private boolean callbackConsumed = false;

            public synchronized void onClick(DialogInterface dialog, int which) {
                if (this.callbackConsumed) {
                    return;
                }
                this.callbackConsumed = true;
                dialog.cancel();
                switch (which) {
                    case -1: {
                        successCallback.invoke(new Object[]{0});
                        break;
                    }
                    case -2: {
                        successCallback.invoke(new Object[]{1});
                        break;
                    }
                    default: {
                        throw new CodePushUnknownException("Unknown button ID pressed.");
                    }
                }
            }
        };
        if (title != null) {
            builder.setTitle((CharSequence)title);
        }
        if (message != null) {
            builder.setMessage((CharSequence)message);
        }
        if (button1Text != null) {
            builder.setPositiveButton((CharSequence)button1Text, clickListener);
        }
        if (button2Text != null) {
            builder.setNegativeButton((CharSequence)button2Text, clickListener);
        }
        AlertDialog dialog = builder.create();
        dialog.show();
    }

    public String getName() {
        return "CodePushDialog";
    }
}

