/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.codepush.react;

import android.util.Log;
import com.facebook.react.bridge.Arguments;
import com.facebook.react.bridge.NoSuchKeyException;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.bridge.ReadableMapKeySetIterator;
import com.facebook.react.bridge.ReadableType;
import com.facebook.react.bridge.WritableArray;
import com.facebook.react.bridge.WritableMap;
import com.microsoft.codepush.react.CodePushMalformedDataException;
import com.microsoft.codepush.react.CodePushUnknownException;
import com.microsoft.codepush.react.FileUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Iterator;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class CodePushUtils {
    public static final String REACT_NATIVE_LOG_TAG = "ReactNative";

    public static String appendPathComponent(String basePath, String appendPathComponent) {
        return new File(basePath, appendPathComponent).getAbsolutePath();
    }

    public static WritableArray convertJsonArrayToWritable(JSONArray jsonArr) {
        WritableArray arr = Arguments.createArray();
        for (int i = 0; i < jsonArr.length(); ++i) {
            Object obj = null;
            try {
                obj = jsonArr.get(i);
            }
            catch (JSONException jsonException) {
                throw new CodePushUnknownException(i + " should be within bounds of array " + jsonArr.toString(), jsonException);
            }
            if (obj instanceof JSONObject) {
                arr.pushMap(CodePushUtils.convertJsonObjectToWritable((JSONObject)obj));
                continue;
            }
            if (obj instanceof JSONArray) {
                arr.pushArray(CodePushUtils.convertJsonArrayToWritable((JSONArray)obj));
                continue;
            }
            if (obj instanceof String) {
                arr.pushString((String)obj);
                continue;
            }
            if (obj instanceof Double) {
                arr.pushDouble(((Double)obj).doubleValue());
                continue;
            }
            if (obj instanceof Integer) {
                arr.pushInt(((Integer)obj).intValue());
                continue;
            }
            if (obj instanceof Boolean) {
                arr.pushBoolean(((Boolean)obj).booleanValue());
                continue;
            }
            if (obj == null) {
                arr.pushNull();
                continue;
            }
            throw new CodePushUnknownException("Unrecognized object: " + obj);
        }
        return arr;
    }

    public static WritableMap convertJsonObjectToWritable(JSONObject jsonObj) {
        WritableMap map = Arguments.createMap();
        Iterator it = jsonObj.keys();
        while (it.hasNext()) {
            String key = (String)it.next();
            Object obj = null;
            try {
                obj = jsonObj.get(key);
            }
            catch (JSONException jsonException) {
                throw new CodePushUnknownException("Key " + key + " should exist in " + jsonObj.toString() + ".", jsonException);
            }
            if (obj instanceof JSONObject) {
                map.putMap(key, CodePushUtils.convertJsonObjectToWritable((JSONObject)obj));
                continue;
            }
            if (obj instanceof JSONArray) {
                map.putArray(key, CodePushUtils.convertJsonArrayToWritable((JSONArray)obj));
                continue;
            }
            if (obj instanceof String) {
                map.putString(key, (String)obj);
                continue;
            }
            if (obj instanceof Double) {
                map.putDouble(key, ((Double)obj).doubleValue());
                continue;
            }
            if (obj instanceof Integer) {
                map.putInt(key, ((Integer)obj).intValue());
                continue;
            }
            if (obj instanceof Boolean) {
                map.putBoolean(key, ((Boolean)obj).booleanValue());
                continue;
            }
            if (obj == null) {
                map.putNull(key);
                continue;
            }
            throw new CodePushUnknownException("Unrecognized object: " + obj);
        }
        return map;
    }

    public static WritableMap convertReadableMapToWritableMap(ReadableMap map) {
        JSONObject mapJSON = CodePushUtils.convertReadableToJsonObject(map);
        return CodePushUtils.convertJsonObjectToWritable(mapJSON);
    }

    public static JSONArray convertReadableToJsonArray(ReadableArray arr) {
        JSONArray jsonArr = new JSONArray();
        block10: for (int i = 0; i < arr.size(); ++i) {
            ReadableType type = arr.getType(i);
            switch (type) {
                case Map: {
                    jsonArr.put((Object)CodePushUtils.convertReadableToJsonObject(arr.getMap(i)));
                    continue block10;
                }
                case Array: {
                    jsonArr.put((Object)CodePushUtils.convertReadableToJsonArray(arr.getArray(i)));
                    continue block10;
                }
                case String: {
                    jsonArr.put((Object)arr.getString(i));
                    continue block10;
                }
                case Number: {
                    Double number = arr.getDouble(i);
                    if (number == Math.floor(number) && !Double.isInfinite(number)) {
                        jsonArr.put(number.longValue());
                        continue block10;
                    }
                    try {
                        jsonArr.put(number.doubleValue());
                        continue block10;
                    }
                    catch (JSONException jsonException) {
                        throw new CodePushUnknownException("Unable to put value " + arr.getDouble(i) + " in JSONArray");
                    }
                }
                case Boolean: {
                    jsonArr.put(arr.getBoolean(i));
                    continue block10;
                }
                case Null: {
                    jsonArr.put(null);
                }
            }
        }
        return jsonArr;
    }

    public static JSONObject convertReadableToJsonObject(ReadableMap map) {
        JSONObject jsonObj = new JSONObject();
        ReadableMapKeySetIterator it = map.keySetIterator();
        while (it.hasNextKey()) {
            String key = it.nextKey();
            ReadableType type = map.getType(key);
            try {
                switch (type) {
                    case Map: {
                        jsonObj.put(key, (Object)CodePushUtils.convertReadableToJsonObject(map.getMap(key)));
                        break;
                    }
                    case Array: {
                        jsonObj.put(key, (Object)CodePushUtils.convertReadableToJsonArray(map.getArray(key)));
                        break;
                    }
                    case String: {
                        jsonObj.put(key, (Object)map.getString(key));
                        break;
                    }
                    case Number: {
                        jsonObj.put(key, map.getDouble(key));
                        break;
                    }
                    case Boolean: {
                        jsonObj.put(key, map.getBoolean(key));
                        break;
                    }
                    case Null: {
                        jsonObj.put(key, null);
                        break;
                    }
                    default: {
                        throw new CodePushUnknownException("Unrecognized type: " + type + " of key: " + key);
                    }
                }
            }
            catch (JSONException jsonException) {
                throw new CodePushUnknownException("Error setting key: " + key + " in JSONObject", jsonException);
            }
        }
        return jsonObj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getStringFromInputStream(InputStream inputStream) throws IOException {
        BufferedReader bufferedReader = null;
        try {
            String line;
            StringBuilder buffer = new StringBuilder();
            bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            while ((line = bufferedReader.readLine()) != null) {
                buffer.append(line);
                buffer.append("\n");
            }
            String string = buffer.toString().trim();
            return string;
        }
        finally {
            if (bufferedReader != null) {
                bufferedReader.close();
            }
            if (inputStream != null) {
                inputStream.close();
            }
        }
    }

    public static WritableMap getWritableMapFromFile(String filePath) throws IOException {
        String content = FileUtils.readFileToString(filePath);
        try {
            JSONObject json = new JSONObject(content);
            return CodePushUtils.convertJsonObjectToWritable(json);
        }
        catch (JSONException jsonException) {
            throw new CodePushMalformedDataException(filePath, jsonException);
        }
    }

    public static void log(String message) {
        Log.d((String)REACT_NATIVE_LOG_TAG, (String)("[CodePush] " + message));
    }

    public static void logBundleUrl(String path) {
        CodePushUtils.log("Loading JS bundle from \"" + path + "\"");
    }

    public static String tryGetString(ReadableMap map, String key) {
        try {
            return map.getString(key);
        }
        catch (NoSuchKeyException e) {
            return null;
        }
    }

    public static void writeReadableMapToFile(ReadableMap map, String filePath) throws IOException {
        JSONObject json = CodePushUtils.convertReadableToJsonObject(map);
        String jsonString = json.toString();
        FileUtils.writeStringToFile(jsonString, filePath);
    }
}

