/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.codepush.react;

import com.microsoft.codepush.react.CodePushUnknownException;
import com.microsoft.codepush.react.CodePushUtils;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class FileUtils {
    private static final int WRITE_BUFFER_SIZE = 8192;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyDirectoryContents(String sourceDirectoryPath, String destinationDirectoryPath) throws IOException {
        File sourceDir = new File(sourceDirectoryPath);
        File destDir = new File(destinationDirectoryPath);
        if (!destDir.exists()) {
            destDir.mkdir();
        }
        for (File sourceFile : sourceDir.listFiles()) {
            if (sourceFile.isDirectory()) {
                FileUtils.copyDirectoryContents(CodePushUtils.appendPathComponent(sourceDirectoryPath, sourceFile.getName()), CodePushUtils.appendPathComponent(destinationDirectoryPath, sourceFile.getName()));
                continue;
            }
            File destFile = new File(destDir, sourceFile.getName());
            FileInputStream fromFileStream = null;
            BufferedInputStream fromBufferedStream = null;
            FileOutputStream destStream = null;
            byte[] buffer = new byte[8192];
            try {
                int bytesRead;
                fromFileStream = new FileInputStream(sourceFile);
                fromBufferedStream = new BufferedInputStream(fromFileStream);
                destStream = new FileOutputStream(destFile);
                while ((bytesRead = fromBufferedStream.read(buffer)) > 0) {
                    destStream.write(buffer, 0, bytesRead);
                }
            }
            finally {
                try {
                    if (fromFileStream != null) {
                        fromFileStream.close();
                    }
                    if (fromBufferedStream != null) {
                        fromBufferedStream.close();
                    }
                    if (destStream != null) {
                        destStream.close();
                    }
                }
                catch (IOException e) {
                    throw new CodePushUnknownException("Error closing IO resources.", e);
                }
            }
        }
    }

    public static void deleteDirectory(File directory) {
        File[] files;
        if (directory.exists() && (files = directory.listFiles()) != null) {
            for (File file : files) {
                if (file.isDirectory()) {
                    FileUtils.deleteDirectory(file);
                    continue;
                }
                file.delete();
            }
        }
        directory.delete();
    }

    public static void deleteDirectoryAtPath(String directoryPath) {
        FileUtils.deleteDirectory(new File(directoryPath));
    }

    public static void deleteFileAtPathSilently(String path) {
        FileUtils.deleteFileOrFolderSilently(new File(path));
    }

    public static void deleteFileOrFolderSilently(File file) {
        if (file.isDirectory()) {
            File[] files;
            for (File fileEntry : files = file.listFiles()) {
                if (fileEntry.isDirectory()) {
                    FileUtils.deleteFileOrFolderSilently(fileEntry);
                    continue;
                }
                if (file.delete()) continue;
                fileEntry.delete();
            }
        }
        if (!file.delete()) {
            CodePushUtils.log("Error deleting file " + file.getName());
        }
    }

    public static boolean fileAtPathExists(String filePath) {
        return new File(filePath).exists();
    }

    public static void moveFile(File fileToMove, String newFolderPath, String newFileName) {
        File newFilePath;
        File newFolder = new File(newFolderPath);
        if (!newFolder.exists()) {
            newFolder.mkdirs();
        }
        if (!fileToMove.renameTo(newFilePath = new File(newFolderPath, newFileName))) {
            throw new CodePushUnknownException("Unable to move file from " + fileToMove.getAbsolutePath() + " to " + newFilePath.getAbsolutePath() + ".");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFileToString(String filePath) throws IOException {
        FileInputStream fin = null;
        BufferedReader reader = null;
        try {
            File fl = new File(filePath);
            fin = new FileInputStream(fl);
            reader = new BufferedReader(new InputStreamReader(fin));
            StringBuilder sb = new StringBuilder();
            String line = null;
            while ((line = reader.readLine()) != null) {
                sb.append(line).append("\n");
            }
            String string = sb.toString();
            return string;
        }
        finally {
            if (reader != null) {
                reader.close();
            }
            if (fin != null) {
                fin.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unzipFile(File zipFile, String destination) throws IOException {
        FileInputStream fileStream = null;
        BufferedInputStream bufferedStream = null;
        ZipInputStream zipStream = null;
        try {
            ZipEntry entry;
            fileStream = new FileInputStream(zipFile);
            bufferedStream = new BufferedInputStream(fileStream);
            zipStream = new ZipInputStream(bufferedStream);
            File destinationFolder = new File(destination);
            if (destinationFolder.exists()) {
                FileUtils.deleteDirectory(destinationFolder);
            }
            destinationFolder.mkdirs();
            byte[] buffer = new byte[8192];
            while ((entry = zipStream.getNextEntry()) != null) {
                long time;
                String fileName = entry.getName();
                File file = new File(destinationFolder, fileName);
                if (entry.isDirectory()) {
                    file.mkdirs();
                } else {
                    File parent = file.getParentFile();
                    if (!parent.exists()) {
                        parent.mkdirs();
                    }
                    try (FileOutputStream fout = new FileOutputStream(file);){
                        int numBytesRead;
                        while ((numBytesRead = zipStream.read(buffer)) != -1) {
                            fout.write(buffer, 0, numBytesRead);
                        }
                    }
                }
                if ((time = entry.getTime()) <= 0L) continue;
                file.setLastModified(time);
            }
        }
        finally {
            try {
                if (zipStream != null) {
                    zipStream.close();
                }
                if (bufferedStream != null) {
                    bufferedStream.close();
                }
                if (fileStream != null) {
                    fileStream.close();
                }
            }
            catch (IOException e) {
                throw new CodePushUnknownException("Error closing IO resources.", e);
            }
        }
    }

    public static void writeStringToFile(String content, String filePath) throws IOException {
        try (PrintWriter out = null;){
            out = new PrintWriter(filePath);
            out.print(content);
        }
    }
}

