/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.devsupport;

import android.app.Dialog;
import android.content.Context;
import android.net.Uri;
import android.os.AsyncTask;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.BaseAdapter;
import android.widget.Button;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.TextView;
import com.facebook.common.logging.FLog;
import com.facebook.react.R;
import com.facebook.react.common.MapBuilder;
import com.facebook.react.devsupport.DevSupportManager;
import com.facebook.react.devsupport.StackTraceHelper;
import com.squareup.okhttp.MediaType;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.RequestBody;
import org.json.JSONObject;

class RedBoxDialog
extends Dialog
implements AdapterView.OnItemClickListener {
    private final DevSupportManager mDevSupportManager;
    private ListView mStackView;
    private Button mReloadJs;
    private int mCookie = 0;

    protected RedBoxDialog(Context context, DevSupportManager devSupportManager) {
        super(context, R.style.Theme_Catalyst_RedBox);
        this.requestWindowFeature(1);
        this.setContentView(R.layout.redbox_view);
        this.mDevSupportManager = devSupportManager;
        this.mStackView = (ListView)this.findViewById(R.id.rn_redbox_stack);
        this.mStackView.setOnItemClickListener((AdapterView.OnItemClickListener)this);
        this.mReloadJs = (Button)this.findViewById(R.id.rn_redbox_reloadjs);
        this.mReloadJs.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                RedBoxDialog.this.mDevSupportManager.handleReloadJS();
            }
        });
    }

    public void setExceptionDetails(String title, StackTraceHelper.StackFrame[] stack) {
        this.mStackView.setAdapter((ListAdapter)new StackAdapter(title, stack));
    }

    public void setErrorCookie(int cookie) {
        this.mCookie = cookie;
    }

    public int getErrorCookie() {
        return this.mCookie;
    }

    public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
        new OpenStackFrameTask(this.mDevSupportManager).executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new StackTraceHelper.StackFrame[]{(StackTraceHelper.StackFrame)this.mStackView.getAdapter().getItem(position)});
    }

    public boolean onKeyUp(int keyCode, KeyEvent event) {
        if (keyCode == 82) {
            this.mDevSupportManager.showDevOptionsDialog();
            return true;
        }
        return super.onKeyUp(keyCode, event);
    }

    private static class OpenStackFrameTask
    extends AsyncTask<StackTraceHelper.StackFrame, Void, Void> {
        private static final MediaType JSON = MediaType.parse((String)"application/json; charset=utf-8");
        private final DevSupportManager mDevSupportManager;

        private OpenStackFrameTask(DevSupportManager devSupportManager) {
            this.mDevSupportManager = devSupportManager;
        }

        protected Void doInBackground(StackTraceHelper.StackFrame ... stackFrames) {
            try {
                String openStackFrameUrl = Uri.parse((String)this.mDevSupportManager.getSourceUrl()).buildUpon().path("/open-stack-frame").query(null).build().toString();
                OkHttpClient client = new OkHttpClient();
                for (StackTraceHelper.StackFrame frame : stackFrames) {
                    String payload = OpenStackFrameTask.stackFrameToJson(frame).toString();
                    RequestBody body = RequestBody.create((MediaType)JSON, (String)payload);
                    Request request = new Request.Builder().url(openStackFrameUrl).post(body).build();
                    client.newCall(request).execute();
                }
            }
            catch (Exception e) {
                FLog.e((String)"React", (String)"Could not open stack frame", (Throwable)e);
            }
            return null;
        }

        private static JSONObject stackFrameToJson(StackTraceHelper.StackFrame frame) {
            return new JSONObject(MapBuilder.of("file", frame.getFile(), "methodName", frame.getMethod(), "lineNumber", frame.getLine(), "column", frame.getColumn()));
        }
    }

    private static class StackAdapter
    extends BaseAdapter {
        private static final int VIEW_TYPE_COUNT = 2;
        private static final int VIEW_TYPE_TITLE = 0;
        private static final int VIEW_TYPE_STACKFRAME = 1;
        private final String mTitle;
        private final StackTraceHelper.StackFrame[] mStack;

        public StackAdapter(String title, StackTraceHelper.StackFrame[] stack) {
            this.mTitle = title;
            this.mStack = stack;
        }

        public boolean areAllItemsEnabled() {
            return false;
        }

        public boolean isEnabled(int position) {
            return position > 0;
        }

        public int getCount() {
            return this.mStack.length + 1;
        }

        public Object getItem(int position) {
            return position == 0 ? this.mTitle : this.mStack[position - 1];
        }

        public long getItemId(int position) {
            return position;
        }

        public int getViewTypeCount() {
            return 2;
        }

        public int getItemViewType(int position) {
            return position == 0 ? 0 : 1;
        }

        public View getView(int position, View convertView, ViewGroup parent) {
            if (position == 0) {
                TextView title = convertView != null ? (TextView)convertView : (TextView)LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.redbox_item_title, parent, false);
                title.setText((CharSequence)this.mTitle);
                return title;
            }
            if (convertView == null) {
                convertView = LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.redbox_item_frame, parent, false);
                convertView.setTag((Object)new FrameViewHolder(convertView));
            }
            StackTraceHelper.StackFrame frame = this.mStack[position - 1];
            FrameViewHolder holder = (FrameViewHolder)convertView.getTag();
            holder.mMethodView.setText((CharSequence)frame.getMethod());
            holder.mFileView.setText((CharSequence)(frame.getFileName() + ":" + frame.getLine()));
            return convertView;
        }

        private static class FrameViewHolder {
            private final TextView mMethodView;
            private final TextView mFileView;

            private FrameViewHolder(View v) {
                this.mMethodView = (TextView)v.findViewById(R.id.rn_frame_method);
                this.mFileView = (TextView)v.findViewById(R.id.rn_frame_file);
            }
        }
    }
}

