/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.modules.location;

import android.location.Location;
import android.location.LocationListener;
import android.location.LocationManager;
import android.os.Bundle;
import android.os.Handler;
import com.facebook.react.bridge.Arguments;
import com.facebook.react.bridge.Callback;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReactContextBaseJavaModule;
import com.facebook.react.bridge.ReactMethod;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.bridge.WritableMap;
import com.facebook.react.common.SystemClock;
import com.facebook.react.modules.core.DeviceEventManagerModule;
import javax.annotation.Nullable;

public class LocationModule
extends ReactContextBaseJavaModule {
    @Nullable
    private String mWatchedProvider;
    private final LocationListener mLocationListener = new LocationListener(){

        public void onLocationChanged(Location location) {
            LocationModule.this.getReactApplicationContext().getJSModule(DeviceEventManagerModule.RCTDeviceEventEmitter.class).emit("geolocationDidChange", LocationModule.locationToMap(location));
        }

        public void onStatusChanged(String provider, int status, Bundle extras) {
            if (status == 0) {
                LocationModule.this.emitError("Provider " + provider + " is out of service.");
            } else if (status == 1) {
                LocationModule.this.emitError("Provider " + provider + " is temporarily unavailable.");
            }
        }

        public void onProviderEnabled(String provider) {
        }

        public void onProviderDisabled(String provider) {
        }
    };

    public LocationModule(ReactApplicationContext reactContext) {
        super(reactContext);
    }

    @Override
    public String getName() {
        return "LocationObserver";
    }

    @ReactMethod
    public void getCurrentPosition(ReadableMap options, Callback success, Callback error) {
        LocationOptions locationOptions = LocationOptions.fromReactMap(options);
        try {
            LocationManager locationManager = (LocationManager)this.getReactApplicationContext().getSystemService("location");
            String provider = LocationModule.getValidProvider(locationManager, locationOptions.highAccuracy);
            if (provider == null) {
                error.invoke("No available location provider.");
                return;
            }
            Location location = locationManager.getLastKnownLocation(provider);
            if (location != null && (double)(SystemClock.currentTimeMillis() - location.getTime()) < locationOptions.maximumAge) {
                success.invoke(LocationModule.locationToMap(location));
                return;
            }
            new SingleUpdateRequest(locationManager, provider, locationOptions.timeout, success, error).invoke();
        }
        catch (SecurityException e) {
            LocationModule.throwLocationPermissionMissing(e);
        }
    }

    @ReactMethod
    public void startObserving(ReadableMap options) {
        if ("gps".equals(this.mWatchedProvider)) {
            return;
        }
        LocationOptions locationOptions = LocationOptions.fromReactMap(options);
        try {
            LocationManager locationManager = (LocationManager)this.getReactApplicationContext().getSystemService("location");
            String provider = LocationModule.getValidProvider(locationManager, locationOptions.highAccuracy);
            if (provider == null) {
                this.emitError("No location provider available.");
                return;
            }
            if (!provider.equals(this.mWatchedProvider)) {
                locationManager.removeUpdates(this.mLocationListener);
                locationManager.requestLocationUpdates(provider, 1000L, 0.0f, this.mLocationListener);
            }
            this.mWatchedProvider = provider;
        }
        catch (SecurityException e) {
            LocationModule.throwLocationPermissionMissing(e);
        }
    }

    @ReactMethod
    public void stopObserving() {
        LocationManager locationManager = (LocationManager)this.getReactApplicationContext().getSystemService("location");
        locationManager.removeUpdates(this.mLocationListener);
        this.mWatchedProvider = null;
    }

    @Nullable
    private static String getValidProvider(LocationManager locationManager, boolean highAccuracy) {
        String provider;
        String string2 = provider = highAccuracy ? "gps" : "network";
        if (!locationManager.isProviderEnabled(provider)) {
            String string3 = provider = provider.equals("gps") ? "network" : "gps";
            if (!locationManager.isProviderEnabled(provider)) {
                return null;
            }
        }
        return provider;
    }

    private static WritableMap locationToMap(Location location) {
        WritableMap map = Arguments.createMap();
        WritableMap coords = Arguments.createMap();
        coords.putDouble("latitude", location.getLatitude());
        coords.putDouble("longitude", location.getLongitude());
        coords.putDouble("altitude", location.getAltitude());
        coords.putDouble("accuracy", location.getAccuracy());
        coords.putDouble("heading", location.getBearing());
        coords.putDouble("speed", location.getSpeed());
        map.putMap("coords", coords);
        map.putDouble("timestamp", location.getTime());
        return map;
    }

    private void emitError(String error) {
        this.getReactApplicationContext().getJSModule(DeviceEventManagerModule.RCTDeviceEventEmitter.class).emit("geolocationError", error);
    }

    private static void throwLocationPermissionMissing(SecurityException e) {
        throw new SecurityException("Looks like the app doesn't have the permission to access location.\nAdd the following line to your app's AndroidManifest.xml:\n<uses-permission android:name=\"android.permission.ACCESS_FINE_LOCATION\" />", e);
    }

    private static class SingleUpdateRequest {
        private final Callback mSuccess;
        private final Callback mError;
        private final LocationManager mLocationManager;
        private final String mProvider;
        private final long mTimeout;
        private final Handler mHandler = new Handler();
        private final Runnable mTimeoutRunnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                SingleUpdateRequest singleUpdateRequest = SingleUpdateRequest.this;
                synchronized (singleUpdateRequest) {
                    if (!SingleUpdateRequest.this.mTriggered) {
                        SingleUpdateRequest.this.mError.invoke("Location request timed out");
                        SingleUpdateRequest.this.mLocationManager.removeUpdates(SingleUpdateRequest.this.mLocationListener);
                        SingleUpdateRequest.this.mTriggered = true;
                    }
                }
            }
        };
        private final LocationListener mLocationListener = new LocationListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onLocationChanged(Location location) {
                SingleUpdateRequest singleUpdateRequest = SingleUpdateRequest.this;
                synchronized (singleUpdateRequest) {
                    if (!SingleUpdateRequest.this.mTriggered) {
                        SingleUpdateRequest.this.mSuccess.invoke(LocationModule.locationToMap(location));
                        SingleUpdateRequest.this.mHandler.removeCallbacks(SingleUpdateRequest.this.mTimeoutRunnable);
                        SingleUpdateRequest.this.mTriggered = true;
                    }
                }
            }

            public void onStatusChanged(String provider, int status, Bundle extras) {
            }

            public void onProviderEnabled(String provider) {
            }

            public void onProviderDisabled(String provider) {
            }
        };
        private boolean mTriggered;

        private SingleUpdateRequest(LocationManager locationManager, String provider, long timeout, Callback success, Callback error) {
            this.mLocationManager = locationManager;
            this.mProvider = provider;
            this.mTimeout = timeout;
            this.mSuccess = success;
            this.mError = error;
        }

        public void invoke() {
            this.mLocationManager.requestSingleUpdate(this.mProvider, this.mLocationListener, null);
            this.mHandler.postDelayed(this.mTimeoutRunnable, SystemClock.currentTimeMillis() + this.mTimeout);
        }
    }

    private static class LocationOptions {
        private final long timeout;
        private final double maximumAge;
        private final boolean highAccuracy;

        private LocationOptions(long timeout, double maximumAge, boolean highAccuracy) {
            this.timeout = timeout;
            this.maximumAge = maximumAge;
            this.highAccuracy = highAccuracy;
        }

        private static LocationOptions fromReactMap(ReadableMap map) {
            long timeout = map.hasKey("timeout") ? (long)map.getDouble("timeout") : Long.MAX_VALUE;
            double maximumAge = map.hasKey("maximumAge") ? map.getDouble("maximumAge") : Double.POSITIVE_INFINITY;
            boolean highAccuracy = map.hasKey("enableHighAccuracy") && map.getBoolean("enableHighAccuracy");
            return new LocationOptions(timeout, maximumAge, highAccuracy);
        }
    }
}

