/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.art;

import android.view.View;
import com.facebook.react.uimanager.ReactShadowNode;
import com.facebook.react.uimanager.ThemedReactContext;
import com.facebook.react.uimanager.ViewManager;
import com.facebook.react.views.art.ARTGroupShadowNode;
import com.facebook.react.views.art.ARTShapeShadowNode;
import com.facebook.react.views.art.ARTTextShadowNode;

public class ARTRenderableViewManager
extends ViewManager<View, ReactShadowNode> {
    static final String CLASS_GROUP = "ARTGroup";
    static final String CLASS_SHAPE = "ARTShape";
    static final String CLASS_TEXT = "ARTText";
    private final String mClassName;

    public static ARTRenderableViewManager createARTGroupViewManager() {
        return new ARTRenderableViewManager(CLASS_GROUP);
    }

    public static ARTRenderableViewManager createARTShapeViewManager() {
        return new ARTRenderableViewManager(CLASS_SHAPE);
    }

    public static ARTRenderableViewManager createARTTextViewManager() {
        return new ARTRenderableViewManager(CLASS_TEXT);
    }

    private ARTRenderableViewManager(String className) {
        this.mClassName = className;
    }

    @Override
    public String getName() {
        return this.mClassName;
    }

    @Override
    public ReactShadowNode createShadowNodeInstance() {
        if (this.mClassName == CLASS_GROUP) {
            return new ARTGroupShadowNode();
        }
        if (this.mClassName == CLASS_SHAPE) {
            return new ARTShapeShadowNode();
        }
        if (this.mClassName == CLASS_TEXT) {
            return new ARTTextShadowNode();
        }
        throw new IllegalStateException("Unexpected type " + this.mClassName);
    }

    @Override
    public Class<? extends ReactShadowNode> getShadowNodeClass() {
        if (this.mClassName == CLASS_GROUP) {
            return ARTGroupShadowNode.class;
        }
        if (this.mClassName == CLASS_SHAPE) {
            return ARTShapeShadowNode.class;
        }
        if (this.mClassName == CLASS_TEXT) {
            return ARTTextShadowNode.class;
        }
        throw new IllegalStateException("Unexpected type " + this.mClassName);
    }

    @Override
    protected View createViewInstance(ThemedReactContext reactContext) {
        throw new IllegalStateException("ARTShape does not map into a native view");
    }

    @Override
    public void updateExtraData(View root, Object extraData) {
        throw new IllegalStateException("ARTShape does not map into a native view");
    }
}

