/*
 * Decompiled with CFR 0.152.
 */
package android.support.v7.internal.widget;

import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.ColorFilter;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.LayerDrawable;
import android.os.Build;
import android.support.v4.content.ContextCompat;
import android.support.v4.graphics.ColorUtils;
import android.support.v4.graphics.drawable.DrawableCompat;
import android.support.v4.util.LruCache;
import android.support.v7.appcompat.R;
import android.support.v7.internal.widget.ThemeUtils;
import android.support.v7.internal.widget.TintInfo;
import android.util.SparseArray;
import android.view.View;
import java.lang.ref.WeakReference;
import java.util.WeakHashMap;

public final class TintManager {
    public static final boolean SHOULD_BE_USED = Build.VERSION.SDK_INT < 21;
    private static final String TAG = "TintManager";
    private static final boolean DEBUG = false;
    private static final PorterDuff.Mode DEFAULT_MODE = PorterDuff.Mode.SRC_IN;
    private static final WeakHashMap<Context, TintManager> INSTANCE_CACHE = new WeakHashMap();
    private static final ColorFilterLruCache COLOR_FILTER_CACHE = new ColorFilterLruCache(6);
    private static final int[] COLORFILTER_TINT_COLOR_CONTROL_NORMAL = new int[]{R.drawable.abc_textfield_search_default_mtrl_alpha, R.drawable.abc_textfield_default_mtrl_alpha, R.drawable.abc_ab_share_pack_mtrl_alpha};
    private static final int[] TINT_COLOR_CONTROL_NORMAL = new int[]{R.drawable.abc_ic_ab_back_mtrl_am_alpha, R.drawable.abc_ic_go_search_api_mtrl_alpha, R.drawable.abc_ic_search_api_mtrl_alpha, R.drawable.abc_ic_commit_search_api_mtrl_alpha, R.drawable.abc_ic_clear_mtrl_alpha, R.drawable.abc_ic_menu_share_mtrl_alpha, R.drawable.abc_ic_menu_copy_mtrl_am_alpha, R.drawable.abc_ic_menu_cut_mtrl_alpha, R.drawable.abc_ic_menu_selectall_mtrl_alpha, R.drawable.abc_ic_menu_paste_mtrl_am_alpha, R.drawable.abc_ic_menu_moreoverflow_mtrl_alpha, R.drawable.abc_ic_voice_search_api_mtrl_alpha};
    private static final int[] COLORFILTER_COLOR_CONTROL_ACTIVATED = new int[]{R.drawable.abc_textfield_activated_mtrl_alpha, R.drawable.abc_textfield_search_activated_mtrl_alpha, R.drawable.abc_cab_background_top_mtrl_alpha, R.drawable.abc_text_cursor_material};
    private static final int[] COLORFILTER_COLOR_BACKGROUND_MULTIPLY = new int[]{R.drawable.abc_popup_background_mtrl_mult, R.drawable.abc_cab_background_internal_bg, R.drawable.abc_menu_hardkey_panel_mtrl_mult};
    private static final int[] TINT_COLOR_CONTROL_STATE_LIST = new int[]{R.drawable.abc_edit_text_material, R.drawable.abc_tab_indicator_material, R.drawable.abc_textfield_search_material, R.drawable.abc_spinner_mtrl_am_alpha, R.drawable.abc_spinner_textfield_background_material, R.drawable.abc_ratingbar_full_material, R.drawable.abc_switch_track_mtrl_alpha, R.drawable.abc_switch_thumb_material, R.drawable.abc_btn_default_mtrl_shape, R.drawable.abc_btn_borderless_material};
    private static final int[] TINT_CHECKABLE_BUTTON_LIST = new int[]{R.drawable.abc_btn_check_material, R.drawable.abc_btn_radio_material};
    private final WeakReference<Context> mContextRef;
    private SparseArray<ColorStateList> mTintLists;
    private ColorStateList mDefaultColorStateList;

    public static Drawable getDrawable(Context context, int resId) {
        if (TintManager.isInTintList(resId)) {
            return TintManager.get(context).getDrawable(resId);
        }
        return ContextCompat.getDrawable((Context)context, (int)resId);
    }

    public static TintManager get(Context context) {
        TintManager tm = INSTANCE_CACHE.get(context);
        if (tm == null) {
            tm = new TintManager(context);
            INSTANCE_CACHE.put(context, tm);
        }
        return tm;
    }

    private TintManager(Context context) {
        this.mContextRef = new WeakReference<Context>(context);
    }

    public Drawable getDrawable(int resId) {
        return this.getDrawable(resId, false);
    }

    public Drawable getDrawable(int resId, boolean failIfNotKnown) {
        Context context = (Context)this.mContextRef.get();
        if (context == null) {
            return null;
        }
        Drawable drawable2 = ContextCompat.getDrawable((Context)context, (int)resId);
        if (drawable2 != null) {
            ColorStateList tintList;
            if (Build.VERSION.SDK_INT >= 8) {
                drawable2 = drawable2.mutate();
            }
            if ((tintList = this.getTintList(resId)) != null) {
                drawable2 = DrawableCompat.wrap((Drawable)drawable2);
                DrawableCompat.setTintList((Drawable)drawable2, (ColorStateList)tintList);
                PorterDuff.Mode tintMode = this.getTintMode(resId);
                if (tintMode != null) {
                    DrawableCompat.setTintMode((Drawable)drawable2, (PorterDuff.Mode)tintMode);
                }
            } else {
                if (resId == R.drawable.abc_cab_background_top_material) {
                    return new LayerDrawable(new Drawable[]{this.getDrawable(R.drawable.abc_cab_background_internal_bg), this.getDrawable(R.drawable.abc_cab_background_top_mtrl_alpha)});
                }
                boolean usedColorFilter = this.tintDrawableUsingColorFilter(resId, drawable2);
                if (!usedColorFilter && failIfNotKnown) {
                    drawable2 = null;
                }
            }
        }
        return drawable2;
    }

    public final boolean tintDrawableUsingColorFilter(int resId, Drawable drawable2) {
        Context context = (Context)this.mContextRef.get();
        if (context == null) {
            return false;
        }
        PorterDuff.Mode tintMode = DEFAULT_MODE;
        boolean colorAttrSet = false;
        int colorAttr = 0;
        int alpha = -1;
        if (TintManager.arrayContains(COLORFILTER_TINT_COLOR_CONTROL_NORMAL, resId)) {
            colorAttr = R.attr.colorControlNormal;
            colorAttrSet = true;
        } else if (TintManager.arrayContains(COLORFILTER_COLOR_CONTROL_ACTIVATED, resId)) {
            colorAttr = R.attr.colorControlActivated;
            colorAttrSet = true;
        } else if (TintManager.arrayContains(COLORFILTER_COLOR_BACKGROUND_MULTIPLY, resId)) {
            colorAttr = 0x1010031;
            colorAttrSet = true;
            tintMode = PorterDuff.Mode.MULTIPLY;
        } else if (resId == R.drawable.abc_list_divider_mtrl_alpha) {
            colorAttr = 0x1010030;
            colorAttrSet = true;
            alpha = Math.round(40.8f);
        }
        if (colorAttrSet) {
            int color2 = ThemeUtils.getThemeAttrColor(context, colorAttr);
            drawable2.setColorFilter((ColorFilter)TintManager.getPorterDuffColorFilter(color2, tintMode));
            if (alpha != -1) {
                drawable2.setAlpha(alpha);
            }
            return true;
        }
        return false;
    }

    private static boolean arrayContains(int[] array, int value) {
        for (int id2 : array) {
            if (id2 != value) continue;
            return true;
        }
        return false;
    }

    private static boolean isInTintList(int drawableId) {
        return TintManager.arrayContains(TINT_COLOR_CONTROL_NORMAL, drawableId) || TintManager.arrayContains(COLORFILTER_TINT_COLOR_CONTROL_NORMAL, drawableId) || TintManager.arrayContains(COLORFILTER_COLOR_CONTROL_ACTIVATED, drawableId) || TintManager.arrayContains(TINT_COLOR_CONTROL_STATE_LIST, drawableId) || TintManager.arrayContains(COLORFILTER_COLOR_BACKGROUND_MULTIPLY, drawableId) || TintManager.arrayContains(TINT_CHECKABLE_BUTTON_LIST, drawableId) || drawableId == R.drawable.abc_cab_background_top_material;
    }

    final PorterDuff.Mode getTintMode(int resId) {
        PorterDuff.Mode mode = null;
        if (resId == R.drawable.abc_switch_thumb_material) {
            mode = PorterDuff.Mode.MULTIPLY;
        }
        return mode;
    }

    public final ColorStateList getTintList(int resId) {
        ColorStateList tint;
        Context context = (Context)this.mContextRef.get();
        if (context == null) {
            return null;
        }
        ColorStateList colorStateList = tint = this.mTintLists != null ? (ColorStateList)this.mTintLists.get(resId) : null;
        if (tint == null) {
            if (resId == R.drawable.abc_edit_text_material) {
                tint = this.createEditTextColorStateList(context);
            } else if (resId == R.drawable.abc_switch_track_mtrl_alpha) {
                tint = this.createSwitchTrackColorStateList(context);
            } else if (resId == R.drawable.abc_switch_thumb_material) {
                tint = this.createSwitchThumbColorStateList(context);
            } else if (resId == R.drawable.abc_btn_default_mtrl_shape || resId == R.drawable.abc_btn_borderless_material) {
                tint = this.createDefaultButtonColorStateList(context);
            } else if (resId == R.drawable.abc_btn_colored_material) {
                tint = this.createColoredButtonColorStateList(context);
            } else if (resId == R.drawable.abc_spinner_mtrl_am_alpha || resId == R.drawable.abc_spinner_textfield_background_material) {
                tint = this.createSpinnerColorStateList(context);
            } else if (TintManager.arrayContains(TINT_COLOR_CONTROL_NORMAL, resId)) {
                tint = ThemeUtils.getThemeAttrColorStateList(context, R.attr.colorControlNormal);
            } else if (TintManager.arrayContains(TINT_COLOR_CONTROL_STATE_LIST, resId)) {
                tint = this.getDefaultColorStateList(context);
            } else if (TintManager.arrayContains(TINT_CHECKABLE_BUTTON_LIST, resId)) {
                tint = this.createCheckableButtonColorStateList(context);
            }
            if (tint != null) {
                if (this.mTintLists == null) {
                    this.mTintLists = new SparseArray();
                }
                this.mTintLists.append(resId, (Object)tint);
            }
        }
        return tint;
    }

    private ColorStateList getDefaultColorStateList(Context context) {
        if (this.mDefaultColorStateList == null) {
            int colorControlNormal = ThemeUtils.getThemeAttrColor(context, R.attr.colorControlNormal);
            int colorControlActivated = ThemeUtils.getThemeAttrColor(context, R.attr.colorControlActivated);
            int[][] states = new int[7][];
            int[] colors = new int[7];
            int i = 0;
            states[i] = ThemeUtils.DISABLED_STATE_SET;
            colors[i] = ThemeUtils.getDisabledThemeAttrColor(context, R.attr.colorControlNormal);
            states[++i] = ThemeUtils.FOCUSED_STATE_SET;
            colors[i] = colorControlActivated;
            states[++i] = ThemeUtils.ACTIVATED_STATE_SET;
            colors[i] = colorControlActivated;
            states[++i] = ThemeUtils.PRESSED_STATE_SET;
            colors[i] = colorControlActivated;
            states[++i] = ThemeUtils.CHECKED_STATE_SET;
            colors[i] = colorControlActivated;
            states[++i] = ThemeUtils.SELECTED_STATE_SET;
            colors[i] = colorControlActivated;
            states[++i] = ThemeUtils.EMPTY_STATE_SET;
            colors[i] = colorControlNormal;
            ++i;
            this.mDefaultColorStateList = new ColorStateList((int[][])states, colors);
        }
        return this.mDefaultColorStateList;
    }

    private ColorStateList createCheckableButtonColorStateList(Context context) {
        int[][] states = new int[3][];
        int[] colors = new int[3];
        int i = 0;
        states[i] = ThemeUtils.DISABLED_STATE_SET;
        colors[i] = ThemeUtils.getDisabledThemeAttrColor(context, R.attr.colorControlNormal);
        states[++i] = ThemeUtils.CHECKED_STATE_SET;
        colors[i] = ThemeUtils.getThemeAttrColor(context, R.attr.colorControlActivated);
        states[++i] = ThemeUtils.EMPTY_STATE_SET;
        colors[i] = ThemeUtils.getThemeAttrColor(context, R.attr.colorControlNormal);
        ++i;
        return new ColorStateList((int[][])states, colors);
    }

    private ColorStateList createSwitchTrackColorStateList(Context context) {
        int[][] states = new int[3][];
        int[] colors = new int[3];
        int i = 0;
        states[i] = ThemeUtils.DISABLED_STATE_SET;
        colors[i] = ThemeUtils.getThemeAttrColor(context, 0x1010030, 0.1f);
        states[++i] = ThemeUtils.CHECKED_STATE_SET;
        colors[i] = ThemeUtils.getThemeAttrColor(context, R.attr.colorControlActivated, 0.3f);
        states[++i] = ThemeUtils.EMPTY_STATE_SET;
        colors[i] = ThemeUtils.getThemeAttrColor(context, 0x1010030, 0.3f);
        ++i;
        return new ColorStateList((int[][])states, colors);
    }

    private ColorStateList createSwitchThumbColorStateList(Context context) {
        int[][] states = new int[3][];
        int[] colors = new int[3];
        int i = 0;
        ColorStateList thumbColor = ThemeUtils.getThemeAttrColorStateList(context, R.attr.colorSwitchThumbNormal);
        if (thumbColor != null && thumbColor.isStateful()) {
            states[i] = ThemeUtils.DISABLED_STATE_SET;
            colors[i] = thumbColor.getColorForState(states[i], 0);
            states[++i] = ThemeUtils.CHECKED_STATE_SET;
            colors[i] = ThemeUtils.getThemeAttrColor(context, R.attr.colorControlActivated);
            states[++i] = ThemeUtils.EMPTY_STATE_SET;
            colors[i] = thumbColor.getDefaultColor();
            ++i;
        } else {
            states[i] = ThemeUtils.DISABLED_STATE_SET;
            colors[i] = ThemeUtils.getDisabledThemeAttrColor(context, R.attr.colorSwitchThumbNormal);
            states[++i] = ThemeUtils.CHECKED_STATE_SET;
            colors[i] = ThemeUtils.getThemeAttrColor(context, R.attr.colorControlActivated);
            states[++i] = ThemeUtils.EMPTY_STATE_SET;
            colors[i] = ThemeUtils.getThemeAttrColor(context, R.attr.colorSwitchThumbNormal);
            ++i;
        }
        return new ColorStateList((int[][])states, colors);
    }

    private ColorStateList createEditTextColorStateList(Context context) {
        int[][] states = new int[3][];
        int[] colors = new int[3];
        int i = 0;
        states[i] = ThemeUtils.DISABLED_STATE_SET;
        colors[i] = ThemeUtils.getDisabledThemeAttrColor(context, R.attr.colorControlNormal);
        states[++i] = ThemeUtils.NOT_PRESSED_OR_FOCUSED_STATE_SET;
        colors[i] = ThemeUtils.getThemeAttrColor(context, R.attr.colorControlNormal);
        states[++i] = ThemeUtils.EMPTY_STATE_SET;
        colors[i] = ThemeUtils.getThemeAttrColor(context, R.attr.colorControlActivated);
        ++i;
        return new ColorStateList((int[][])states, colors);
    }

    private ColorStateList createDefaultButtonColorStateList(Context context) {
        return this.createButtonColorStateList(context, R.attr.colorButtonNormal);
    }

    private ColorStateList createColoredButtonColorStateList(Context context) {
        return this.createButtonColorStateList(context, R.attr.colorAccent);
    }

    private ColorStateList createButtonColorStateList(Context context, int baseColorAttr) {
        int[][] states = new int[4][];
        int[] colors = new int[4];
        int i = 0;
        int baseColor = ThemeUtils.getThemeAttrColor(context, baseColorAttr);
        int colorControlHighlight = ThemeUtils.getThemeAttrColor(context, R.attr.colorControlHighlight);
        states[i] = ThemeUtils.DISABLED_STATE_SET;
        colors[i] = ThemeUtils.getDisabledThemeAttrColor(context, R.attr.colorButtonNormal);
        states[++i] = ThemeUtils.PRESSED_STATE_SET;
        colors[i] = ColorUtils.compositeColors((int)colorControlHighlight, (int)baseColor);
        states[++i] = ThemeUtils.FOCUSED_STATE_SET;
        colors[i] = ColorUtils.compositeColors((int)colorControlHighlight, (int)baseColor);
        states[++i] = ThemeUtils.EMPTY_STATE_SET;
        colors[i] = baseColor;
        ++i;
        return new ColorStateList((int[][])states, colors);
    }

    private ColorStateList createSpinnerColorStateList(Context context) {
        int[][] states = new int[3][];
        int[] colors = new int[3];
        int i = 0;
        states[i] = ThemeUtils.DISABLED_STATE_SET;
        colors[i] = ThemeUtils.getDisabledThemeAttrColor(context, R.attr.colorControlNormal);
        states[++i] = ThemeUtils.NOT_PRESSED_OR_FOCUSED_STATE_SET;
        colors[i] = ThemeUtils.getThemeAttrColor(context, R.attr.colorControlNormal);
        states[++i] = ThemeUtils.EMPTY_STATE_SET;
        colors[i] = ThemeUtils.getThemeAttrColor(context, R.attr.colorControlActivated);
        ++i;
        return new ColorStateList((int[][])states, colors);
    }

    public static void tintViewBackground(View view, TintInfo tint) {
        Drawable background = view.getBackground();
        if (tint.mHasTintList || tint.mHasTintMode) {
            background.setColorFilter((ColorFilter)TintManager.createTintFilter(tint.mHasTintList ? tint.mTintList : null, tint.mHasTintMode ? tint.mTintMode : DEFAULT_MODE, view.getDrawableState()));
        } else {
            background.clearColorFilter();
        }
        if (Build.VERSION.SDK_INT <= 10) {
            view.invalidate();
        }
    }

    private static PorterDuffColorFilter createTintFilter(ColorStateList tint, PorterDuff.Mode tintMode, int[] state) {
        if (tint == null || tintMode == null) {
            return null;
        }
        int color2 = tint.getColorForState(state, 0);
        return TintManager.getPorterDuffColorFilter(color2, tintMode);
    }

    private static PorterDuffColorFilter getPorterDuffColorFilter(int color2, PorterDuff.Mode mode) {
        PorterDuffColorFilter filter = COLOR_FILTER_CACHE.get(color2, mode);
        if (filter == null) {
            filter = new PorterDuffColorFilter(color2, mode);
            COLOR_FILTER_CACHE.put(color2, mode, filter);
        }
        return filter;
    }

    private static class ColorFilterLruCache
    extends LruCache<Integer, PorterDuffColorFilter> {
        public ColorFilterLruCache(int maxSize) {
            super(maxSize);
        }

        PorterDuffColorFilter get(int color2, PorterDuff.Mode mode) {
            return (PorterDuffColorFilter)this.get(ColorFilterLruCache.generateCacheKey(color2, mode));
        }

        PorterDuffColorFilter put(int color2, PorterDuff.Mode mode, PorterDuffColorFilter filter) {
            return (PorterDuffColorFilter)this.put(ColorFilterLruCache.generateCacheKey(color2, mode), filter);
        }

        private static int generateCacheKey(int color2, PorterDuff.Mode mode) {
            int hashCode = 1;
            hashCode = 31 * hashCode + color2;
            hashCode = 31 * hashCode + mode.hashCode();
            return hashCode;
        }
    }
}

