/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.bridge.queue;

import android.os.Looper;
import com.facebook.common.logging.FLog;
import com.facebook.proguard.annotations.DoNotStrip;
import com.facebook.react.bridge.SoftAssertions;
import com.facebook.react.bridge.UiThreadUtil;
import com.facebook.react.bridge.queue.MessageQueueThread;
import com.facebook.react.bridge.queue.MessageQueueThreadHandler;
import com.facebook.react.bridge.queue.MessageQueueThreadRegistry;
import com.facebook.react.bridge.queue.MessageQueueThreadSpec;
import com.facebook.react.bridge.queue.QueueThreadExceptionHandler;
import com.facebook.react.common.futures.SimpleSettableFuture;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;

@DoNotStrip
public class MessageQueueThreadImpl
implements MessageQueueThread {
    private final String mName;
    private final Looper mLooper;
    private final MessageQueueThreadHandler mHandler;
    private final String mAssertionErrorMessage;
    private volatile boolean mIsFinished = false;

    private MessageQueueThreadImpl(String name, Looper looper, QueueThreadExceptionHandler exceptionHandler) {
        this.mName = name;
        this.mLooper = looper;
        this.mHandler = new MessageQueueThreadHandler(looper, exceptionHandler);
        this.mAssertionErrorMessage = "Expected to be called from the '" + this.getName() + "' thread!";
    }

    @Override
    @DoNotStrip
    public void runOnQueue(Runnable runnable) {
        if (this.mIsFinished) {
            FLog.w((String)"React", (String)("Tried to enqueue runnable on already finished thread: '" + this.getName() + "... dropping Runnable."));
        }
        this.mHandler.post(runnable);
    }

    @Override
    @DoNotStrip
    public <T> Future<T> callOnQueue(final Callable<T> callable) {
        final SimpleSettableFuture future = new SimpleSettableFuture();
        this.runOnQueue(new Runnable(){

            @Override
            public void run() {
                try {
                    future.set(callable.call());
                }
                catch (Exception e) {
                    future.setException(e);
                }
            }
        });
        return future;
    }

    @Override
    public boolean isOnThread() {
        return this.mLooper.getThread() == Thread.currentThread();
    }

    @Override
    public void assertIsOnThread() {
        SoftAssertions.assertCondition(this.isOnThread(), this.mAssertionErrorMessage);
    }

    @Override
    public void quitSynchronous() {
        this.mIsFinished = true;
        this.mLooper.quit();
        if (this.mLooper.getThread() != Thread.currentThread()) {
            try {
                this.mLooper.getThread().join();
            }
            catch (InterruptedException e) {
                throw new RuntimeException("Got interrupted waiting to join thread " + this.mName);
            }
        }
    }

    public Looper getLooper() {
        return this.mLooper;
    }

    public String getName() {
        return this.mName;
    }

    public static MessageQueueThreadImpl create(MessageQueueThreadSpec spec, QueueThreadExceptionHandler exceptionHandler) {
        switch (spec.getThreadType()) {
            case MAIN_UI: {
                return MessageQueueThreadImpl.createForMainThread(spec.getName(), exceptionHandler);
            }
            case NEW_BACKGROUND: {
                return MessageQueueThreadImpl.startNewBackgroundThread(spec.getName(), exceptionHandler);
            }
        }
        throw new RuntimeException("Unknown thread type: " + (Object)((Object)spec.getThreadType()));
    }

    private static MessageQueueThreadImpl createForMainThread(String name, QueueThreadExceptionHandler exceptionHandler) {
        Looper mainLooper = Looper.getMainLooper();
        final MessageQueueThreadImpl mqt = new MessageQueueThreadImpl(name, mainLooper, exceptionHandler);
        if (UiThreadUtil.isOnUiThread()) {
            MessageQueueThreadRegistry.register(mqt);
        } else {
            final SimpleSettableFuture registrationFuture = new SimpleSettableFuture();
            UiThreadUtil.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    MessageQueueThreadRegistry.register(mqt);
                    registrationFuture.set(null);
                }
            });
            registrationFuture.getOrThrow();
        }
        return mqt;
    }

    public static MessageQueueThreadImpl startNewBackgroundThread(String name, QueueThreadExceptionHandler exceptionHandler) {
        final SimpleSettableFuture looperFuture = new SimpleSettableFuture();
        final SimpleSettableFuture<MessageQueueThreadImpl> mqtFuture = new SimpleSettableFuture<MessageQueueThreadImpl>();
        Thread bgThread = new Thread(new Runnable(){

            @Override
            public void run() {
                Looper.prepare();
                looperFuture.set(Looper.myLooper());
                MessageQueueThreadRegistry.register((MessageQueueThread)mqtFuture.getOrThrow());
                Looper.loop();
            }
        }, "mqt_" + name);
        bgThread.start();
        Looper myLooper = (Looper)looperFuture.getOrThrow();
        MessageQueueThreadImpl mqt = new MessageQueueThreadImpl(name, myLooper, exceptionHandler);
        mqtFuture.set(mqt);
        return mqt;
    }
}

