/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.uimanager.events;

import android.support.v4.util.Pools;
import android.view.MotionEvent;
import com.facebook.infer.annotation.Assertions;
import com.facebook.react.uimanager.events.Event;
import com.facebook.react.uimanager.events.RCTEventEmitter;
import com.facebook.react.uimanager.events.TouchEventCoalescingKeyHelper;
import com.facebook.react.uimanager.events.TouchEventType;
import com.facebook.react.uimanager.events.TouchesHelper;
import javax.annotation.Nullable;

public class TouchEvent
extends Event<TouchEvent> {
    private static final int TOUCH_EVENTS_POOL_SIZE = 3;
    private static final Pools.SynchronizedPool<TouchEvent> EVENTS_POOL = new Pools.SynchronizedPool(3);
    @Nullable
    private MotionEvent mMotionEvent;
    @Nullable
    private TouchEventType mTouchEventType;
    private short mCoalescingKey;
    private float mViewX;
    private float mViewY;

    public static TouchEvent obtain(int viewTag, long timestampMs, TouchEventType touchEventType, MotionEvent motionEventToCopy, float viewX, float viewY) {
        TouchEvent event = (TouchEvent)EVENTS_POOL.acquire();
        if (event == null) {
            event = new TouchEvent();
        }
        event.init(viewTag, timestampMs, touchEventType, motionEventToCopy, viewX, viewY);
        return event;
    }

    private TouchEvent() {
    }

    private void init(int viewTag, long timestampMs, TouchEventType touchEventType, MotionEvent motionEventToCopy, float viewX, float viewY) {
        super.init(viewTag, timestampMs);
        short coalescingKey = 0;
        int action = motionEventToCopy.getAction() & 0xFF;
        switch (action) {
            case 0: {
                TouchEventCoalescingKeyHelper.addCoalescingKey(motionEventToCopy.getDownTime());
                break;
            }
            case 1: {
                TouchEventCoalescingKeyHelper.removeCoalescingKey(motionEventToCopy.getDownTime());
                break;
            }
            case 5: 
            case 6: {
                TouchEventCoalescingKeyHelper.incrementCoalescingKey(motionEventToCopy.getDownTime());
                break;
            }
            case 2: {
                coalescingKey = TouchEventCoalescingKeyHelper.getCoalescingKey(motionEventToCopy.getDownTime());
                break;
            }
            case 3: {
                TouchEventCoalescingKeyHelper.removeCoalescingKey(motionEventToCopy.getDownTime());
                break;
            }
            default: {
                throw new RuntimeException("Unhandled MotionEvent action: " + action);
            }
        }
        this.mTouchEventType = touchEventType;
        this.mMotionEvent = MotionEvent.obtain((MotionEvent)motionEventToCopy);
        this.mCoalescingKey = coalescingKey;
        this.mViewX = viewX;
        this.mViewY = viewY;
    }

    @Override
    public void onDispose() {
        ((MotionEvent)Assertions.assertNotNull((Object)this.mMotionEvent)).recycle();
        this.mMotionEvent = null;
        EVENTS_POOL.release((Object)this);
    }

    @Override
    public String getEventName() {
        return ((TouchEventType)((Object)Assertions.assertNotNull((Object)((Object)this.mTouchEventType)))).getJSEventName();
    }

    @Override
    public boolean canCoalesce() {
        switch ((TouchEventType)((Object)Assertions.assertNotNull((Object)((Object)this.mTouchEventType)))) {
            case START: 
            case END: 
            case CANCEL: {
                return false;
            }
            case MOVE: {
                return true;
            }
        }
        throw new RuntimeException("Unknown touch event type: " + (Object)((Object)this.mTouchEventType));
    }

    @Override
    public short getCoalescingKey() {
        return this.mCoalescingKey;
    }

    @Override
    public void dispatch(RCTEventEmitter rctEventEmitter) {
        TouchesHelper.sendTouchEvent(rctEventEmitter, (TouchEventType)((Object)Assertions.assertNotNull((Object)((Object)this.mTouchEventType))), this.getViewTag(), this);
    }

    public MotionEvent getMotionEvent() {
        Assertions.assertNotNull((Object)this.mMotionEvent);
        return this.mMotionEvent;
    }

    public float getViewX() {
        return this.mViewX;
    }

    public float getViewY() {
        return this.mViewY;
    }
}

