/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.text;

import android.content.Context;
import android.net.Uri;
import com.facebook.drawee.controller.AbstractDraweeControllerBuilder;
import com.facebook.react.uimanager.LayoutShadowNode;
import com.facebook.react.uimanager.annotations.ReactProp;
import java.util.Locale;
import javax.annotation.Nullable;

public class ReactTextInlineImageShadowNode
extends LayoutShadowNode {
    @Nullable
    private Uri mUri;
    private final AbstractDraweeControllerBuilder mDraweeControllerBuilder;
    @Nullable
    private final Object mCallerContext;

    public ReactTextInlineImageShadowNode(AbstractDraweeControllerBuilder draweeControllerBuilder, @Nullable Object callerContext) {
        this.mDraweeControllerBuilder = draweeControllerBuilder;
        this.mCallerContext = callerContext;
    }

    @ReactProp(name="src")
    public void setSource(@Nullable String source) {
        Uri uri = null;
        if (source != null) {
            try {
                uri = Uri.parse((String)source);
                if (uri.getScheme() == null) {
                    uri = null;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (uri == null) {
                uri = ReactTextInlineImageShadowNode.getResourceDrawableUri((Context)this.getThemedContext(), source);
            }
        }
        if (uri != this.mUri) {
            this.markUpdated();
        }
        this.mUri = uri;
    }

    @Nullable
    public Uri getUri() {
        return this.mUri;
    }

    @Nullable
    private static Uri getResourceDrawableUri(Context context, @Nullable String name) {
        if (name == null || name.isEmpty()) {
            return null;
        }
        name = name.toLowerCase(Locale.getDefault()).replace("-", "_");
        int resId = context.getResources().getIdentifier(name, "drawable", context.getPackageName());
        return new Uri.Builder().scheme("res").path(String.valueOf(resId)).build();
    }

    @Override
    public boolean isVirtual() {
        return true;
    }

    public AbstractDraweeControllerBuilder getDraweeControllerBuilder() {
        return this.mDraweeControllerBuilder;
    }

    @Nullable
    public Object getCallerContext() {
        return this.mCallerContext;
    }
}

