/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.soloader;

import android.content.Context;
import android.os.Build;
import android.system.ErrnoException;
import android.system.Os;
import com.facebook.soloader.FileLocker;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;

final class SysUtil {
    private static byte[] cachedBuffer = null;

    SysUtil() {
    }

    public static void reliablyCopyExecutable(InputStream is, File destination, long expectedSize, long time) throws IOException {
        destination.delete();
        try (FileOutputStream os = new FileOutputStream(destination);){
            int nrBytes;
            byte[] buffer;
            if (cachedBuffer == null) {
                cachedBuffer = buffer = new byte[16384];
            } else {
                buffer = cachedBuffer;
            }
            if (expectedSize > 0L) {
                SysUtil.fallocateIfSupported(os.getFD(), expectedSize);
            }
            while ((nrBytes = is.read(buffer, 0, buffer.length)) >= 0) {
                os.write(buffer, 0, nrBytes);
            }
            os.getFD().sync();
            destination.setExecutable(true);
            destination.setLastModified(time);
            os.getFD().sync();
        }
    }

    public static void freeCopyBuffer() {
        cachedBuffer = null;
    }

    public static int findAbiScore(String[] supportedAbis, String abi) {
        for (int i = 0; i < supportedAbis.length; ++i) {
            if (supportedAbis[i] == null || !abi.equals(supportedAbis[i])) continue;
            return i;
        }
        return -1;
    }

    public static void deleteOrThrow(File file) throws IOException {
        if (!file.delete()) {
            throw new IOException("could not delete file " + file);
        }
    }

    public static String[] getSupportedAbis() {
        if (Build.VERSION.SDK_INT < 21) {
            return new String[]{Build.CPU_ABI, Build.CPU_ABI2};
        }
        return LollipopSysdeps.getSupportedAbis();
    }

    public static void fallocateIfSupported(FileDescriptor fd, long length) throws IOException {
        if (Build.VERSION.SDK_INT >= 21) {
            LollipopSysdeps.fallocate(fd, length);
        }
    }

    public static FileLocker lockLibsDirectory(Context context) throws IOException {
        File lockFile = new File(context.getApplicationInfo().dataDir, "libs-dir-lock");
        return FileLocker.lock(lockFile);
    }

    static File getLibsDirectory(Context context) {
        return new File(context.getApplicationInfo().dataDir, "app_libs");
    }

    static File createLibsDirectory(Context context) {
        File libsDirectory = SysUtil.getLibsDirectory(context);
        if (!libsDirectory.isDirectory() && !libsDirectory.mkdirs()) {
            throw new RuntimeException("could not create libs directory");
        }
        return libsDirectory;
    }

    static void dumbDeleteRecrusive(File file) throws IOException {
        if (file.isDirectory()) {
            for (File entry : file.listFiles()) {
                SysUtil.dumbDeleteRecrusive(entry);
            }
        }
        if (!file.delete() && file.exists()) {
            throw new IOException("could not delete: " + file);
        }
    }

    private static final class LollipopSysdeps {
        private LollipopSysdeps() {
        }

        public static String[] getSupportedAbis() {
            return Build.SUPPORTED_32_BIT_ABIS;
        }

        public static void fallocate(FileDescriptor fd, long length) throws IOException {
            try {
                Os.posix_fallocate((FileDescriptor)fd, (long)0L, (long)length);
            }
            catch (ErrnoException ex) {
                throw new IOException(ex.toString(), ex);
            }
        }
    }
}

