/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.drawee.drawable;

import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Matrix;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import com.facebook.common.internal.Preconditions;
import com.facebook.drawee.drawable.DrawableProperties;
import com.facebook.drawee.drawable.DrawableUtils;
import com.facebook.drawee.drawable.TransformAwareDrawable;
import com.facebook.drawee.drawable.TransformCallback;
import javax.annotation.Nullable;

public class ArrayDrawable
extends Drawable
implements Drawable.Callback,
TransformCallback,
TransformAwareDrawable {
    private TransformCallback mTransformCallback;
    private final DrawableProperties mDrawableProperties = new DrawableProperties();
    private final Drawable[] mLayers;
    private final Rect mTmpRect = new Rect();
    private boolean mIsStateful = false;
    private boolean mIsStatefulCalculated = false;
    private boolean mIsMutated = false;
    private final Rect mBounds = new Rect();
    private int mLevel;
    private int[] mState;
    private boolean mIsVisible;

    public ArrayDrawable(Drawable[] layers) {
        Preconditions.checkNotNull((Object)layers);
        this.mLayers = layers;
        for (int i = 0; i < this.mLayers.length; ++i) {
            DrawableUtils.setCallbacks(this.mLayers[i], this, this);
        }
    }

    public int getNumberOfLayers() {
        return this.mLayers.length;
    }

    @Nullable
    public Drawable getDrawable(int index) {
        return this.mLayers[index];
    }

    public void setDrawable(int index, @Nullable Drawable drawable) {
        Preconditions.checkArgument((index >= 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((index < this.mLayers.length ? 1 : 0) != 0);
        if (drawable != this.mLayers[index]) {
            if (drawable != null && this.mIsMutated) {
                drawable = drawable.mutate();
            }
            DrawableUtils.setCallbacks(this.mLayers[index], null, null);
            DrawableUtils.setCallbacks(drawable, null, null);
            DrawableUtils.setDrawableProperties(drawable, this.mDrawableProperties);
            if (drawable != null) {
                drawable.setBounds(this.mBounds);
                drawable.setLevel(this.mLevel);
                drawable.setState(this.mState);
                drawable.setVisible(this.mIsVisible, false);
            }
            DrawableUtils.setCallbacks(drawable, this, this);
            this.mIsStatefulCalculated = false;
            this.mLayers[index] = drawable;
            this.invalidateSelf();
        }
    }

    public int getIntrinsicWidth() {
        int width = -1;
        for (int i = 0; i < this.mLayers.length; ++i) {
            Drawable drawable = this.mLayers[i];
            if (drawable == null) continue;
            width = Math.max(width, drawable.getIntrinsicWidth());
        }
        return width > 0 ? width : -1;
    }

    public int getIntrinsicHeight() {
        int height = -1;
        for (int i = 0; i < this.mLayers.length; ++i) {
            Drawable drawable = this.mLayers[i];
            if (drawable == null) continue;
            height = Math.max(height, drawable.getIntrinsicHeight());
        }
        return height > 0 ? height : -1;
    }

    protected void onBoundsChange(Rect bounds) {
        this.mBounds.set(bounds);
        for (int i = 0; i < this.mLayers.length; ++i) {
            Drawable drawable = this.mLayers[i];
            if (drawable == null) continue;
            drawable.setBounds(bounds);
        }
    }

    public boolean isStateful() {
        if (!this.mIsStatefulCalculated) {
            this.mIsStateful = false;
            for (int i = 0; i < this.mLayers.length; ++i) {
                Drawable drawable = this.mLayers[i];
                this.mIsStateful |= drawable != null && drawable.isStateful();
            }
            this.mIsStatefulCalculated = true;
        }
        return this.mIsStateful;
    }

    protected boolean onStateChange(int[] state) {
        this.mState = state;
        boolean stateChanged = false;
        for (int i = 0; i < this.mLayers.length; ++i) {
            Drawable drawable = this.mLayers[i];
            if (drawable == null || !drawable.setState(state)) continue;
            stateChanged = true;
        }
        return stateChanged;
    }

    protected boolean onLevelChange(int level) {
        this.mLevel = level;
        boolean levelChanged = false;
        for (int i = 0; i < this.mLayers.length; ++i) {
            Drawable drawable = this.mLayers[i];
            if (drawable == null || !drawable.setLevel(level)) continue;
            levelChanged = true;
        }
        return levelChanged;
    }

    public void draw(Canvas canvas) {
        for (int i = 0; i < this.mLayers.length; ++i) {
            Drawable drawable = this.mLayers[i];
            if (drawable == null) continue;
            drawable.draw(canvas);
        }
    }

    public boolean getPadding(Rect padding) {
        padding.left = 0;
        padding.top = 0;
        padding.right = 0;
        padding.bottom = 0;
        Rect rect = this.mTmpRect;
        for (int i = 0; i < this.mLayers.length; ++i) {
            Drawable drawable = this.mLayers[i];
            if (drawable == null) continue;
            drawable.getPadding(rect);
            padding.left = Math.max(padding.left, rect.left);
            padding.top = Math.max(padding.top, rect.top);
            padding.right = Math.max(padding.right, rect.right);
            padding.bottom = Math.max(padding.bottom, rect.bottom);
        }
        return true;
    }

    public Drawable mutate() {
        for (int i = 0; i < this.mLayers.length; ++i) {
            Drawable drawable = this.mLayers[i];
            if (drawable == null) continue;
            drawable.mutate();
        }
        this.mIsMutated = true;
        return this;
    }

    public int getOpacity() {
        if (this.mLayers.length == 0) {
            return -2;
        }
        int opacity = -1;
        for (int i = 1; i < this.mLayers.length; ++i) {
            Drawable drawable = this.mLayers[i];
            if (drawable == null) continue;
            opacity = Drawable.resolveOpacity((int)opacity, (int)drawable.getOpacity());
        }
        return opacity;
    }

    public void setAlpha(int alpha) {
        this.mDrawableProperties.setAlpha(alpha);
        for (int i = 0; i < this.mLayers.length; ++i) {
            Drawable drawable = this.mLayers[i];
            if (drawable == null) continue;
            drawable.setAlpha(alpha);
        }
    }

    public void setColorFilter(ColorFilter colorFilter) {
        this.mDrawableProperties.setColorFilter(colorFilter);
        for (int i = 0; i < this.mLayers.length; ++i) {
            Drawable drawable = this.mLayers[i];
            if (drawable == null) continue;
            drawable.setColorFilter(colorFilter);
        }
    }

    public void setDither(boolean dither) {
        this.mDrawableProperties.setDither(dither);
        for (int i = 0; i < this.mLayers.length; ++i) {
            Drawable drawable = this.mLayers[i];
            if (drawable == null) continue;
            drawable.setDither(dither);
        }
    }

    public void setFilterBitmap(boolean filterBitmap) {
        this.mDrawableProperties.setFilterBitmap(filterBitmap);
        for (int i = 0; i < this.mLayers.length; ++i) {
            Drawable drawable = this.mLayers[i];
            if (drawable == null) continue;
            drawable.setFilterBitmap(filterBitmap);
        }
    }

    public boolean setVisible(boolean visible, boolean restart) {
        this.mIsVisible = visible;
        boolean changed = super.setVisible(visible, restart);
        for (int i = 0; i < this.mLayers.length; ++i) {
            Drawable drawable = this.mLayers[i];
            if (drawable == null) continue;
            drawable.setVisible(visible, restart);
        }
        return changed;
    }

    public void invalidateDrawable(Drawable who) {
        this.invalidateSelf();
    }

    public void scheduleDrawable(Drawable who, Runnable what, long when) {
        this.scheduleSelf(what, when);
    }

    public void unscheduleDrawable(Drawable who, Runnable what) {
        this.unscheduleSelf(what);
    }

    @Override
    public void setTransformCallback(TransformCallback transformCallback) {
        this.mTransformCallback = transformCallback;
    }

    @Override
    public void getTransform(Matrix transform) {
        if (this.mTransformCallback != null) {
            this.mTransformCallback.getTransform(transform);
        } else {
            transform.reset();
        }
    }

    @Override
    public void getRootBounds(RectF bounds) {
        if (this.mTransformCallback != null) {
            this.mTransformCallback.getRootBounds(bounds);
        } else {
            bounds.set(this.getBounds());
        }
    }
}

