/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.drawee.drawable;

import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.PointF;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import com.facebook.common.internal.Preconditions;
import com.facebook.common.internal.VisibleForTesting;
import com.facebook.drawee.drawable.ForwardingDrawable;
import com.facebook.drawee.drawable.ScalingUtils;

public class ScaleTypeDrawable
extends ForwardingDrawable {
    @VisibleForTesting
    ScalingUtils.ScaleType mScaleType;
    @VisibleForTesting
    PointF mFocusPoint = null;
    @VisibleForTesting
    int mUnderlyingWidth = 0;
    @VisibleForTesting
    int mUnderlyingHeight = 0;
    @VisibleForTesting
    Matrix mDrawMatrix;
    private Matrix mTempMatrix = new Matrix();

    public ScaleTypeDrawable(Drawable drawable, ScalingUtils.ScaleType scaleType) {
        super((Drawable)Preconditions.checkNotNull((Object)drawable));
        this.mScaleType = scaleType;
    }

    public ScalingUtils.ScaleType getScaleType() {
        return this.mScaleType;
    }

    public void setScaleType(ScalingUtils.ScaleType scaleType) {
        this.mScaleType = scaleType;
        this.configureBounds();
        this.invalidateSelf();
    }

    public PointF getFocusPoint() {
        return this.mFocusPoint;
    }

    public void setFocusPoint(PointF focusPoint) {
        if (this.mFocusPoint == null) {
            this.mFocusPoint = new PointF();
        }
        this.mFocusPoint.set(focusPoint);
        this.configureBounds();
        this.invalidateSelf();
    }

    @Override
    public void draw(Canvas canvas) {
        this.configureBoundsIfUnderlyingChanged();
        if (this.mDrawMatrix != null) {
            int saveCount = canvas.save();
            canvas.clipRect(this.getBounds());
            canvas.concat(this.mDrawMatrix);
            super.draw(canvas);
            canvas.restoreToCount(saveCount);
        } else {
            super.draw(canvas);
        }
    }

    @Override
    protected void onBoundsChange(Rect bounds) {
        this.configureBounds();
    }

    private void configureBoundsIfUnderlyingChanged() {
        if (this.mUnderlyingWidth != this.getCurrent().getIntrinsicWidth() || this.mUnderlyingHeight != this.getCurrent().getIntrinsicHeight()) {
            this.configureBounds();
        }
    }

    @VisibleForTesting
    void configureBounds() {
        Drawable underlyingDrawable = this.getCurrent();
        Rect bounds = this.getBounds();
        int viewWidth = bounds.width();
        int viewHeight = bounds.height();
        int underlyingWidth = this.mUnderlyingWidth = underlyingDrawable.getIntrinsicWidth();
        int underlyingHeight = this.mUnderlyingHeight = underlyingDrawable.getIntrinsicHeight();
        if (underlyingWidth <= 0 || underlyingHeight <= 0) {
            underlyingDrawable.setBounds(bounds);
            this.mDrawMatrix = null;
            return;
        }
        if (underlyingWidth == viewWidth && underlyingHeight == viewHeight) {
            underlyingDrawable.setBounds(bounds);
            this.mDrawMatrix = null;
            return;
        }
        if (this.mScaleType == ScalingUtils.ScaleType.FIT_XY) {
            underlyingDrawable.setBounds(bounds);
            this.mDrawMatrix = null;
            return;
        }
        underlyingDrawable.setBounds(0, 0, underlyingWidth, underlyingHeight);
        ScalingUtils.getTransform(this.mTempMatrix, bounds, underlyingWidth, underlyingHeight, this.mFocusPoint != null ? this.mFocusPoint.x : 0.5f, this.mFocusPoint != null ? this.mFocusPoint.y : 0.5f, this.mScaleType);
        this.mDrawMatrix = this.mTempMatrix;
    }

    @Override
    public void getTransform(Matrix transform) {
        this.getParentTransform(transform);
        this.configureBoundsIfUnderlyingChanged();
        if (this.mDrawMatrix != null) {
            transform.preConcat(this.mDrawMatrix);
        }
    }
}

