/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.producers;

import android.content.res.AssetFileDescriptor;
import android.content.res.Resources;
import com.facebook.common.internal.VisibleForTesting;
import com.facebook.imagepipeline.image.EncodedImage;
import com.facebook.imagepipeline.memory.PooledByteBufferFactory;
import com.facebook.imagepipeline.producers.LocalFetchProducer;
import com.facebook.imagepipeline.request.ImageRequest;
import java.io.IOException;
import java.util.concurrent.Executor;

public class LocalResourceFetchProducer
extends LocalFetchProducer {
    @VisibleForTesting
    static final String PRODUCER_NAME = "LocalResourceFetchProducer";
    private final Resources mResources;

    public LocalResourceFetchProducer(Executor executor, PooledByteBufferFactory pooledByteBufferFactory, Resources resources, boolean decodeFileDescriptorEnabled) {
        super(executor, pooledByteBufferFactory, decodeFileDescriptorEnabled);
        this.mResources = resources;
    }

    @Override
    protected EncodedImage getEncodedImage(ImageRequest imageRequest) throws IOException {
        return this.getEncodedImage(this.mResources.openRawResource(LocalResourceFetchProducer.getResourceId(imageRequest)), this.getLength(imageRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getLength(ImageRequest imageRequest) {
        AssetFileDescriptor fd = null;
        try {
            fd = this.mResources.openRawResourceFd(LocalResourceFetchProducer.getResourceId(imageRequest));
            int n = (int)fd.getLength();
            return n;
        }
        catch (Resources.NotFoundException e) {
            int n = -1;
            return n;
        }
        finally {
            try {
                if (fd != null) {
                    fd.close();
                }
            }
            catch (IOException ignored) {}
        }
    }

    @Override
    protected String getProducerName() {
        return PRODUCER_NAME;
    }

    private static int getResourceId(ImageRequest imageRequest) {
        return Integer.parseInt(imageRequest.getSourceUri().getPath().substring(1));
    }
}

