/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.media.session;

import android.app.PendingIntent;
import android.content.Context;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.os.ResultReceiver;
import android.support.v4.media.MediaMetadataCompat;
import android.support.v4.media.RatingCompat;
import android.support.v4.media.session.IMediaControllerCallback;
import android.support.v4.media.session.IMediaSession;
import android.support.v4.media.session.MediaControllerCompatApi21;
import android.support.v4.media.session.MediaControllerCompatApi23;
import android.support.v4.media.session.MediaSessionCompat;
import android.support.v4.media.session.ParcelableVolumeInfo;
import android.support.v4.media.session.PlaybackStateCompat;
import android.text.TextUtils;
import android.util.Log;
import android.view.KeyEvent;
import java.util.ArrayList;
import java.util.List;

public final class MediaControllerCompat {
    private static final String TAG = "MediaControllerCompat";
    private final MediaControllerImpl mImpl;
    private final MediaSessionCompat.Token mToken;

    public MediaControllerCompat(Context context, MediaSessionCompat session) {
        if (session == null) {
            throw new IllegalArgumentException("session must not be null");
        }
        this.mToken = session.getSessionToken();
        this.mImpl = Build.VERSION.SDK_INT >= 23 ? new MediaControllerImplApi23(context, session) : (Build.VERSION.SDK_INT >= 21 ? new MediaControllerImplApi21(context, session) : new MediaControllerImplBase(this.mToken));
    }

    public MediaControllerCompat(Context context, MediaSessionCompat.Token sessionToken) throws RemoteException {
        if (sessionToken == null) {
            throw new IllegalArgumentException("sessionToken must not be null");
        }
        this.mToken = sessionToken;
        this.mImpl = Build.VERSION.SDK_INT >= 21 ? new MediaControllerImplApi21(context, sessionToken) : new MediaControllerImplBase(this.mToken);
    }

    public TransportControls getTransportControls() {
        return this.mImpl.getTransportControls();
    }

    public boolean dispatchMediaButtonEvent(KeyEvent keyEvent) {
        if (keyEvent == null) {
            throw new IllegalArgumentException("KeyEvent may not be null");
        }
        return this.mImpl.dispatchMediaButtonEvent(keyEvent);
    }

    public PlaybackStateCompat getPlaybackState() {
        return this.mImpl.getPlaybackState();
    }

    public MediaMetadataCompat getMetadata() {
        return this.mImpl.getMetadata();
    }

    public List<MediaSessionCompat.QueueItem> getQueue() {
        return this.mImpl.getQueue();
    }

    public CharSequence getQueueTitle() {
        return this.mImpl.getQueueTitle();
    }

    public Bundle getExtras() {
        return this.mImpl.getExtras();
    }

    public int getRatingType() {
        return this.mImpl.getRatingType();
    }

    public long getFlags() {
        return this.mImpl.getFlags();
    }

    public PlaybackInfo getPlaybackInfo() {
        return this.mImpl.getPlaybackInfo();
    }

    public PendingIntent getSessionActivity() {
        return this.mImpl.getSessionActivity();
    }

    public MediaSessionCompat.Token getSessionToken() {
        return this.mToken;
    }

    public void setVolumeTo(int value, int flags) {
        this.mImpl.setVolumeTo(value, flags);
    }

    public void adjustVolume(int direction, int flags) {
        this.mImpl.adjustVolume(direction, flags);
    }

    public void registerCallback(Callback callback) {
        this.registerCallback(callback, null);
    }

    public void registerCallback(Callback callback, Handler handler) {
        if (callback == null) {
            throw new IllegalArgumentException("callback cannot be null");
        }
        if (handler == null) {
            handler = new Handler();
        }
        this.mImpl.registerCallback(callback, handler);
    }

    public void unregisterCallback(Callback callback) {
        if (callback == null) {
            throw new IllegalArgumentException("callback cannot be null");
        }
        this.mImpl.unregisterCallback(callback);
    }

    public void sendCommand(String command, Bundle params, ResultReceiver cb) {
        if (TextUtils.isEmpty((CharSequence)command)) {
            throw new IllegalArgumentException("command cannot be null or empty");
        }
        this.mImpl.sendCommand(command, params, cb);
    }

    public String getPackageName() {
        return this.mImpl.getPackageName();
    }

    public Object getMediaController() {
        return this.mImpl.getMediaController();
    }

    static class TransportControlsApi23
    extends TransportControlsApi21 {
        public TransportControlsApi23(Object controlsObj) {
            super(controlsObj);
        }

        @Override
        public void playFromUri(Uri uri, Bundle extras) {
            MediaControllerCompatApi23.TransportControls.playFromUri((Object)this.mControlsObj, (Uri)uri, (Bundle)extras);
        }
    }

    static class MediaControllerImplApi23
    extends MediaControllerImplApi21 {
        public MediaControllerImplApi23(Context context, MediaSessionCompat session) {
            super(context, session);
        }

        public MediaControllerImplApi23(Context context, MediaSessionCompat.Token sessionToken) throws RemoteException {
            super(context, sessionToken);
        }

        @Override
        public TransportControls getTransportControls() {
            Object controlsObj = MediaControllerCompatApi21.getTransportControls((Object)this.mControllerObj);
            return controlsObj != null ? new TransportControlsApi23(controlsObj) : null;
        }
    }

    static class TransportControlsApi21
    extends TransportControls {
        protected final Object mControlsObj;

        public TransportControlsApi21(Object controlsObj) {
            this.mControlsObj = controlsObj;
        }

        @Override
        public void play() {
            MediaControllerCompatApi21.TransportControls.play((Object)this.mControlsObj);
        }

        @Override
        public void pause() {
            MediaControllerCompatApi21.TransportControls.pause((Object)this.mControlsObj);
        }

        @Override
        public void stop() {
            MediaControllerCompatApi21.TransportControls.stop((Object)this.mControlsObj);
        }

        @Override
        public void seekTo(long pos) {
            MediaControllerCompatApi21.TransportControls.seekTo((Object)this.mControlsObj, (long)pos);
        }

        @Override
        public void fastForward() {
            MediaControllerCompatApi21.TransportControls.fastForward((Object)this.mControlsObj);
        }

        @Override
        public void rewind() {
            MediaControllerCompatApi21.TransportControls.rewind((Object)this.mControlsObj);
        }

        @Override
        public void skipToNext() {
            MediaControllerCompatApi21.TransportControls.skipToNext((Object)this.mControlsObj);
        }

        @Override
        public void skipToPrevious() {
            MediaControllerCompatApi21.TransportControls.skipToPrevious((Object)this.mControlsObj);
        }

        @Override
        public void setRating(RatingCompat rating) {
            MediaControllerCompatApi21.TransportControls.setRating((Object)this.mControlsObj, (Object)(rating != null ? rating.getRating() : null));
        }

        @Override
        public void playFromMediaId(String mediaId, Bundle extras) {
            MediaControllerCompatApi21.TransportControls.playFromMediaId((Object)this.mControlsObj, (String)mediaId, (Bundle)extras);
        }

        @Override
        public void playFromSearch(String query, Bundle extras) {
            MediaControllerCompatApi21.TransportControls.playFromSearch((Object)this.mControlsObj, (String)query, (Bundle)extras);
        }

        @Override
        public void playFromUri(Uri uri, Bundle extras) {
        }

        @Override
        public void skipToQueueItem(long id) {
            MediaControllerCompatApi21.TransportControls.skipToQueueItem((Object)this.mControlsObj, (long)id);
        }

        @Override
        public void sendCustomAction(PlaybackStateCompat.CustomAction customAction, Bundle args) {
            MediaControllerCompatApi21.TransportControls.sendCustomAction((Object)this.mControlsObj, (String)customAction.getAction(), (Bundle)args);
        }

        @Override
        public void sendCustomAction(String action, Bundle args) {
            MediaControllerCompatApi21.TransportControls.sendCustomAction((Object)this.mControlsObj, (String)action, (Bundle)args);
        }
    }

    static class MediaControllerImplApi21
    implements MediaControllerImpl {
        protected final Object mControllerObj;

        public MediaControllerImplApi21(Context context, MediaSessionCompat session) {
            this.mControllerObj = MediaControllerCompatApi21.fromToken((Context)context, (Object)session.getSessionToken().getToken());
        }

        public MediaControllerImplApi21(Context context, MediaSessionCompat.Token sessionToken) throws RemoteException {
            this.mControllerObj = MediaControllerCompatApi21.fromToken((Context)context, (Object)sessionToken.getToken());
            if (this.mControllerObj == null) {
                throw new RemoteException();
            }
        }

        @Override
        public void registerCallback(Callback callback, Handler handler) {
            MediaControllerCompatApi21.registerCallback((Object)this.mControllerObj, (Object)callback.mCallbackObj, (Handler)handler);
        }

        @Override
        public void unregisterCallback(Callback callback) {
            MediaControllerCompatApi21.unregisterCallback((Object)this.mControllerObj, (Object)callback.mCallbackObj);
        }

        @Override
        public boolean dispatchMediaButtonEvent(KeyEvent event) {
            return MediaControllerCompatApi21.dispatchMediaButtonEvent((Object)this.mControllerObj, (KeyEvent)event);
        }

        @Override
        public TransportControls getTransportControls() {
            Object controlsObj = MediaControllerCompatApi21.getTransportControls((Object)this.mControllerObj);
            return controlsObj != null ? new TransportControlsApi21(controlsObj) : null;
        }

        @Override
        public PlaybackStateCompat getPlaybackState() {
            Object stateObj = MediaControllerCompatApi21.getPlaybackState((Object)this.mControllerObj);
            return stateObj != null ? PlaybackStateCompat.fromPlaybackState(stateObj) : null;
        }

        @Override
        public MediaMetadataCompat getMetadata() {
            Object metadataObj = MediaControllerCompatApi21.getMetadata((Object)this.mControllerObj);
            return metadataObj != null ? MediaMetadataCompat.fromMediaMetadata(metadataObj) : null;
        }

        @Override
        public List<MediaSessionCompat.QueueItem> getQueue() {
            List queueObjs = MediaControllerCompatApi21.getQueue((Object)this.mControllerObj);
            if (queueObjs == null) {
                return null;
            }
            ArrayList<MediaSessionCompat.QueueItem> queue = new ArrayList<MediaSessionCompat.QueueItem>();
            for (Object item : queueObjs) {
                queue.add(MediaSessionCompat.QueueItem.obtain(item));
            }
            return queue;
        }

        @Override
        public CharSequence getQueueTitle() {
            return MediaControllerCompatApi21.getQueueTitle((Object)this.mControllerObj);
        }

        @Override
        public Bundle getExtras() {
            return MediaControllerCompatApi21.getExtras((Object)this.mControllerObj);
        }

        @Override
        public int getRatingType() {
            return MediaControllerCompatApi21.getRatingType((Object)this.mControllerObj);
        }

        @Override
        public long getFlags() {
            return MediaControllerCompatApi21.getFlags((Object)this.mControllerObj);
        }

        @Override
        public PlaybackInfo getPlaybackInfo() {
            Object volumeInfoObj = MediaControllerCompatApi21.getPlaybackInfo((Object)this.mControllerObj);
            return volumeInfoObj != null ? new PlaybackInfo(MediaControllerCompatApi21.PlaybackInfo.getPlaybackType((Object)volumeInfoObj), MediaControllerCompatApi21.PlaybackInfo.getLegacyAudioStream((Object)volumeInfoObj), MediaControllerCompatApi21.PlaybackInfo.getVolumeControl((Object)volumeInfoObj), MediaControllerCompatApi21.PlaybackInfo.getMaxVolume((Object)volumeInfoObj), MediaControllerCompatApi21.PlaybackInfo.getCurrentVolume((Object)volumeInfoObj)) : null;
        }

        @Override
        public PendingIntent getSessionActivity() {
            return MediaControllerCompatApi21.getSessionActivity((Object)this.mControllerObj);
        }

        @Override
        public void setVolumeTo(int value, int flags) {
            MediaControllerCompatApi21.setVolumeTo((Object)this.mControllerObj, (int)value, (int)flags);
        }

        @Override
        public void adjustVolume(int direction, int flags) {
            MediaControllerCompatApi21.adjustVolume((Object)this.mControllerObj, (int)direction, (int)flags);
        }

        @Override
        public void sendCommand(String command, Bundle params, ResultReceiver cb) {
            MediaControllerCompatApi21.sendCommand((Object)this.mControllerObj, (String)command, (Bundle)params, (ResultReceiver)cb);
        }

        @Override
        public String getPackageName() {
            return MediaControllerCompatApi21.getPackageName((Object)this.mControllerObj);
        }

        @Override
        public Object getMediaController() {
            return this.mControllerObj;
        }
    }

    static class TransportControlsBase
    extends TransportControls {
        private IMediaSession mBinder;

        public TransportControlsBase(IMediaSession binder) {
            this.mBinder = binder;
        }

        @Override
        public void play() {
            try {
                this.mBinder.play();
            }
            catch (RemoteException e) {
                Log.e((String)MediaControllerCompat.TAG, (String)("Dead object in play. " + (Object)((Object)e)));
            }
        }

        @Override
        public void playFromMediaId(String mediaId, Bundle extras) {
            try {
                this.mBinder.playFromMediaId(mediaId, extras);
            }
            catch (RemoteException e) {
                Log.e((String)MediaControllerCompat.TAG, (String)("Dead object in playFromMediaId. " + (Object)((Object)e)));
            }
        }

        @Override
        public void playFromSearch(String query, Bundle extras) {
            try {
                this.mBinder.playFromSearch(query, extras);
            }
            catch (RemoteException e) {
                Log.e((String)MediaControllerCompat.TAG, (String)("Dead object in playFromSearch. " + (Object)((Object)e)));
            }
        }

        @Override
        public void playFromUri(Uri uri, Bundle extras) {
            try {
                this.mBinder.playFromUri(uri, extras);
            }
            catch (RemoteException e) {
                Log.e((String)MediaControllerCompat.TAG, (String)("Dead object in playFromUri. " + (Object)((Object)e)));
            }
        }

        @Override
        public void skipToQueueItem(long id) {
            try {
                this.mBinder.skipToQueueItem(id);
            }
            catch (RemoteException e) {
                Log.e((String)MediaControllerCompat.TAG, (String)("Dead object in skipToQueueItem. " + (Object)((Object)e)));
            }
        }

        @Override
        public void pause() {
            try {
                this.mBinder.pause();
            }
            catch (RemoteException e) {
                Log.e((String)MediaControllerCompat.TAG, (String)("Dead object in pause. " + (Object)((Object)e)));
            }
        }

        @Override
        public void stop() {
            try {
                this.mBinder.stop();
            }
            catch (RemoteException e) {
                Log.e((String)MediaControllerCompat.TAG, (String)("Dead object in stop. " + (Object)((Object)e)));
            }
        }

        @Override
        public void seekTo(long pos) {
            try {
                this.mBinder.seekTo(pos);
            }
            catch (RemoteException e) {
                Log.e((String)MediaControllerCompat.TAG, (String)("Dead object in seekTo. " + (Object)((Object)e)));
            }
        }

        @Override
        public void fastForward() {
            try {
                this.mBinder.fastForward();
            }
            catch (RemoteException e) {
                Log.e((String)MediaControllerCompat.TAG, (String)("Dead object in fastForward. " + (Object)((Object)e)));
            }
        }

        @Override
        public void skipToNext() {
            try {
                this.mBinder.next();
            }
            catch (RemoteException e) {
                Log.e((String)MediaControllerCompat.TAG, (String)("Dead object in skipToNext. " + (Object)((Object)e)));
            }
        }

        @Override
        public void rewind() {
            try {
                this.mBinder.rewind();
            }
            catch (RemoteException e) {
                Log.e((String)MediaControllerCompat.TAG, (String)("Dead object in rewind. " + (Object)((Object)e)));
            }
        }

        @Override
        public void skipToPrevious() {
            try {
                this.mBinder.previous();
            }
            catch (RemoteException e) {
                Log.e((String)MediaControllerCompat.TAG, (String)("Dead object in skipToPrevious. " + (Object)((Object)e)));
            }
        }

        @Override
        public void setRating(RatingCompat rating) {
            try {
                this.mBinder.rate(rating);
            }
            catch (RemoteException e) {
                Log.e((String)MediaControllerCompat.TAG, (String)("Dead object in setRating. " + (Object)((Object)e)));
            }
        }

        @Override
        public void sendCustomAction(PlaybackStateCompat.CustomAction customAction, Bundle args) {
            this.sendCustomAction(customAction.getAction(), args);
        }

        @Override
        public void sendCustomAction(String action, Bundle args) {
            try {
                this.mBinder.sendCustomAction(action, args);
            }
            catch (RemoteException e) {
                Log.e((String)MediaControllerCompat.TAG, (String)("Dead object in sendCustomAction. " + (Object)((Object)e)));
            }
        }
    }

    static class MediaControllerImplBase
    implements MediaControllerImpl {
        private MediaSessionCompat.Token mToken;
        private IMediaSession mBinder;
        private TransportControls mTransportControls;

        public MediaControllerImplBase(MediaSessionCompat.Token token) {
            this.mToken = token;
            this.mBinder = IMediaSession.Stub.asInterface((IBinder)token.getToken());
        }

        @Override
        public void registerCallback(Callback callback, Handler handler) {
            if (callback == null) {
                throw new IllegalArgumentException("callback may not be null.");
            }
            try {
                this.mBinder.asBinder().linkToDeath((IBinder.DeathRecipient)callback, 0);
                this.mBinder.registerCallbackListener((IMediaControllerCallback)callback.mCallbackObj);
                callback.setHandler(handler);
                callback.mRegistered = true;
            }
            catch (RemoteException e) {
                Log.e((String)MediaControllerCompat.TAG, (String)("Dead object in registerCallback. " + (Object)((Object)e)));
                callback.onSessionDestroyed();
            }
        }

        @Override
        public void unregisterCallback(Callback callback) {
            if (callback == null) {
                throw new IllegalArgumentException("callback may not be null.");
            }
            try {
                this.mBinder.unregisterCallbackListener((IMediaControllerCallback)callback.mCallbackObj);
                this.mBinder.asBinder().unlinkToDeath((IBinder.DeathRecipient)callback, 0);
                callback.mRegistered = false;
            }
            catch (RemoteException e) {
                Log.e((String)MediaControllerCompat.TAG, (String)("Dead object in unregisterCallback. " + (Object)((Object)e)));
            }
        }

        @Override
        public boolean dispatchMediaButtonEvent(KeyEvent event) {
            if (event == null) {
                throw new IllegalArgumentException("event may not be null.");
            }
            try {
                this.mBinder.sendMediaButton(event);
            }
            catch (RemoteException e) {
                Log.e((String)MediaControllerCompat.TAG, (String)("Dead object in dispatchMediaButtonEvent. " + (Object)((Object)e)));
            }
            return false;
        }

        @Override
        public TransportControls getTransportControls() {
            if (this.mTransportControls == null) {
                this.mTransportControls = new TransportControlsBase(this.mBinder);
            }
            return this.mTransportControls;
        }

        @Override
        public PlaybackStateCompat getPlaybackState() {
            try {
                return this.mBinder.getPlaybackState();
            }
            catch (RemoteException e) {
                Log.e((String)MediaControllerCompat.TAG, (String)("Dead object in getPlaybackState. " + (Object)((Object)e)));
                return null;
            }
        }

        @Override
        public MediaMetadataCompat getMetadata() {
            try {
                return this.mBinder.getMetadata();
            }
            catch (RemoteException e) {
                Log.e((String)MediaControllerCompat.TAG, (String)("Dead object in getMetadata. " + (Object)((Object)e)));
                return null;
            }
        }

        @Override
        public List<MediaSessionCompat.QueueItem> getQueue() {
            try {
                return this.mBinder.getQueue();
            }
            catch (RemoteException e) {
                Log.e((String)MediaControllerCompat.TAG, (String)("Dead object in getQueue. " + (Object)((Object)e)));
                return null;
            }
        }

        @Override
        public CharSequence getQueueTitle() {
            try {
                return this.mBinder.getQueueTitle();
            }
            catch (RemoteException e) {
                Log.e((String)MediaControllerCompat.TAG, (String)("Dead object in getQueueTitle. " + (Object)((Object)e)));
                return null;
            }
        }

        @Override
        public Bundle getExtras() {
            try {
                return this.mBinder.getExtras();
            }
            catch (RemoteException e) {
                Log.e((String)MediaControllerCompat.TAG, (String)("Dead object in getExtras. " + (Object)((Object)e)));
                return null;
            }
        }

        @Override
        public int getRatingType() {
            try {
                return this.mBinder.getRatingType();
            }
            catch (RemoteException e) {
                Log.e((String)MediaControllerCompat.TAG, (String)("Dead object in getRatingType. " + (Object)((Object)e)));
                return 0;
            }
        }

        @Override
        public long getFlags() {
            try {
                return this.mBinder.getFlags();
            }
            catch (RemoteException e) {
                Log.e((String)MediaControllerCompat.TAG, (String)("Dead object in getFlags. " + (Object)((Object)e)));
                return 0L;
            }
        }

        @Override
        public PlaybackInfo getPlaybackInfo() {
            try {
                ParcelableVolumeInfo info = this.mBinder.getVolumeAttributes();
                PlaybackInfo pi = new PlaybackInfo(info.volumeType, info.audioStream, info.controlType, info.maxVolume, info.currentVolume);
                return pi;
            }
            catch (RemoteException e) {
                Log.e((String)MediaControllerCompat.TAG, (String)("Dead object in getPlaybackInfo. " + (Object)((Object)e)));
                return null;
            }
        }

        @Override
        public PendingIntent getSessionActivity() {
            try {
                return this.mBinder.getLaunchPendingIntent();
            }
            catch (RemoteException e) {
                Log.e((String)MediaControllerCompat.TAG, (String)("Dead object in getSessionActivity. " + (Object)((Object)e)));
                return null;
            }
        }

        @Override
        public void setVolumeTo(int value, int flags) {
            try {
                this.mBinder.setVolumeTo(value, flags, null);
            }
            catch (RemoteException e) {
                Log.e((String)MediaControllerCompat.TAG, (String)("Dead object in setVolumeTo. " + (Object)((Object)e)));
            }
        }

        @Override
        public void adjustVolume(int direction, int flags) {
            try {
                this.mBinder.adjustVolume(direction, flags, null);
            }
            catch (RemoteException e) {
                Log.e((String)MediaControllerCompat.TAG, (String)("Dead object in adjustVolume. " + (Object)((Object)e)));
            }
        }

        @Override
        public void sendCommand(String command, Bundle params, ResultReceiver cb) {
            try {
                this.mBinder.sendCommand(command, params, new MediaSessionCompat.ResultReceiverWrapper(cb));
            }
            catch (RemoteException e) {
                Log.e((String)MediaControllerCompat.TAG, (String)("Dead object in sendCommand. " + (Object)((Object)e)));
            }
        }

        @Override
        public String getPackageName() {
            try {
                return this.mBinder.getPackageName();
            }
            catch (RemoteException e) {
                Log.e((String)MediaControllerCompat.TAG, (String)("Dead object in getPackageName. " + (Object)((Object)e)));
                return null;
            }
        }

        @Override
        public Object getMediaController() {
            return null;
        }
    }

    static interface MediaControllerImpl {
        public void registerCallback(Callback var1, Handler var2);

        public void unregisterCallback(Callback var1);

        public boolean dispatchMediaButtonEvent(KeyEvent var1);

        public TransportControls getTransportControls();

        public PlaybackStateCompat getPlaybackState();

        public MediaMetadataCompat getMetadata();

        public List<MediaSessionCompat.QueueItem> getQueue();

        public CharSequence getQueueTitle();

        public Bundle getExtras();

        public int getRatingType();

        public long getFlags();

        public PlaybackInfo getPlaybackInfo();

        public PendingIntent getSessionActivity();

        public void setVolumeTo(int var1, int var2);

        public void adjustVolume(int var1, int var2);

        public void sendCommand(String var1, Bundle var2, ResultReceiver var3);

        public String getPackageName();

        public Object getMediaController();
    }

    public static final class PlaybackInfo {
        public static final int PLAYBACK_TYPE_LOCAL = 1;
        public static final int PLAYBACK_TYPE_REMOTE = 2;
        private final int mPlaybackType;
        private final int mAudioStream;
        private final int mVolumeControl;
        private final int mMaxVolume;
        private final int mCurrentVolume;

        PlaybackInfo(int type, int stream, int control, int max, int current) {
            this.mPlaybackType = type;
            this.mAudioStream = stream;
            this.mVolumeControl = control;
            this.mMaxVolume = max;
            this.mCurrentVolume = current;
        }

        public int getPlaybackType() {
            return this.mPlaybackType;
        }

        public int getAudioStream() {
            return this.mAudioStream;
        }

        public int getVolumeControl() {
            return this.mVolumeControl;
        }

        public int getMaxVolume() {
            return this.mMaxVolume;
        }

        public int getCurrentVolume() {
            return this.mCurrentVolume;
        }
    }

    public static abstract class TransportControls {
        TransportControls() {
        }

        public abstract void play();

        public abstract void playFromMediaId(String var1, Bundle var2);

        public abstract void playFromSearch(String var1, Bundle var2);

        public abstract void playFromUri(Uri var1, Bundle var2);

        public abstract void skipToQueueItem(long var1);

        public abstract void pause();

        public abstract void stop();

        public abstract void seekTo(long var1);

        public abstract void fastForward();

        public abstract void skipToNext();

        public abstract void rewind();

        public abstract void skipToPrevious();

        public abstract void setRating(RatingCompat var1);

        public abstract void sendCustomAction(PlaybackStateCompat.CustomAction var1, Bundle var2);

        public abstract void sendCustomAction(String var1, Bundle var2);
    }

    public static abstract class Callback
    implements IBinder.DeathRecipient {
        private final Object mCallbackObj = Build.VERSION.SDK_INT >= 21 ? MediaControllerCompatApi21.createCallback((MediaControllerCompatApi21.Callback)new StubApi21()) : new StubCompat();
        private MessageHandler mHandler;
        private boolean mRegistered = false;

        public void onSessionDestroyed() {
        }

        public void onSessionEvent(String event, Bundle extras) {
        }

        public void onPlaybackStateChanged(PlaybackStateCompat state) {
        }

        public void onMetadataChanged(MediaMetadataCompat metadata) {
        }

        public void onQueueChanged(List<MediaSessionCompat.QueueItem> queue) {
        }

        public void onQueueTitleChanged(CharSequence title) {
        }

        public void onExtrasChanged(Bundle extras) {
        }

        public void onAudioInfoChanged(PlaybackInfo info) {
        }

        public void binderDied() {
            this.onSessionDestroyed();
        }

        private void setHandler(Handler handler) {
            this.mHandler = new MessageHandler(handler.getLooper());
        }

        private class MessageHandler
        extends Handler {
            private static final int MSG_EVENT = 1;
            private static final int MSG_UPDATE_PLAYBACK_STATE = 2;
            private static final int MSG_UPDATE_METADATA = 3;
            private static final int MSG_UPDATE_VOLUME = 4;
            private static final int MSG_UPDATE_QUEUE = 5;
            private static final int MSG_UPDATE_QUEUE_TITLE = 6;
            private static final int MSG_UPDATE_EXTRAS = 7;
            private static final int MSG_DESTROYED = 8;

            public MessageHandler(Looper looper) {
                super(looper);
            }

            public void handleMessage(Message msg) {
                if (!Callback.this.mRegistered) {
                    return;
                }
                switch (msg.what) {
                    case 1: {
                        Callback.this.onSessionEvent((String)msg.obj, msg.getData());
                        break;
                    }
                    case 2: {
                        Callback.this.onPlaybackStateChanged((PlaybackStateCompat)msg.obj);
                        break;
                    }
                    case 3: {
                        Callback.this.onMetadataChanged((MediaMetadataCompat)msg.obj);
                        break;
                    }
                    case 5: {
                        Callback.this.onQueueChanged((List)msg.obj);
                        break;
                    }
                    case 6: {
                        Callback.this.onQueueTitleChanged((CharSequence)msg.obj);
                        break;
                    }
                    case 7: {
                        Callback.this.onExtrasChanged((Bundle)msg.obj);
                        break;
                    }
                    case 4: {
                        Callback.this.onAudioInfoChanged((PlaybackInfo)msg.obj);
                        break;
                    }
                    case 8: {
                        Callback.this.onSessionDestroyed();
                    }
                }
            }

            public void post(int what, Object obj, Bundle data) {
                this.obtainMessage(what, obj).sendToTarget();
            }
        }

        private class StubCompat
        extends IMediaControllerCallback.Stub {
            private StubCompat() {
            }

            @Override
            public void onEvent(String event, Bundle extras) throws RemoteException {
                Callback.this.mHandler.post(1, event, extras);
            }

            @Override
            public void onSessionDestroyed() throws RemoteException {
                Callback.this.mHandler.post(8, null, null);
            }

            @Override
            public void onPlaybackStateChanged(PlaybackStateCompat state) throws RemoteException {
                Callback.this.mHandler.post(2, state, null);
            }

            @Override
            public void onMetadataChanged(MediaMetadataCompat metadata) throws RemoteException {
                Callback.this.mHandler.post(3, metadata, null);
            }

            @Override
            public void onQueueChanged(List<MediaSessionCompat.QueueItem> queue) throws RemoteException {
                Callback.this.mHandler.post(5, queue, null);
            }

            @Override
            public void onQueueTitleChanged(CharSequence title) throws RemoteException {
                Callback.this.mHandler.post(6, title, null);
            }

            @Override
            public void onExtrasChanged(Bundle extras) throws RemoteException {
                Callback.this.mHandler.post(7, extras, null);
            }

            @Override
            public void onVolumeInfoChanged(ParcelableVolumeInfo info) throws RemoteException {
                PlaybackInfo pi = null;
                if (info != null) {
                    pi = new PlaybackInfo(info.volumeType, info.audioStream, info.controlType, info.maxVolume, info.currentVolume);
                }
                Callback.this.mHandler.post(4, pi, null);
            }
        }

        private class StubApi21
        implements MediaControllerCompatApi21.Callback {
            private StubApi21() {
            }

            public void onSessionDestroyed() {
                Callback.this.onSessionDestroyed();
            }

            public void onSessionEvent(String event, Bundle extras) {
                Callback.this.onSessionEvent(event, extras);
            }

            public void onPlaybackStateChanged(Object stateObj) {
                Callback.this.onPlaybackStateChanged(PlaybackStateCompat.fromPlaybackState(stateObj));
            }

            public void onMetadataChanged(Object metadataObj) {
                Callback.this.onMetadataChanged(MediaMetadataCompat.fromMediaMetadata(metadataObj));
            }
        }
    }
}

