/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react;

import com.facebook.react.LazyReactPackage;
import com.facebook.react.ReactInstanceManager;
import com.facebook.react.bridge.ModuleSpec;
import com.facebook.react.bridge.NativeModule;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.module.model.ReactModuleInfoProvider;
import com.facebook.react.modules.core.DefaultHardwareBackBtnHandler;
import com.facebook.react.modules.core.DeviceEventManagerModule;
import com.facebook.react.modules.core.ExceptionsManagerModule;
import com.facebook.react.modules.core.HeadlessJsTaskSupportModule;
import com.facebook.react.modules.core.Timing;
import com.facebook.react.modules.debug.SourceCodeModule;
import com.facebook.react.modules.deviceinfo.DeviceInfoModule;
import com.facebook.react.modules.systeminfo.AndroidInfoModule;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Provider;

class BridgeCorePackage
extends LazyReactPackage {
    private final ReactInstanceManager mReactInstanceManager;
    private final DefaultHardwareBackBtnHandler mHardwareBackBtnHandler;

    BridgeCorePackage(ReactInstanceManager reactInstanceManager, DefaultHardwareBackBtnHandler hardwareBackBtnHandler) {
        this.mReactInstanceManager = reactInstanceManager;
        this.mHardwareBackBtnHandler = hardwareBackBtnHandler;
    }

    @Override
    public List<ModuleSpec> getNativeModules(final ReactApplicationContext reactContext) {
        ArrayList<ModuleSpec> moduleSpecList = new ArrayList<ModuleSpec>();
        moduleSpecList.add(ModuleSpec.nativeModuleSpec(AndroidInfoModule.class, (Provider<? extends NativeModule>)new Provider<NativeModule>(){

            public NativeModule get() {
                return new AndroidInfoModule();
            }
        }));
        moduleSpecList.add(ModuleSpec.nativeModuleSpec(DeviceEventManagerModule.class, (Provider<? extends NativeModule>)new Provider<NativeModule>(){

            public NativeModule get() {
                return new DeviceEventManagerModule(reactContext, BridgeCorePackage.this.mHardwareBackBtnHandler);
            }
        }));
        moduleSpecList.add(ModuleSpec.nativeModuleSpec(ExceptionsManagerModule.class, (Provider<? extends NativeModule>)new Provider<NativeModule>(){

            public NativeModule get() {
                return new ExceptionsManagerModule(BridgeCorePackage.this.mReactInstanceManager.getDevSupportManager());
            }
        }));
        moduleSpecList.add(ModuleSpec.nativeModuleSpec(HeadlessJsTaskSupportModule.class, (Provider<? extends NativeModule>)new Provider<NativeModule>(){

            public NativeModule get() {
                return new HeadlessJsTaskSupportModule(reactContext);
            }
        }));
        moduleSpecList.add(ModuleSpec.nativeModuleSpec(SourceCodeModule.class, (Provider<? extends NativeModule>)new Provider<NativeModule>(){

            public NativeModule get() {
                return new SourceCodeModule(reactContext);
            }
        }));
        moduleSpecList.add(ModuleSpec.nativeModuleSpec(Timing.class, (Provider<? extends NativeModule>)new Provider<NativeModule>(){

            public NativeModule get() {
                return new Timing(reactContext, BridgeCorePackage.this.mReactInstanceManager.getDevSupportManager());
            }
        }));
        moduleSpecList.add(ModuleSpec.nativeModuleSpec(DeviceInfoModule.class, (Provider<? extends NativeModule>)new Provider<NativeModule>(){

            public NativeModule get() {
                return new DeviceInfoModule(reactContext);
            }
        }));
        return moduleSpecList;
    }

    @Override
    public ReactModuleInfoProvider getReactModuleInfoProvider() {
        return LazyReactPackage.getReactModuleInfoProviderViaReflection(this);
    }
}

