/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.platform;

import android.annotation.TargetApi;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import com.facebook.common.internal.Preconditions;
import com.facebook.common.memory.PooledByteBuffer;
import com.facebook.common.references.CloseableReference;
import com.facebook.imagepipeline.memory.FlexByteArrayPool;
import com.facebook.imagepipeline.platform.DalvikPurgeableDecoder;
import javax.annotation.concurrent.ThreadSafe;

@TargetApi(value=19)
@ThreadSafe
public class KitKatPurgeableDecoder
extends DalvikPurgeableDecoder {
    private final FlexByteArrayPool mFlexByteArrayPool;

    public KitKatPurgeableDecoder(FlexByteArrayPool flexByteArrayPool) {
        this.mFlexByteArrayPool = flexByteArrayPool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Bitmap decodeByteArrayAsPurgeable(CloseableReference<PooledByteBuffer> bytesRef, BitmapFactory.Options options) {
        PooledByteBuffer pooledByteBuffer = (PooledByteBuffer)bytesRef.get();
        int length = pooledByteBuffer.size();
        CloseableReference<byte[]> encodedBytesArrayRef = this.mFlexByteArrayPool.get(length);
        try {
            byte[] encodedBytesArray = (byte[])encodedBytesArrayRef.get();
            pooledByteBuffer.read(0, encodedBytesArray, 0, length);
            Bitmap bitmap = BitmapFactory.decodeByteArray((byte[])encodedBytesArray, (int)0, (int)length, (BitmapFactory.Options)options);
            Bitmap bitmap2 = (Bitmap)Preconditions.checkNotNull((Object)bitmap, (Object)"BitmapFactory returned null");
            return bitmap2;
        }
        finally {
            CloseableReference.closeSafely(encodedBytesArrayRef);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Bitmap decodeJPEGByteArrayAsPurgeable(CloseableReference<PooledByteBuffer> bytesRef, int length, BitmapFactory.Options options) {
        byte[] suffix = KitKatPurgeableDecoder.endsWithEOI(bytesRef, length) ? null : EOI;
        PooledByteBuffer pooledByteBuffer = (PooledByteBuffer)bytesRef.get();
        Preconditions.checkArgument((length <= pooledByteBuffer.size() ? 1 : 0) != 0);
        CloseableReference<byte[]> encodedBytesArrayRef = this.mFlexByteArrayPool.get(length + 2);
        try {
            byte[] encodedBytesArray = (byte[])encodedBytesArrayRef.get();
            pooledByteBuffer.read(0, encodedBytesArray, 0, length);
            if (suffix != null) {
                KitKatPurgeableDecoder.putEOI(encodedBytesArray, length);
                length += 2;
            }
            Bitmap bitmap = BitmapFactory.decodeByteArray((byte[])encodedBytesArray, (int)0, (int)length, (BitmapFactory.Options)options);
            Bitmap bitmap2 = (Bitmap)Preconditions.checkNotNull((Object)bitmap, (Object)"BitmapFactory returned null");
            return bitmap2;
        }
        finally {
            CloseableReference.closeSafely(encodedBytesArrayRef);
        }
    }

    private static void putEOI(byte[] imageBytes, int offset) {
        imageBytes[offset] = -1;
        imageBytes[offset + 1] = -39;
    }
}

