/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react;

import android.view.KeyEvent;
import android.view.View;
import com.facebook.react.ReactRootView;
import com.facebook.react.bridge.WritableNativeMap;
import com.facebook.react.common.MapBuilder;
import java.util.Map;

public class ReactAndroidHWInputDeviceHelper {
    private static final Map<Integer, String> KEY_EVENTS_ACTIONS = MapBuilder.of(23, "select", 66, "select", 62, "select", 85, "playPause", 89, "rewind", 90, "fastForward");
    private int mLastFocusedViewId = -1;
    private final ReactRootView mReactRootView;

    ReactAndroidHWInputDeviceHelper(ReactRootView mReactRootView) {
        this.mReactRootView = mReactRootView;
    }

    public void handleKeyEvent(KeyEvent ev) {
        int eventKeyCode = ev.getKeyCode();
        int eventKeyAction = ev.getAction();
        if (eventKeyAction == 1 && KEY_EVENTS_ACTIONS.containsKey(eventKeyCode)) {
            this.dispatchEvent(KEY_EVENTS_ACTIONS.get(eventKeyCode), this.mLastFocusedViewId);
        }
    }

    public void onFocusChanged(View newFocusedView) {
        if (this.mLastFocusedViewId == newFocusedView.getId()) {
            return;
        }
        if (this.mLastFocusedViewId != -1) {
            this.dispatchEvent("blur", this.mLastFocusedViewId);
        }
        this.mLastFocusedViewId = newFocusedView.getId();
        this.dispatchEvent("focus", newFocusedView.getId());
    }

    public void clearFocus() {
        if (this.mLastFocusedViewId != -1) {
            this.dispatchEvent("blur", this.mLastFocusedViewId);
        }
        this.mLastFocusedViewId = -1;
    }

    private void dispatchEvent(String eventType, int targetViewId) {
        WritableNativeMap event = new WritableNativeMap();
        event.putString("eventType", eventType);
        if (targetViewId != -1) {
            event.putInt("tag", targetViewId);
        }
        this.mReactRootView.sendEvent("onHWKeyEvent", event);
    }
}

