/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.uimanager;

import android.util.SparseBooleanArray;
import com.facebook.infer.annotation.Assertions;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.ReadableMapKeySetIterator;
import com.facebook.react.uimanager.ReactShadowNode;
import com.facebook.react.uimanager.ReactStylesDiffMap;
import com.facebook.react.uimanager.ShadowNodeRegistry;
import com.facebook.react.uimanager.ThemedReactContext;
import com.facebook.react.uimanager.UIViewOperationQueue;
import com.facebook.react.uimanager.ViewAtIndex;
import com.facebook.react.uimanager.ViewProps;
import javax.annotation.Nullable;

public class NativeViewHierarchyOptimizer {
    private static final boolean ENABLED = true;
    private final UIViewOperationQueue mUIViewOperationQueue;
    private final ShadowNodeRegistry mShadowNodeRegistry;
    private final SparseBooleanArray mTagsWithLayoutVisited = new SparseBooleanArray();

    public NativeViewHierarchyOptimizer(UIViewOperationQueue uiViewOperationQueue, ShadowNodeRegistry shadowNodeRegistry) {
        this.mUIViewOperationQueue = uiViewOperationQueue;
        this.mShadowNodeRegistry = shadowNodeRegistry;
    }

    public void handleCreateView(ReactShadowNode node, ThemedReactContext themedContext, @Nullable ReactStylesDiffMap initialProps) {
        boolean isLayoutOnly = node.getViewClass().equals("RCTView") && NativeViewHierarchyOptimizer.isLayoutOnlyAndCollapsable(initialProps);
        node.setIsLayoutOnly(isLayoutOnly);
        if (!isLayoutOnly) {
            this.mUIViewOperationQueue.enqueueCreateView(themedContext, node.getReactTag(), node.getViewClass(), initialProps);
        }
    }

    public static void handleRemoveNode(ReactShadowNode node) {
        node.removeAllNativeChildren();
    }

    public void handleUpdateView(ReactShadowNode node, String className, ReactStylesDiffMap props) {
        boolean needsToLeaveLayoutOnly;
        boolean bl = needsToLeaveLayoutOnly = node.isLayoutOnly() && !NativeViewHierarchyOptimizer.isLayoutOnlyAndCollapsable(props);
        if (needsToLeaveLayoutOnly) {
            this.transitionLayoutOnlyViewToNativeView(node, props);
        } else if (!node.isLayoutOnly()) {
            this.mUIViewOperationQueue.enqueueUpdateProperties(node.getReactTag(), className, props);
        }
    }

    public void handleManageChildren(ReactShadowNode nodeToManage, int[] indicesToRemove, int[] tagsToRemove, ViewAtIndex[] viewsToAdd, int[] tagsToDelete) {
        int i;
        for (i = 0; i < tagsToRemove.length; ++i) {
            int tagToRemove = tagsToRemove[i];
            boolean delete = false;
            for (int j = 0; j < tagsToDelete.length; ++j) {
                if (tagsToDelete[j] != tagToRemove) continue;
                delete = true;
                break;
            }
            ReactShadowNode nodeToRemove = this.mShadowNodeRegistry.getNode(tagToRemove);
            this.removeNodeFromParent(nodeToRemove, delete);
        }
        for (i = 0; i < viewsToAdd.length; ++i) {
            ViewAtIndex toAdd = viewsToAdd[i];
            ReactShadowNode nodeToAdd = this.mShadowNodeRegistry.getNode(toAdd.mTag);
            this.addNodeToNode(nodeToManage, nodeToAdd, toAdd.mIndex);
        }
    }

    public void handleSetChildren(ReactShadowNode nodeToManage, ReadableArray childrenTags) {
        for (int i = 0; i < childrenTags.size(); ++i) {
            ReactShadowNode nodeToAdd = this.mShadowNodeRegistry.getNode(childrenTags.getInt(i));
            this.addNodeToNode(nodeToManage, nodeToAdd, i);
        }
    }

    public void handleUpdateLayout(ReactShadowNode node) {
        this.applyLayoutBase(node);
    }

    public void onBatchComplete() {
        this.mTagsWithLayoutVisited.clear();
    }

    private NodeIndexPair walkUpUntilNonLayoutOnly(ReactShadowNode node, int indexInNativeChildren) {
        while (node.isLayoutOnly()) {
            ReactShadowNode parent = node.getParent();
            if (parent == null) {
                return null;
            }
            indexInNativeChildren += parent.getNativeOffsetForChild((ReactShadowNode)node);
            node = parent;
        }
        return new NodeIndexPair(node, indexInNativeChildren);
    }

    private void addNodeToNode(ReactShadowNode parent, ReactShadowNode child, int index) {
        int indexInNativeChildren = parent.getNativeOffsetForChild(parent.getChildAt(index));
        if (parent.isLayoutOnly()) {
            NodeIndexPair result = this.walkUpUntilNonLayoutOnly(parent, indexInNativeChildren);
            if (result == null) {
                return;
            }
            parent = result.node;
            indexInNativeChildren = result.index;
        }
        if (!child.isLayoutOnly()) {
            this.addNonLayoutNode(parent, child, indexInNativeChildren);
        } else {
            this.addLayoutOnlyNode(parent, child, indexInNativeChildren);
        }
    }

    private void removeNodeFromParent(ReactShadowNode nodeToRemove, boolean shouldDelete) {
        ReactShadowNode nativeNodeToRemoveFrom = nodeToRemove.getNativeParent();
        if (nativeNodeToRemoveFrom != null) {
            int[] nArray;
            int index = nativeNodeToRemoveFrom.indexOfNativeChild((ReactShadowNode)nodeToRemove);
            nativeNodeToRemoveFrom.removeNativeChildAt(index);
            int n = nativeNodeToRemoveFrom.getReactTag();
            int[] nArray2 = new int[]{index};
            if (shouldDelete) {
                int[] nArray3 = new int[1];
                nArray = nArray3;
                nArray3[0] = nodeToRemove.getReactTag();
            } else {
                nArray = null;
            }
            this.mUIViewOperationQueue.enqueueManageChildren(n, nArray2, null, nArray);
        } else {
            for (int i = nodeToRemove.getChildCount() - 1; i >= 0; --i) {
                this.removeNodeFromParent((ReactShadowNode)nodeToRemove.getChildAt(i), shouldDelete);
            }
        }
    }

    private void addLayoutOnlyNode(ReactShadowNode nonLayoutOnlyNode, ReactShadowNode layoutOnlyNode, int index) {
        this.addGrandchildren(nonLayoutOnlyNode, layoutOnlyNode, index);
    }

    private void addNonLayoutNode(ReactShadowNode parent, ReactShadowNode child, int index) {
        parent.addNativeChildAt(child, index);
        this.mUIViewOperationQueue.enqueueManageChildren(parent.getReactTag(), null, new ViewAtIndex[]{new ViewAtIndex(child.getReactTag(), index)}, null);
    }

    private void addGrandchildren(ReactShadowNode nativeParent, ReactShadowNode child, int index) {
        Assertions.assertCondition((!nativeParent.isLayoutOnly() ? 1 : 0) != 0);
        int currentIndex = index;
        for (int i = 0; i < child.getChildCount(); ++i) {
            Object grandchild = child.getChildAt(i);
            Assertions.assertCondition((grandchild.getNativeParent() == null ? 1 : 0) != 0);
            if (grandchild.isLayoutOnly()) {
                int grandchildCountBefore = nativeParent.getNativeChildCount();
                this.addLayoutOnlyNode(nativeParent, (ReactShadowNode)grandchild, currentIndex);
                int grandchildCountAfter = nativeParent.getNativeChildCount();
                currentIndex += grandchildCountAfter - grandchildCountBefore;
                continue;
            }
            this.addNonLayoutNode(nativeParent, (ReactShadowNode)grandchild, currentIndex);
            ++currentIndex;
        }
    }

    private void applyLayoutBase(ReactShadowNode node) {
        int tag = node.getReactTag();
        if (this.mTagsWithLayoutVisited.get(tag)) {
            return;
        }
        this.mTagsWithLayoutVisited.put(tag, true);
        int x = node.getScreenX();
        int y = node.getScreenY();
        for (Object parent = node.getParent(); parent != null && parent.isLayoutOnly(); parent = parent.getParent()) {
            x += Math.round(parent.getLayoutX());
            y += Math.round(parent.getLayoutY());
        }
        this.applyLayoutRecursive(node, x, y);
    }

    private void applyLayoutRecursive(ReactShadowNode toUpdate, int x, int y) {
        if (!toUpdate.isLayoutOnly() && toUpdate.getNativeParent() != null) {
            int tag = toUpdate.getReactTag();
            this.mUIViewOperationQueue.enqueueUpdateLayout(toUpdate.getNativeParent().getReactTag(), tag, x, y, toUpdate.getScreenWidth(), toUpdate.getScreenHeight());
            return;
        }
        for (int i = 0; i < toUpdate.getChildCount(); ++i) {
            Object child = toUpdate.getChildAt(i);
            int childTag = child.getReactTag();
            if (this.mTagsWithLayoutVisited.get(childTag)) continue;
            this.mTagsWithLayoutVisited.put(childTag, true);
            int childX = child.getScreenX();
            int childY = child.getScreenY();
            this.applyLayoutRecursive((ReactShadowNode)child, childX += x, childY += y);
        }
    }

    private void transitionLayoutOnlyViewToNativeView(ReactShadowNode node, @Nullable ReactStylesDiffMap props) {
        int i;
        ReactShadowNode parent = node.getParent();
        if (parent == null) {
            node.setIsLayoutOnly(false);
            return;
        }
        int childIndex = parent.indexOf((ReactShadowNode)node);
        parent.removeChildAt(childIndex);
        this.removeNodeFromParent(node, false);
        node.setIsLayoutOnly(false);
        this.mUIViewOperationQueue.enqueueCreateView(node.getRootNode().getThemedContext(), node.getReactTag(), node.getViewClass(), props);
        parent.addChildAt((ReactShadowNode)node, childIndex);
        this.addNodeToNode(parent, node, childIndex);
        for (i = 0; i < node.getChildCount(); ++i) {
            this.addNodeToNode(node, (ReactShadowNode)node.getChildAt(i), i);
        }
        Assertions.assertCondition((this.mTagsWithLayoutVisited.size() == 0 ? 1 : 0) != 0);
        this.applyLayoutBase(node);
        for (i = 0; i < node.getChildCount(); ++i) {
            this.applyLayoutBase((ReactShadowNode)node.getChildAt(i));
        }
        this.mTagsWithLayoutVisited.clear();
    }

    private static boolean isLayoutOnlyAndCollapsable(@Nullable ReactStylesDiffMap props) {
        if (props == null) {
            return true;
        }
        if (props.hasKey("collapsable") && !props.getBoolean("collapsable", true)) {
            return false;
        }
        ReadableMapKeySetIterator keyIterator = props.mBackingMap.keySetIterator();
        while (keyIterator.hasNextKey()) {
            if (ViewProps.isLayoutOnly(props.mBackingMap, keyIterator.nextKey())) continue;
            return false;
        }
        return true;
    }

    private static class NodeIndexPair {
        public final ReactShadowNode node;
        public final int index;

        NodeIndexPair(ReactShadowNode node, int index) {
            this.node = node;
            this.index = index;
        }
    }
}

