/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.modules.core;

import com.facebook.common.logging.FLog;
import com.facebook.infer.annotation.Assertions;
import com.facebook.react.bridge.UiThreadUtil;
import com.facebook.react.modules.core.ChoreographerCompat;
import java.util.ArrayDeque;

public class ReactChoreographer {
    private static ReactChoreographer sInstance;
    private final ChoreographerCompat mChoreographer = ChoreographerCompat.getInstance();
    private final ReactChoreographerDispatcher mReactChoreographerDispatcher = new ReactChoreographerDispatcher();
    private final ArrayDeque<ChoreographerCompat.FrameCallback>[] mCallbackQueues = new ArrayDeque[CallbackType.values().length];
    private int mTotalCallbacks = 0;
    private boolean mHasPostedCallback = false;

    public static void initialize() {
        if (sInstance == null) {
            UiThreadUtil.assertOnUiThread();
            sInstance = new ReactChoreographer();
        }
    }

    public static ReactChoreographer getInstance() {
        Assertions.assertNotNull((Object)sInstance, (String)"ReactChoreographer needs to be initialized.");
        return sInstance;
    }

    private ReactChoreographer() {
        for (int i = 0; i < this.mCallbackQueues.length; ++i) {
            this.mCallbackQueues[i] = new ArrayDeque();
        }
    }

    public synchronized void postFrameCallback(CallbackType type, ChoreographerCompat.FrameCallback frameCallback) {
        this.mCallbackQueues[type.getOrder()].addLast(frameCallback);
        ++this.mTotalCallbacks;
        Assertions.assertCondition((this.mTotalCallbacks > 0 ? 1 : 0) != 0);
        if (!this.mHasPostedCallback) {
            this.mChoreographer.postFrameCallback(this.mReactChoreographerDispatcher);
            this.mHasPostedCallback = true;
        }
    }

    public synchronized void removeFrameCallback(CallbackType type, ChoreographerCompat.FrameCallback frameCallback) {
        if (this.mCallbackQueues[type.getOrder()].removeFirstOccurrence(frameCallback)) {
            --this.mTotalCallbacks;
            this.maybeRemoveFrameCallback();
        } else {
            FLog.e((String)"ReactNative", (String)"Tried to remove non-existent frame callback");
        }
    }

    private void maybeRemoveFrameCallback() {
        Assertions.assertCondition((this.mTotalCallbacks >= 0 ? 1 : 0) != 0);
        if (this.mTotalCallbacks == 0 && this.mHasPostedCallback) {
            this.mChoreographer.removeFrameCallback(this.mReactChoreographerDispatcher);
            this.mHasPostedCallback = false;
        }
    }

    private class ReactChoreographerDispatcher
    extends ChoreographerCompat.FrameCallback {
        private ReactChoreographerDispatcher() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void doFrame(long frameTimeNanos) {
            ReactChoreographer reactChoreographer = ReactChoreographer.this;
            synchronized (reactChoreographer) {
                ReactChoreographer.this.mHasPostedCallback = false;
                for (int i = 0; i < ReactChoreographer.this.mCallbackQueues.length; ++i) {
                    int initialLength = ReactChoreographer.this.mCallbackQueues[i].size();
                    for (int callback = 0; callback < initialLength; ++callback) {
                        ((ChoreographerCompat.FrameCallback)ReactChoreographer.this.mCallbackQueues[i].removeFirst()).doFrame(frameTimeNanos);
                        ReactChoreographer.this.mTotalCallbacks--;
                    }
                }
                ReactChoreographer.this.maybeRemoveFrameCallback();
            }
        }
    }

    public static enum CallbackType {
        PERF_MARKERS(0),
        DISPATCH_UI(1),
        NATIVE_ANIMATED_MODULE(2),
        TIMERS_EVENTS(3),
        IDLE_EVENT(4);

        private final int mOrder;

        private CallbackType(int order) {
            this.mOrder = order;
        }

        int getOrder() {
            return this.mOrder;
        }
    }
}

