/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.bitmaps;

import android.annotation.TargetApi;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.os.Build;
import com.facebook.common.internal.Preconditions;
import com.facebook.common.internal.Throwables;
import com.facebook.common.references.CloseableReference;
import com.facebook.common.references.ResourceReleaser;
import com.facebook.imageformat.ImageFormat;
import com.facebook.imagepipeline.bitmaps.EmptyJpegGenerator;
import com.facebook.imagepipeline.bitmaps.TooManyBitmapsException;
import com.facebook.imagepipeline.image.EncodedImage;
import com.facebook.imagepipeline.memory.BitmapCounter;
import com.facebook.imagepipeline.memory.BitmapCounterProvider;
import com.facebook.imagepipeline.memory.FlexByteArrayPool;
import com.facebook.imagepipeline.memory.PooledByteBuffer;
import com.facebook.imagepipeline.nativecode.Bitmaps;
import java.util.ArrayList;
import java.util.List;

@TargetApi(value=11)
public class DalvikBitmapFactory {
    private final EmptyJpegGenerator mJpegGenerator;
    private final BitmapCounter mUnpooledBitmapsCounter;
    private final ResourceReleaser<Bitmap> mUnpooledBitmapsReleaser;
    private final FlexByteArrayPool mFlexByteArrayPool;

    public DalvikBitmapFactory(EmptyJpegGenerator jpegGenerator, FlexByteArrayPool flexByteArrayPool) {
        this.mJpegGenerator = jpegGenerator;
        this.mFlexByteArrayPool = flexByteArrayPool;
        this.mUnpooledBitmapsCounter = BitmapCounterProvider.get();
        this.mUnpooledBitmapsReleaser = new ResourceReleaser<Bitmap>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void release(Bitmap value) {
                try {
                    DalvikBitmapFactory.this.mUnpooledBitmapsCounter.decrease(value);
                }
                finally {
                    value.recycle();
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CloseableReference<Bitmap> createBitmap(short width, short height) {
        try (CloseableReference<PooledByteBuffer> jpgRef = this.mJpegGenerator.generate(width, height);){
            CloseableReference<Bitmap> closeableReference;
            EncodedImage encodedImage = new EncodedImage(jpgRef);
            encodedImage.setImageFormat(ImageFormat.JPEG);
            try {
                CloseableReference<Bitmap> bitmapRef = this.decodeJPEGFromEncodedImage(encodedImage, ((PooledByteBuffer)jpgRef.get()).size());
                ((Bitmap)bitmapRef.get()).eraseColor(0);
                closeableReference = bitmapRef;
            }
            catch (Throwable throwable) {
                EncodedImage.closeSafely(encodedImage);
                throw throwable;
            }
            EncodedImage.closeSafely(encodedImage);
            return closeableReference;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CloseableReference<Bitmap> decodeFromEncodedImage(EncodedImage encodedImage) {
        BitmapFactory.Options options = DalvikBitmapFactory.getBitmapFactoryOptions(encodedImage.getSampleSize());
        CloseableReference<PooledByteBuffer> bytesRef = encodedImage.getByteBufferRef();
        Preconditions.checkNotNull(bytesRef);
        try {
            Bitmap bitmap = this.decodeByteArrayAsPurgeable(bytesRef, options);
            CloseableReference<Bitmap> closeableReference = this.pinBitmap(bitmap);
            return closeableReference;
        }
        finally {
            CloseableReference.closeSafely(bytesRef);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CloseableReference<Bitmap> decodeJPEGFromEncodedImage(EncodedImage encodedImage, int length) {
        BitmapFactory.Options options = DalvikBitmapFactory.getBitmapFactoryOptions(encodedImage.getSampleSize());
        CloseableReference<PooledByteBuffer> bytesRef = encodedImage.getByteBufferRef();
        Preconditions.checkNotNull(bytesRef);
        try {
            Bitmap bitmap = this.decodeJPEGByteArrayAsPurgeable(bytesRef, length, options);
            CloseableReference<Bitmap> closeableReference = this.pinBitmap(bitmap);
            return closeableReference;
        }
        finally {
            CloseableReference.closeSafely(bytesRef);
        }
    }

    private CloseableReference<Bitmap> pinBitmap(Bitmap bitmap) {
        try {
            Bitmaps.pinBitmap(bitmap);
        }
        catch (Exception e) {
            bitmap.recycle();
            throw Throwables.propagate((Throwable)e);
        }
        if (!this.mUnpooledBitmapsCounter.increase(bitmap)) {
            bitmap.recycle();
            throw new TooManyBitmapsException();
        }
        return CloseableReference.of((Object)bitmap, this.mUnpooledBitmapsReleaser);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Bitmap decodeByteArrayAsPurgeable(CloseableReference<PooledByteBuffer> bytesRef, BitmapFactory.Options options) {
        PooledByteBuffer pooledByteBuffer = (PooledByteBuffer)bytesRef.get();
        int length = pooledByteBuffer.size();
        CloseableReference<byte[]> encodedBytesArrayRef = this.mFlexByteArrayPool.get(length);
        try {
            byte[] encodedBytesArray = (byte[])encodedBytesArrayRef.get();
            pooledByteBuffer.read(0, encodedBytesArray, 0, length);
            Bitmap bitmap = BitmapFactory.decodeByteArray((byte[])encodedBytesArray, (int)0, (int)length, (BitmapFactory.Options)options);
            Bitmap bitmap2 = (Bitmap)Preconditions.checkNotNull((Object)bitmap, (Object)"BitmapFactory returned null");
            return bitmap2;
        }
        finally {
            CloseableReference.closeSafely(encodedBytesArrayRef);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Bitmap decodeJPEGByteArrayAsPurgeable(CloseableReference<PooledByteBuffer> bytesRef, int length, BitmapFactory.Options options) {
        PooledByteBuffer pooledByteBuffer = (PooledByteBuffer)bytesRef.get();
        Preconditions.checkArgument((length <= pooledByteBuffer.size() ? 1 : 0) != 0);
        CloseableReference<byte[]> encodedBytesArrayRef = this.mFlexByteArrayPool.get(length + 2);
        try {
            byte[] encodedBytesArray = (byte[])encodedBytesArrayRef.get();
            pooledByteBuffer.read(0, encodedBytesArray, 0, length);
            if (!DalvikBitmapFactory.endsWithEOI(encodedBytesArray, length)) {
                DalvikBitmapFactory.putEOI(encodedBytesArray, length);
                length += 2;
            }
            Bitmap bitmap = BitmapFactory.decodeByteArray((byte[])encodedBytesArray, (int)0, (int)length, (BitmapFactory.Options)options);
            Bitmap bitmap2 = (Bitmap)Preconditions.checkNotNull((Object)bitmap, (Object)"BitmapFactory returned null");
            return bitmap2;
        }
        finally {
            CloseableReference.closeSafely(encodedBytesArrayRef);
        }
    }

    private static BitmapFactory.Options getBitmapFactoryOptions(int sampleSize) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inDither = true;
        options.inPreferredConfig = Bitmaps.BITMAP_CONFIG;
        options.inPurgeable = true;
        options.inSampleSize = sampleSize;
        if (Build.VERSION.SDK_INT >= 11) {
            options.inMutable = true;
        }
        return options;
    }

    private static void putEOI(byte[] imageBytes, int offset) {
        imageBytes[offset] = -1;
        imageBytes[offset + 1] = -39;
    }

    private static boolean endsWithEOI(byte[] imageBytes, int length) {
        return length >= 2 && imageBytes[length - 2] == -1 && imageBytes[length - 1] == -39;
    }

    List<CloseableReference<Bitmap>> associateBitmapsWithBitmapCounter(List<Bitmap> bitmaps) {
        int countedBitmaps;
        try {
            for (countedBitmaps = 0; countedBitmaps < bitmaps.size(); ++countedBitmaps) {
                Bitmap bitmap = bitmaps.get(countedBitmaps);
                Bitmaps.pinBitmap(bitmap);
                if (this.mUnpooledBitmapsCounter.increase(bitmap)) continue;
                throw new TooManyBitmapsException();
            }
            ArrayList<CloseableReference<Bitmap>> ret = new ArrayList<CloseableReference<Bitmap>>();
            for (Bitmap bitmap : bitmaps) {
                ret.add((CloseableReference<Bitmap>)CloseableReference.of((Object)bitmap, this.mUnpooledBitmapsReleaser));
            }
            return ret;
        }
        catch (Exception exception) {
            if (bitmaps != null) {
                for (Bitmap bitmap : bitmaps) {
                    if (countedBitmaps-- > 0) {
                        this.mUnpooledBitmapsCounter.decrease(bitmap);
                    }
                    bitmap.recycle();
                }
            }
            throw Throwables.propagate((Throwable)exception);
        }
    }
}

