/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.modules.core;

import com.facebook.common.logging.FLog;
import com.facebook.react.bridge.BaseJavaModule;
import com.facebook.react.bridge.ReactMethod;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.devsupport.DevSupportManager;
import com.facebook.react.modules.core.JavascriptException;
import java.io.File;

public class ExceptionsManagerModule
extends BaseJavaModule {
    private final DevSupportManager mDevSupportManager;

    public ExceptionsManagerModule(DevSupportManager devSupportManager) {
        this.mDevSupportManager = devSupportManager;
    }

    @Override
    public String getName() {
        return "RKExceptionsManager";
    }

    private String stackTraceToString(ReadableArray stack) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < stack.size(); ++i) {
            ReadableMap frame = stack.getMap(i);
            stringBuilder.append(frame.getString("methodName"));
            stringBuilder.append("\n    ");
            stringBuilder.append(new File(frame.getString("file")).getName());
            stringBuilder.append(":");
            stringBuilder.append(frame.getInt("lineNumber"));
            if (frame.hasKey("column") && !frame.isNull("column")) {
                stringBuilder.append(":").append(frame.getInt("column"));
            }
            stringBuilder.append("\n");
        }
        return stringBuilder.toString();
    }

    @ReactMethod
    public void reportFatalException(String title, ReadableArray details, int exceptionId) {
        this.showOrThrowError(title, details, exceptionId);
    }

    @ReactMethod
    public void reportSoftException(String title, ReadableArray details) {
        FLog.e((String)"React", (String)(title + "\n" + this.stackTraceToString(details)));
    }

    private void showOrThrowError(String title, ReadableArray details, int exceptionId) {
        if (!this.mDevSupportManager.getDevSupportEnabled()) {
            throw new JavascriptException(this.stackTraceToString(details));
        }
        this.mDevSupportManager.showNewJSError(title, details, exceptionId);
    }

    @ReactMethod
    public void updateExceptionMessage(String title, ReadableArray details, int exceptionId) {
        if (this.mDevSupportManager.getDevSupportEnabled()) {
            this.mDevSupportManager.updateJSError(title, details, exceptionId);
        }
    }
}

