/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.uimanager;

import com.facebook.react.bridge.Arguments;
import com.facebook.react.bridge.WritableMap;
import com.facebook.react.uimanager.PixelUtil;
import com.facebook.react.uimanager.events.Event;
import com.facebook.react.uimanager.events.RCTEventEmitter;

class OnLayoutEvent
extends Event<OnLayoutEvent> {
    private final int mX;
    private final int mY;
    private final int mWidth;
    private final int mHeight;

    protected OnLayoutEvent(int viewTag, int x, int y, int width, int height) {
        super(viewTag, 0L);
        this.mX = x;
        this.mY = y;
        this.mWidth = width;
        this.mHeight = height;
    }

    @Override
    public String getEventName() {
        return "topLayout";
    }

    @Override
    public void dispatch(RCTEventEmitter rctEventEmitter) {
        WritableMap layout2 = Arguments.createMap();
        layout2.putDouble("x", PixelUtil.toDIPFromPixel(this.mX));
        layout2.putDouble("y", PixelUtil.toDIPFromPixel(this.mY));
        layout2.putDouble("width", PixelUtil.toDIPFromPixel(this.mWidth));
        layout2.putDouble("height", PixelUtil.toDIPFromPixel(this.mHeight));
        WritableMap event = Arguments.createMap();
        event.putMap("layout", layout2);
        event.putInt("target", this.getViewTag());
        rctEventEmitter.receiveEvent(this.getViewTag(), this.getEventName(), event);
    }
}

