/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.uimanager;

import com.facebook.react.animation.Animation;
import com.facebook.react.animation.AnimationRegistry;
import com.facebook.react.bridge.Callback;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReactContext;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.uimanager.CatalystStylesDiffMap;
import com.facebook.react.uimanager.GuardedChoreographerFrameCallback;
import com.facebook.react.uimanager.IllegalViewOperationException;
import com.facebook.react.uimanager.NativeViewHierarchyManager;
import com.facebook.react.uimanager.NoSuchNativeViewException;
import com.facebook.react.uimanager.PixelUtil;
import com.facebook.react.uimanager.ReactChoreographer;
import com.facebook.react.uimanager.UIManagerModule;
import com.facebook.react.uimanager.ViewAtIndex;
import com.facebook.systrace.Systrace;
import com.facebook.systrace.SystraceMessage;
import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;

public class UIViewOperationQueue {
    private final int[] mMeasureBuffer = new int[4];
    private ArrayList<UIOperation> mOperations = new ArrayList();
    private final UIManagerModule mUIManagerModule;
    private final NativeViewHierarchyManager mNativeViewHierarchyManager;
    private final AnimationRegistry mAnimationRegistry;
    private final Object mDispatchRunnablesLock = new Object();
    private final DispatchUIFrameCallback mDispatchUIFrameCallback;
    @GuardedBy(value="mDispatchRunnablesLock")
    private final ArrayList<Runnable> mDispatchUIRunnables = new ArrayList();

    UIViewOperationQueue(ReactApplicationContext reactContext, UIManagerModule uiManagerModule, NativeViewHierarchyManager nativeViewHierarchyManager, AnimationRegistry animationRegistry) {
        this.mUIManagerModule = uiManagerModule;
        this.mNativeViewHierarchyManager = nativeViewHierarchyManager;
        this.mAnimationRegistry = animationRegistry;
        this.mDispatchUIFrameCallback = new DispatchUIFrameCallback(reactContext);
    }

    public boolean isEmpty() {
        return this.mOperations.isEmpty();
    }

    public void enqueueRemoveRootView(int rootViewTag) {
        this.mOperations.add(new RemoveRootViewOperation(rootViewTag));
    }

    public void enqueueSetJSResponder(int reactTag, boolean blockNativeResponder) {
        this.mOperations.add(new ChangeJSResponderOperation(reactTag, false, blockNativeResponder));
    }

    public void enqueueClearJSResponder() {
        this.mOperations.add(new ChangeJSResponderOperation(0, true, false));
    }

    public void enqueueDispatchCommand(int reactTag, int commandId, ReadableArray commandArgs) {
        this.mOperations.add(new DispatchCommandOperation(reactTag, commandId, commandArgs));
    }

    public void enqueueUpdateExtraData(int reactTag, Object extraData) {
        this.mOperations.add(new UpdateViewExtraData(reactTag, extraData));
    }

    public void enqueueShowPopupMenu(int reactTag, ReadableArray items, Callback error, Callback success) {
        this.mOperations.add(new ShowPopupMenuOperation(reactTag, items, success));
    }

    public void enqueueCreateView(int rootViewTagForContext, int viewReactTag, String viewClassName, @Nullable CatalystStylesDiffMap initialProps) {
        this.mOperations.add(new CreateViewOperation(rootViewTagForContext, viewReactTag, viewClassName, initialProps));
    }

    public void enqueueUpdateProperties(int reactTag, String className, CatalystStylesDiffMap props) {
        this.mOperations.add(new UpdatePropertiesOperation(reactTag, props));
    }

    public void enqueueUpdateLayout(int parentTag, int reactTag, int x, int y, int width, int height) {
        this.mOperations.add(new UpdateLayoutOperation(parentTag, reactTag, x, y, width, height));
    }

    public void enqueueManageChildren(int reactTag, @Nullable int[] indicesToRemove, @Nullable ViewAtIndex[] viewsToAdd, @Nullable int[] tagsToDelete) {
        this.mOperations.add(new ManageChildrenOperation(reactTag, indicesToRemove, viewsToAdd, tagsToDelete));
    }

    public void enqueueRegisterAnimation(Animation animation) {
        this.mOperations.add(new RegisterAnimationOperation(animation));
    }

    public void enqueueAddAnimation(int reactTag, int animationID, Callback onSuccess) {
        this.mOperations.add(new AddAnimationOperation(reactTag, animationID, onSuccess));
    }

    public void enqueueRemoveAnimation(int animationID) {
        this.mOperations.add(new RemoveAnimationOperation(animationID));
    }

    public void enqueueMeasure(int reactTag, Callback callback) {
        this.mOperations.add(new MeasureOperation(reactTag, callback));
    }

    public void enqueueFindTargetForTouch(int reactTag, float targetX, float targetY, Callback callback) {
        this.mOperations.add(new FindTargetForTouchOperation(reactTag, targetX, targetY, callback));
    }

    public void enqueueSendAccessibilityEvent(int tag, int eventType) {
        this.mOperations.add(new SendAccessibilityEvent(tag, eventType));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dispatchViewUpdates(final int batchId) {
        ArrayList<UIOperation> operations;
        ArrayList<UIOperation> arrayList = operations = this.mOperations.isEmpty() ? null : this.mOperations;
        if (operations != null) {
            this.mOperations = new ArrayList();
        }
        this.mUIManagerModule.notifyOnViewHierarchyUpdateEnqueued();
        Object object = this.mDispatchRunnablesLock;
        synchronized (object) {
            this.mDispatchUIRunnables.add(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    SystraceMessage.beginSection(0L, "DispatchUI").arg("BatchId", batchId).flush();
                    try {
                        if (operations != null) {
                            for (int i = 0; i < operations.size(); ++i) {
                                ((UIOperation)operations.get(i)).execute();
                            }
                        }
                        UIViewOperationQueue.this.mUIManagerModule.notifyOnViewHierarchyUpdateFinished();
                    }
                    finally {
                        Systrace.endSection(0L);
                    }
                }
            });
        }
    }

    void resumeFrameCallback() {
        ReactChoreographer.getInstance().postFrameCallback(ReactChoreographer.CallbackType.DISPATCH_UI, this.mDispatchUIFrameCallback);
    }

    void pauseFrameCallback() {
        ReactChoreographer.getInstance().removeFrameCallback(ReactChoreographer.CallbackType.DISPATCH_UI, this.mDispatchUIFrameCallback);
    }

    private class DispatchUIFrameCallback
    extends GuardedChoreographerFrameCallback {
        private DispatchUIFrameCallback(ReactContext reactContext) {
            super(reactContext);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void doFrameGuarded(long frameTimeNanos) {
            Object object = UIViewOperationQueue.this.mDispatchRunnablesLock;
            synchronized (object) {
                for (int i = 0; i < UIViewOperationQueue.this.mDispatchUIRunnables.size(); ++i) {
                    ((Runnable)UIViewOperationQueue.this.mDispatchUIRunnables.get(i)).run();
                }
                UIViewOperationQueue.this.mDispatchUIRunnables.clear();
            }
            ReactChoreographer.getInstance().postFrameCallback(ReactChoreographer.CallbackType.DISPATCH_UI, this);
        }
    }

    private final class SendAccessibilityEvent
    extends ViewOperation {
        private final int mEventType;

        private SendAccessibilityEvent(int tag, int eventType) {
            super(tag);
            this.mEventType = eventType;
        }

        @Override
        public void execute() {
            UIViewOperationQueue.this.mNativeViewHierarchyManager.sendAccessibilityEvent(this.mTag, this.mEventType);
        }
    }

    private final class FindTargetForTouchOperation
    implements UIOperation {
        private final int mReactTag;
        private final float mTargetX;
        private final float mTargetY;
        private final Callback mCallback;

        private FindTargetForTouchOperation(int reactTag, float targetX, float targetY, Callback callback) {
            this.mReactTag = reactTag;
            this.mTargetX = targetX;
            this.mTargetY = targetY;
            this.mCallback = callback;
        }

        @Override
        public void execute() {
            try {
                UIViewOperationQueue.this.mNativeViewHierarchyManager.measure(this.mReactTag, UIViewOperationQueue.this.mMeasureBuffer);
            }
            catch (IllegalViewOperationException e) {
                this.mCallback.invoke(new Object[0]);
                return;
            }
            float containerX = UIViewOperationQueue.this.mMeasureBuffer[0];
            float containerY = UIViewOperationQueue.this.mMeasureBuffer[1];
            int touchTargetReactTag = UIViewOperationQueue.this.mNativeViewHierarchyManager.findTargetTagForTouch(this.mReactTag, PixelUtil.toPixelFromDIP(this.mTargetX) + containerX, PixelUtil.toPixelFromDIP(this.mTargetY) + containerY);
            try {
                UIViewOperationQueue.this.mNativeViewHierarchyManager.measure(touchTargetReactTag, UIViewOperationQueue.this.mMeasureBuffer);
            }
            catch (IllegalViewOperationException e) {
                this.mCallback.invoke(new Object[0]);
                return;
            }
            float x = PixelUtil.toDIPFromPixel((float)UIViewOperationQueue.this.mMeasureBuffer[0] - containerX);
            float y = PixelUtil.toDIPFromPixel((float)UIViewOperationQueue.this.mMeasureBuffer[1] - containerY);
            float width = PixelUtil.toDIPFromPixel(UIViewOperationQueue.this.mMeasureBuffer[2]);
            float height = PixelUtil.toDIPFromPixel(UIViewOperationQueue.this.mMeasureBuffer[3]);
            this.mCallback.invoke(touchTargetReactTag, Float.valueOf(x), Float.valueOf(y), Float.valueOf(width), Float.valueOf(height));
        }
    }

    private final class MeasureOperation
    implements UIOperation {
        private final int mReactTag;
        private final Callback mCallback;

        private MeasureOperation(int reactTag, Callback callback) {
            this.mReactTag = reactTag;
            this.mCallback = callback;
        }

        @Override
        public void execute() {
            try {
                UIViewOperationQueue.this.mNativeViewHierarchyManager.measure(this.mReactTag, UIViewOperationQueue.this.mMeasureBuffer);
            }
            catch (NoSuchNativeViewException e) {
                this.mCallback.invoke(new Object[0]);
                return;
            }
            float x = PixelUtil.toDIPFromPixel(UIViewOperationQueue.this.mMeasureBuffer[0]);
            float y = PixelUtil.toDIPFromPixel(UIViewOperationQueue.this.mMeasureBuffer[1]);
            float width = PixelUtil.toDIPFromPixel(UIViewOperationQueue.this.mMeasureBuffer[2]);
            float height = PixelUtil.toDIPFromPixel(UIViewOperationQueue.this.mMeasureBuffer[3]);
            this.mCallback.invoke(0, 0, Float.valueOf(width), Float.valueOf(height), Float.valueOf(x), Float.valueOf(y));
        }
    }

    private final class RemoveAnimationOperation
    extends AnimationOperation {
        private RemoveAnimationOperation(int animationID) {
            super(animationID);
        }

        @Override
        public void execute() {
            Animation animation = UIViewOperationQueue.this.mAnimationRegistry.getAnimation(this.mAnimationID);
            if (animation != null) {
                animation.cancel();
            }
        }
    }

    private class AddAnimationOperation
    extends AnimationOperation {
        private final int mReactTag;
        private final Callback mSuccessCallback;

        private AddAnimationOperation(int reactTag, int animationID, Callback successCallback) {
            super(animationID);
            this.mReactTag = reactTag;
            this.mSuccessCallback = successCallback;
        }

        @Override
        public void execute() {
            Animation animation = UIViewOperationQueue.this.mAnimationRegistry.getAnimation(this.mAnimationID);
            if (animation == null) {
                throw new IllegalViewOperationException("Animation with id " + this.mAnimationID + " was not found");
            }
            UIViewOperationQueue.this.mNativeViewHierarchyManager.startAnimationForNativeView(this.mReactTag, animation, this.mSuccessCallback);
        }
    }

    private class RegisterAnimationOperation
    extends AnimationOperation {
        private final Animation mAnimation;

        private RegisterAnimationOperation(Animation animation) {
            super(animation.getAnimationID());
            this.mAnimation = animation;
        }

        @Override
        public void execute() {
            UIViewOperationQueue.this.mAnimationRegistry.registerAnimation(this.mAnimation);
        }
    }

    private static abstract class AnimationOperation
    implements UIOperation {
        protected final int mAnimationID;

        public AnimationOperation(int animationID) {
            this.mAnimationID = animationID;
        }
    }

    private final class ShowPopupMenuOperation
    extends ViewOperation {
        private final ReadableArray mItems;
        private final Callback mSuccess;

        public ShowPopupMenuOperation(int tag, ReadableArray items, Callback success) {
            super(tag);
            this.mItems = items;
            this.mSuccess = success;
        }

        @Override
        public void execute() {
            UIViewOperationQueue.this.mNativeViewHierarchyManager.showPopupMenu(this.mTag, this.mItems, this.mSuccess);
        }
    }

    private final class DispatchCommandOperation
    extends ViewOperation {
        private final int mCommand;
        @Nullable
        private final ReadableArray mArgs;

        public DispatchCommandOperation(int tag, @Nullable int command, ReadableArray args) {
            super(tag);
            this.mCommand = command;
            this.mArgs = args;
        }

        @Override
        public void execute() {
            UIViewOperationQueue.this.mNativeViewHierarchyManager.dispatchCommand(this.mTag, this.mCommand, this.mArgs);
        }
    }

    private final class ChangeJSResponderOperation
    extends ViewOperation {
        private final boolean mBlockNativeResponder;
        private final boolean mClearResponder;

        public ChangeJSResponderOperation(int tag, boolean clearResponder, boolean blockNativeResponder) {
            super(tag);
            this.mClearResponder = clearResponder;
            this.mBlockNativeResponder = blockNativeResponder;
        }

        @Override
        public void execute() {
            if (!this.mClearResponder) {
                UIViewOperationQueue.this.mNativeViewHierarchyManager.setJSResponder(this.mTag, this.mBlockNativeResponder);
            } else {
                UIViewOperationQueue.this.mNativeViewHierarchyManager.clearJSResponder();
            }
        }
    }

    private final class UpdateViewExtraData
    extends ViewOperation {
        private final Object mExtraData;

        public UpdateViewExtraData(int tag, Object extraData) {
            super(tag);
            this.mExtraData = extraData;
        }

        @Override
        public void execute() {
            UIViewOperationQueue.this.mNativeViewHierarchyManager.updateViewExtraData(this.mTag, this.mExtraData);
        }
    }

    private final class ManageChildrenOperation
    extends ViewOperation {
        @Nullable
        private final int[] mIndicesToRemove;
        @Nullable
        private final ViewAtIndex[] mViewsToAdd;
        @Nullable
        private final int[] mTagsToDelete;

        public ManageChildrenOperation(@Nullable int tag, @Nullable int[] indicesToRemove, @Nullable ViewAtIndex[] viewsToAdd, int[] tagsToDelete) {
            super(tag);
            this.mIndicesToRemove = indicesToRemove;
            this.mViewsToAdd = viewsToAdd;
            this.mTagsToDelete = tagsToDelete;
        }

        @Override
        public void execute() {
            UIViewOperationQueue.this.mNativeViewHierarchyManager.manageChildren(this.mTag, this.mIndicesToRemove, this.mViewsToAdd, this.mTagsToDelete);
        }
    }

    private final class CreateViewOperation
    extends ViewOperation {
        private final int mRootViewTagForContext;
        private final String mClassName;
        @Nullable
        private final CatalystStylesDiffMap mInitialProps;

        public CreateViewOperation(int rootViewTagForContext, int tag, @Nullable String className, CatalystStylesDiffMap initialProps) {
            super(tag);
            this.mRootViewTagForContext = rootViewTagForContext;
            this.mClassName = className;
            this.mInitialProps = initialProps;
        }

        @Override
        public void execute() {
            UIViewOperationQueue.this.mNativeViewHierarchyManager.createView(this.mRootViewTagForContext, this.mTag, this.mClassName, this.mInitialProps);
        }
    }

    private final class UpdateLayoutOperation
    extends ViewOperation {
        private final int mParentTag;
        private final int mX;
        private final int mY;
        private final int mWidth;
        private final int mHeight;

        public UpdateLayoutOperation(int parentTag, int tag, int x, int y, int width, int height) {
            super(tag);
            this.mParentTag = parentTag;
            this.mX = x;
            this.mY = y;
            this.mWidth = width;
            this.mHeight = height;
        }

        @Override
        public void execute() {
            UIViewOperationQueue.this.mNativeViewHierarchyManager.updateLayout(this.mParentTag, this.mTag, this.mX, this.mY, this.mWidth, this.mHeight);
        }
    }

    private final class UpdatePropertiesOperation
    extends ViewOperation {
        private final CatalystStylesDiffMap mProps;

        private UpdatePropertiesOperation(int tag, CatalystStylesDiffMap props) {
            super(tag);
            this.mProps = props;
        }

        @Override
        public void execute() {
            UIViewOperationQueue.this.mNativeViewHierarchyManager.updateProperties(this.mTag, this.mProps);
        }
    }

    private final class RemoveRootViewOperation
    extends ViewOperation {
        public RemoveRootViewOperation(int tag) {
            super(tag);
        }

        @Override
        public void execute() {
            UIViewOperationQueue.this.mNativeViewHierarchyManager.removeRootView(this.mTag);
        }
    }

    private abstract class ViewOperation
    implements UIOperation {
        public int mTag;

        public ViewOperation(int tag) {
            this.mTag = tag;
        }
    }

    private static interface UIOperation {
        public void execute();
    }
}

