/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.uimanager.events;

import com.facebook.react.uimanager.events.RCTEventEmitter;

public abstract class Event<T extends Event> {
    private final int mViewTag;
    private final long mTimestampMs;

    protected Event(int viewTag, long timestampMs) {
        this.mViewTag = viewTag;
        this.mTimestampMs = timestampMs;
    }

    public final int getViewTag() {
        return this.mViewTag;
    }

    public final long getTimestampMs() {
        return this.mTimestampMs;
    }

    public boolean canCoalesce() {
        return true;
    }

    public T coalesce(T otherEvent) {
        return (T)(this.getTimestampMs() > ((Event)otherEvent).getTimestampMs() ? this : otherEvent);
    }

    public short getCoalescingKey() {
        return 0;
    }

    public void dispose() {
    }

    public abstract String getEventName();

    public abstract void dispatch(RCTEventEmitter var1);
}

